/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.settingsrestriction.result;

import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestriction;
import com.atlassian.stash.internal.settingsrestriction.result.ProcessorInfo;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

public class RestrictionProcessingResult {
    private final List<ProcessorInfo> processors;
    private final DmzProjectSettingsRestriction restriction;
    private final boolean restrictionProcessed;

    private RestrictionProcessingResult(Builder builder) {
        this.processors = builder.processors.build();
        this.restriction = builder.restriction;
        this.restrictionProcessed = builder.restrictionProcessed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RestrictionProcessingResult) {
            RestrictionProcessingResult that = (RestrictionProcessingResult)o;
            return Objects.equals(this.processors, that.processors) && this.restriction == that.restriction && this.restrictionProcessed == that.restrictionProcessed;
        }
        return false;
    }

    @Nonnull
    public List<ProcessorInfo> getProcessors() {
        return this.processors;
    }

    @Nonnull
    public DmzProjectSettingsRestriction getRestriction() {
        return this.restriction;
    }

    public int hashCode() {
        return Objects.hash(this.processors, this.restriction, this.restrictionProcessed);
    }

    public boolean isRestrictionProcessed() {
        return this.restrictionProcessed;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("processors", this.processors).add("restriction", (Object)this.restriction).add("restrictionProcessed", this.restrictionProcessed).toString();
    }

    public static class Builder {
        private final ImmutableList.Builder<ProcessorInfo> processors = ImmutableList.builder();
        private final DmzProjectSettingsRestriction restriction;
        private boolean restrictionProcessed;

        public Builder(@Nonnull DmzProjectSettingsRestriction restriction) {
            this.restriction = Objects.requireNonNull(restriction, "restriction");
        }

        @Nonnull
        public RestrictionProcessingResult build() {
            return new RestrictionProcessingResult(this);
        }

        @Nonnull
        public Builder processor(@Nonnull ProcessorInfo processor) {
            this.processors.add((Object)Objects.requireNonNull(processor, "processor"));
            return this;
        }

        @Nonnull
        public Builder restrictionProcessed(boolean restrictionProcessed) {
            this.restrictionProcessed = restrictionProcessed;
            return this;
        }
    }
}

