/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.settingsrestriction.scheduler;

import com.atlassian.bitbucket.concurrent.BucketProcessor;
import com.atlassian.bitbucket.concurrent.BucketedExecutor;
import com.atlassian.bitbucket.concurrent.BucketedExecutorSettings;
import com.atlassian.bitbucket.concurrent.ConcurrencyPolicy;
import com.atlassian.bitbucket.concurrent.ConcurrencyService;
import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestriction;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.RetryBackoffUtils;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.settingsrestriction.ProjectSettingsRestrictionProcessingRequest;
import com.atlassian.stash.internal.settingsrestriction.RestrictionProcessingBucketProcessor;
import com.atlassian.stash.internal.settingsrestriction.config.RestrictionProcessingConfigProvider;
import com.atlassian.stash.internal.settingsrestriction.scheduler.ProcessingRetryLimitExceededException;
import com.atlassian.stash.internal.settingsrestriction.scheduler.ProjectSettingsRestrictionProcessingScheduler;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="projectSettingsRestrictionProcessingScheduler")
@DefaultApplicationMode
public class DefaultProjectSettingsRestrictionProcessingScheduler
implements ProjectSettingsRestrictionProcessingScheduler {
    private static final String BUCKETED_EXECUTOR_NAME = "project-settings-restriction-processing";
    private static final String ERROR_KEY_RETRY_LIMIT_EXCEEDED = "bitbucket.service.settingsrestriction.error.processing.retrylimitexceeded";
    private static final Logger log = LoggerFactory.getLogger(DefaultProjectSettingsRestrictionProcessingScheduler.class);
    private final BucketedExecutor<ProjectSettingsRestrictionProcessingRequest> bucketedExecutor;
    private final RestrictionProcessingConfigProvider configProvider;
    private final I18nService i18nService;

    @Autowired
    public DefaultProjectSettingsRestrictionProcessingScheduler(RestrictionProcessingBucketProcessor bucketProcessor, ConcurrencyService concurrencyService, RestrictionProcessingConfigProvider configProvider, I18nService i18nService) {
        this.bucketedExecutor = concurrencyService.getBucketedExecutor(BUCKETED_EXECUTOR_NAME, new BucketedExecutorSettings.Builder(DefaultProjectSettingsRestrictionProcessingScheduler.toBucketId(), (BucketProcessor)bucketProcessor).batchSize(configProvider.getProcessingBatchSize()).maxAttempts(1).maxConcurrency(configProvider.getMaxProcessingThreads(), ConcurrencyPolicy.PER_NODE).build());
        this.configProvider = configProvider;
        this.i18nService = i18nService;
    }

    @Override
    public void submitForProcessing(@Nonnull DmzProjectSettingsRestriction restriction, @Nonnull Duration minimumDelay) {
        Objects.requireNonNull(restriction, "restriction");
        Objects.requireNonNull(minimumDelay, "minimumDelay");
        long minimumDelayMillis = minimumDelay.toMillis();
        ProjectSettingsRestrictionProcessingRequest request = new ProjectSettingsRestrictionProcessingRequest(restriction.getProject().getId(), restriction.getId());
        if (restriction.getProcessingAttempts() == 0) {
            this.submitRequest(request, minimumDelayMillis);
        } else {
            this.retryRequest(request, restriction.getProcessingAttempts(), minimumDelayMillis);
        }
    }

    private void retryRequest(ProjectSettingsRestrictionProcessingRequest request, int processingAttempts, long minimumDelayMillis) {
        if (processingAttempts > this.configProvider.getMaxRetryCount()) {
            throw new ProcessingRetryLimitExceededException(this.i18nService.createKeyedMessage(ERROR_KEY_RETRY_LIMIT_EXCEEDED, new Object[]{request.getRestrictionId(), this.configProvider.getMaxRetryCount()}));
        }
        Duration backoffDelay = RetryBackoffUtils.calculateDelay((int)processingAttempts, (Duration)this.configProvider.getMinRetryDelay(), (Duration)this.configProvider.getMaxRetryDelay());
        long finalDelayMillis = Math.max(minimumDelayMillis, backoffDelay.toMillis());
        this.bucketedExecutor.schedule((Serializable)request, finalDelayMillis, TimeUnit.MILLISECONDS);
        log.debug("Retrying processing for restriction {} after {} milliseconds", (Object)request, (Object)finalDelayMillis);
    }

    private void submitRequest(ProjectSettingsRestrictionProcessingRequest request, long minimumDelayMillis) {
        this.bucketedExecutor.schedule((Serializable)request, minimumDelayMillis, TimeUnit.MILLISECONDS);
        log.debug("Submitted restriction {} for processing", (Object)request);
    }

    private static Function<ProjectSettingsRestrictionProcessingRequest, String> toBucketId() {
        return request -> String.valueOf(request.getProjectId());
    }
}

