/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.settingsrestriction.scheduler;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestriction;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionOrder;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionSearchRequest;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.settingsrestriction.RestrictionProcessedState;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.settingsrestriction.InternalProjectSettingsRestrictionService;
import com.atlassian.stash.internal.settingsrestriction.config.RestrictionProcessingConfigProvider;
import com.atlassian.stash.internal.settingsrestriction.scheduler.ProcessingRetryLimitExceededException;
import com.atlassian.stash.internal.settingsrestriction.scheduler.ProjectSettingsRestrictionProcessingScheduler;
import com.atlassian.stash.internal.settingsrestriction.scheduler.RestrictionProcessingCleanupJob;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="restrictionProcessingCleanupJob")
@DefaultApplicationMode
public class DefaultRestrictionProcessingCleanupJob
implements RestrictionProcessingCleanupJob,
ScheduledJobSource {
    private static final JobId JOB_ID = JobId.of((String)DefaultRestrictionProcessingCleanupJob.class.getSimpleName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)DefaultRestrictionProcessingCleanupJob.class.getName());
    private static final String LOCK_NAME = DefaultRestrictionProcessingCleanupJob.class.getSimpleName();
    private static final Logger log = LoggerFactory.getLogger(DefaultRestrictionProcessingCleanupJob.class);
    private final RestrictionProcessingConfigProvider configProvider;
    private final LockService lockService;
    private final InternalProjectSettingsRestrictionService restrictionService;
    private final ProjectSettingsRestrictionProcessingScheduler scheduler;
    private final EscalatedSecurityContext withAdmin;

    @Autowired
    public DefaultRestrictionProcessingCleanupJob(RestrictionProcessingConfigProvider configProvider, LockService lockService, InternalProjectSettingsRestrictionService restrictionService, ProjectSettingsRestrictionProcessingScheduler scheduler, SecurityService securityService) {
        this.configProvider = configProvider;
        this.lockService = lockService;
        this.restrictionService = restrictionService;
        this.scheduler = scheduler;
        this.withAdmin = securityService.withPermission(Permission.ADMIN, "Internal restriction cleanup job");
    }

    @Override
    public void cleanupRestrictions(@Nonnull Instant now) {
        Objects.requireNonNull(now, "now");
        try (LockGuard guard = LockGuard.tryLock((Lock)this.lockService.getLock(LOCK_NAME));){
            if (guard == null) {
                log.debug("Unable to acquire lock for cleaning up unprocessed restrictions. The job may be already running on another node.");
                return;
            }
            int numRestrictionsUpdated = this.restrictionService.resetExpiredInProgress(now);
            log.debug("{} expired IN_PROGRESS restrictions were reset to UNPROCESSED", (Object)numRestrictionsUpdated);
            ProjectSettingsRestrictionSearchRequest searchRequest = new ProjectSettingsRestrictionSearchRequest.Builder(RestrictionProcessedState.UNPROCESSED).order(ProjectSettingsRestrictionOrder.PROCESSING_ATTEMPTS_ASC_AND_ID_ASC).build();
            PageRequest pageRequest = PageUtils.newRequest((int)0, (int)this.configProvider.getProcessingBatchSize());
            Page unprocessed = (Page)this.withAdmin.call(() -> this.restrictionService.search(searchRequest, pageRequest));
            if (unprocessed.getSize() > 0) {
                log.debug("Scheduling {} UNPROCESSED restrictions to be processed again", (Object)unprocessed.getSize());
                if (!unprocessed.getIsLastPage()) {
                    log.debug("Max batch size has been reached; remaining restrictions will be picked up on the next run");
                }
                unprocessed.getValues().forEach(this::submitForProcessing);
            }
        }
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        Schedule jobSchedule = Schedule.forInterval((long)this.configProvider.getCleanupJobInterval().toMillis(), (Date)Date.from(ZonedDateTime.now().plus(this.configProvider.getCleanupJobFirstRun()).toInstant()));
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withParameters((Map)ImmutableMap.of((Object)"feature", (Object)StandardFeature.ENFORCE_PROJECT_SETTINGS)).withSchedule(jobSchedule);
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new RestrictionProcessingCleanupJobRunner());
        schedulerService.scheduleJob(JOB_ID, jobConfig);
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.unscheduleJob(JOB_ID);
        schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private void submitForProcessing(DmzProjectSettingsRestriction restriction) {
        try {
            this.scheduler.submitForProcessing(restriction, this.configProvider.getCleanupJobProcessDelay());
        }
        catch (ProcessingRetryLimitExceededException e) {
            log.error("Failed to retry processing for restriction", (Throwable)((Object)e));
        }
    }

    private class RestrictionProcessingCleanupJobRunner
    implements JobRunner {
        private RestrictionProcessingCleanupJobRunner() {
        }

        @Nullable
        public JobRunnerResponse runJob(JobRunnerRequest request) {
            log.debug("Starting restriction clean up job {}", (Object)request);
            DefaultRestrictionProcessingCleanupJob.this.cleanupRestrictions(Instant.now());
            return JobRunnerResponse.success();
        }
    }
}

