/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.shortcuts;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.atlassian.stash.internal.shortcuts.InternalKeyboardShortcutPreferenceService;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class DefaultKeyboardShortcutPreferenceService
implements InternalKeyboardShortcutPreferenceService {
    static final String PROP_KEYBOARD_SHORTCUTS_ENABLED = "bitbucket.keyboard.shortcuts.enabled";
    private final AuthenticationContext authenticationContext;
    private final UserSettingsService settingsService;
    private final TransactionTemplate transactionTemplate;

    public DefaultKeyboardShortcutPreferenceService(AuthenticationContext authenticationContext, UserSettingsService settingsService, TransactionTemplate transactionTemplate) {
        this.authenticationContext = authenticationContext;
        this.settingsService = settingsService;
        this.transactionTemplate = transactionTemplate;
    }

    public boolean isEnabled() {
        return this.getCurrentUser().map(this::isEnabled).orElse(Boolean.TRUE);
    }

    public void setEnabled(boolean enabled) {
        this.getCurrentUser().ifPresent(user -> this.setEnabled((UserKey)user, enabled));
    }

    private Optional<UserKey> getCurrentUser() {
        return Optional.ofNullable(this.authenticationContext.getCurrentUser()).map(user -> UserKey.fromLong((long)user.getId()));
    }

    private boolean isEnabled(UserKey user) {
        return (Boolean)this.settingsService.getUserSettings(user).getBoolean(PROP_KEYBOARD_SHORTCUTS_ENABLED).getOrElse((Object)Boolean.TRUE);
    }

    private void setEnabled(UserKey user, boolean enabled) {
        this.transactionTemplate.execute(() -> {
            if (enabled != this.isEnabled(user)) {
                this.settingsService.updateUserSettings(user, builder -> builder.put(PROP_KEYBOARD_SHORTCUTS_ENABLED, enabled).build());
            }
            return null;
        });
    }
}

