/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.systemsigning;

import com.atlassian.bitbucket.dmz.systemsigning.SystemSigningConfigurationException;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.systemsigning.SystemSigningKeyGenerator;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Date;
import java.util.Objects;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;
import org.springframework.stereotype.Component;

@Profiled
@Component(value="systemSigningKeyGenerator")
public class DefaultSystemSigningKeyGenerator
implements SystemSigningKeyGenerator {
    @Override
    @Nonnull
    public String generateSystemSigningKey(@Nonnull String passphrase) {
        Objects.requireNonNull(passphrase, "passphrase");
        try {
            PGPSecretKey secretKey = new PGPSecretKey(16, (PGPKeyPair)this.createNewKeyPair(), "bitbucket.system-user", this.initKeyCapabilities(), null, this.createContentSigner(), this.createSecretKeyEncryptor(passphrase));
            return this.secretKeyToString(secretKey);
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | PGPException e) {
            throw new SystemSigningConfigurationException("There was an error generating a new signing key.", e);
        }
    }

    private PGPContentSignerBuilder createContentSigner() {
        return new JcaPGPContentSignerBuilder(1, 10).setProvider("BC");
    }

    private JcaPGPKeyPair createNewKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException, PGPException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
        kpg.initialize(4096);
        return new JcaPGPKeyPair(1, kpg.generateKeyPair(), new Date());
    }

    private PBESecretKeyEncryptor createSecretKeyEncryptor(String passphrase) throws PGPException {
        PGPDigestCalculator digestCalculator = new JcaPGPDigestCalculatorProviderBuilder().build().get(10);
        return new JcePBESecretKeyEncryptorBuilder(9, digestCalculator).setProvider("BC").build(passphrase.toCharArray());
    }

    private PGPSignatureSubpacketVector initKeyCapabilities() {
        PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator();
        subpacketGenerator.setKeyExpirationTime(false, 0L);
        subpacketGenerator.setKeyFlags(true, 2);
        return subpacketGenerator.generate();
    }

    private String secretKeyToString(PGPSecretKey secretKey) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ArmoredOutputStream.Builder armoredStreamBuilder = ArmoredOutputStream.builder().setVersion(null);
        try (ArmoredOutputStream armoredOutputStream = armoredStreamBuilder.build((OutputStream)outputStream);){
            secretKey.encode((OutputStream)armoredOutputStream);
        }
        return outputStream.toString(StandardCharsets.UTF_8.name());
    }
}

