/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.systemsigning;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.systemsigning.SimpleSystemSigningSecretKey;
import com.atlassian.stash.internal.systemsigning.SystemSigningKeyFileUtils;
import com.atlassian.stash.internal.systemsigning.SystemSigningKeyManager;
import com.atlassian.stash.internal.systemsigning.SystemSigningSecretKey;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component(value="systemSigningKeyManager")
@DefaultApplicationMode
@DependsOn(value={"migrateSystemSigningPassphraseUpgradeTask"})
public class DefaultSystemSigningKeyManager
implements SystemSigningKeyManager {
    private final SystemSigningSecretKey secretKey;

    @Autowired
    public DefaultSystemSigningKeyManager(InternalApplicationPropertiesService applicationPropertiesService, HomeLayout homeLayout, SecurityService securityService) {
        this(applicationPropertiesService, homeLayout, SystemSigningKeyFileUtils::readSecretKeyFile, securityService);
    }

    @VisibleForTesting
    DefaultSystemSigningKeyManager(InternalApplicationPropertiesService applicationPropertiesService, HomeLayout homeLayout, Function<HomeLayout, String> keyFileReader, SecurityService securityService) {
        String keyText = keyFileReader.apply(homeLayout);
        String passphrase = (String)securityService.withPermission(Permission.SYS_ADMIN, "Internal operation").call(() -> applicationPropertiesService.getSystemSignedGitObjectsSecretPassphrase().orElse(""));
        this.secretKey = new SimpleSystemSigningSecretKey(keyText, passphrase);
    }

    @Override
    @Nonnull
    @Unsecured(value="Internal use only")
    public SystemSigningSecretKey getSecretKey() {
        return this.secretKey;
    }
}

