/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.systemsigning;

import com.atlassian.bitbucket.FeatureDisabledException;
import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.dmz.mesh.MeshConfigProvider;
import com.atlassian.bitbucket.dmz.mesh.MeshConfigUpdatedEvent;
import com.atlassian.bitbucket.dmz.systemsigning.DmzSystemSigningService;
import com.atlassian.bitbucket.dmz.systemsigning.SigningFormat;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.systemsigning.SystemSigningKeyManager;
import com.atlassian.stash.internal.systemsigning.SystemSigningSecretKey;
import com.atlassian.stash.internal.systemsigning.event.SystemSigningConfigurationChangedEvent;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(interfaces={DmzSystemSigningService.class})
@Profiled
@Service(value="systemSigningService")
public class DefaultSystemSigningService
implements DmzSystemSigningService,
MeshConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultSystemSigningService.class);
    private final InternalApplicationPropertiesService applicationPropertiesService;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final SystemSigningKeyManager keyManager;

    @Autowired
    public DefaultSystemSigningService(InternalApplicationPropertiesService applicationPropertiesService, EventPublisher eventPublisher, FeatureManager featureManager, I18nService i18nService, Optional<SystemSigningKeyManager> keyManager) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.keyManager = keyManager.orElse(null);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Optional<String> getSystemSigningSecretKey(@Nonnull SigningFormat signingFormat) {
        Objects.requireNonNull(signingFormat, "signingFormat");
        if (signingFormat != SigningFormat.GPG) {
            log.debug("Unsupported signing format requested {}", (Object)signingFormat);
            return Optional.empty();
        }
        if (this.keyManager == null) {
            log.debug("System signing key is not loaded on mirrors");
            return Optional.empty();
        }
        return Optional.of(this.keyManager.getSecretKey().getKeyText());
    }

    @PreAuthorize(value="isAuthenticated()")
    public boolean isSystemSignedGitObjectsEnabled() {
        return this.featureManager.isEnabled((Feature)StandardFeature.SYSTEM_SIGNED_GIT_OBJECTS) && this.applicationPropertiesService.isSystemSignedGitObjectsEnabled() && !this.isMirrorMode();
    }

    @Unsecured(value="Internal use only")
    public void mergeConfig(@Nonnull MeshConfigProvider.ConfigBuilder builder) {
        if (this.isSystemSignedGitObjectsEnabled() && this.keyManager != null) {
            SystemSigningSecretKey secretKey = this.keyManager.getSecretKey();
            this.applyConfig(builder, true, secretKey.getKeyText(), secretKey.getPassphrase());
        } else {
            this.applyConfig(builder, false, "", "");
        }
    }

    @Secured(value="Permission check performed internally")
    @RequireFeature(value=StandardFeature.SYSTEM_SIGNED_GIT_OBJECTS)
    public void setSystemSignedGitObjectsEnabled(boolean enabled) {
        this.validateApplicationMode();
        this.applicationPropertiesService.setSystemSignedGitObjectsEnabled(enabled);
        this.eventPublisher.publish((Object)new MeshConfigUpdatedEvent((Object)this, (MeshConfigProvider)this));
        this.eventPublisher.publish((Object)new SystemSigningConfigurationChangedEvent(this, enabled));
        log.info("System signing of Git objects {}", (Object)(enabled ? "enabled" : "disabled"));
    }

    private void applyConfig(MeshConfigProvider.ConfigBuilder builder, boolean signingEnabled, String secretKey, String passphrase) {
        builder.put("git.signing.enabled", (Object)signingEnabled);
        builder.put("git.signing.encrypted-secret-key", (Object)secretKey);
        builder.put("git.signing.encrypted-secret-passphrase", (Object)passphrase);
    }

    private boolean isMirrorMode() {
        return this.applicationPropertiesService.getMode() == ApplicationMode.MIRROR;
    }

    private void validateApplicationMode() {
        if (this.isMirrorMode()) {
            throw new FeatureDisabledException(this.i18nService.createKeyedMessage("bitbucket.service.systemsigning.mirror.configuration.error", new Object[0]));
        }
    }
}

