/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.systemsigning;

import com.atlassian.bitbucket.dmz.systemsigning.SystemSigningConfigurationException;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.stash.internal.HomeLayout;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.SecureRandom;
import org.apache.commons.io.FileUtils;

public class SystemSigningKeyFileUtils {
    @VisibleForTesting
    static final String KEY_FILE_NAME = "secret-system-signing-key.asc";

    private SystemSigningKeyFileUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class");
    }

    @Nonnull
    public static String generateSecretPassphrase() {
        return new BigInteger(256, new SecureRandom()).toString(32);
    }

    @Nonnull
    public static String readSecretKeyFile(HomeLayout homeLayout) {
        try {
            Path keyFilePath = SystemSigningKeyFileUtils.getKeyFilePath(homeLayout);
            if (!Files.isRegularFile(keyFilePath, new LinkOption[0])) {
                throw new SystemSigningConfigurationException(String.format("The signing key file could not be found - %s", keyFilePath));
            }
            return FileUtils.readFileToString((File)keyFilePath.toFile(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new SystemSigningConfigurationException("There was an error when reading the signing key file.", (Throwable)e);
        }
    }

    public static void writeSecretKeyFile(HomeLayout homeLayout, String keyContents) {
        try {
            Path keyFilePath = SystemSigningKeyFileUtils.getKeyFilePath(homeLayout);
            FileUtils.write((File)keyFilePath.toFile(), (CharSequence)keyContents, (Charset)StandardCharsets.UTF_8);
            MoreFiles.setSafeFilePermissions((Path)keyFilePath);
        }
        catch (IOException e) {
            throw new SystemSigningConfigurationException("There was an error writing the new signing key file.", (Throwable)e);
        }
    }

    private static Path getKeyFilePath(HomeLayout homeLayout) {
        return homeLayout.getConfigDir().resolve(KEY_FILE_NAME).toAbsolutePath();
    }
}

