/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.systemsigning.event;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.systemsigning.event.SystemSigningConfigurationChangedEvent;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="systemSigningEventListener")
public class SystemSigningEventListener {
    @VisibleForTesting
    static final String ACTION_SYSTEM_SIGNING_CONFIGURATION_CHANGED = "bitbucket.systemsigning.audit.action.configuration.changed";
    @VisibleForTesting
    static final String ATTR_ENABLED = "bitbucket.systemsigning.audit.attribute.enabled";
    private final AuditService auditService;

    @Autowired
    public SystemSigningEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onSystemSigningConfigurationChanged(SystemSigningConfigurationChangedEvent event) {
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.globaladministration", (String)ACTION_SYSTEM_SIGNING_CONFIGURATION_CHANGED).build();
        AuditAttribute enabledAttribute = AuditAttribute.fromI18nKeys((String)ATTR_ENABLED, (String)Boolean.toString(event.isEnabled())).build();
        AuditEvent auditEvent = AuditEvent.builder((AuditType)auditType).extraAttributes(Collections.singletonList(enabledAttribute)).build();
        this.auditService.audit(auditEvent);
    }
}

