/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.systemsigning.upgrade;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.systemsigning.SystemSigningConfigurationException;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.server.ApplicationProperty;
import com.atlassian.stash.internal.server.ApplicationPropertyDao;
import com.atlassian.stash.internal.systemsigning.SystemSigningKeyFileUtils;
import com.atlassian.stash.internal.systemsigning.SystemSigningKeyGenerator;
import com.atlassian.stash.internal.upgrade.UpgradeTask;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="createSystemSigningSecretKeyUpgradeTask")
@DefaultApplicationMode
@Transactional
@UpgradeTask(value="core-system-signing-secret-key")
public class CreateSystemSigningSecretKeyUpgradeTask {
    static final String KEY_TASK = "core-system-signing-secret-key";
    static final String KEY_TASK_LOCK = "core-system-signing-secret-key.lock";
    private static final Logger log = LoggerFactory.getLogger(CreateSystemSigningSecretKeyUpgradeTask.class);
    private final ApplicationPropertyDao applicationPropertyDao;
    private final HomeLayout homeLayout;
    private final BiConsumer<HomeLayout, String> keyFileWriter;
    private final SystemSigningKeyGenerator keyGenerator;
    private final LockService lockService;
    private final Supplier<String> passphraseGenerator;

    @Autowired
    public CreateSystemSigningSecretKeyUpgradeTask(ApplicationPropertyDao applicationPropertyDao, HomeLayout homeLayout, SystemSigningKeyGenerator keyGenerator, LockService lockService) {
        this(applicationPropertyDao, homeLayout, SystemSigningKeyFileUtils::writeSecretKeyFile, keyGenerator, lockService, SystemSigningKeyFileUtils::generateSecretPassphrase);
    }

    @VisibleForTesting
    CreateSystemSigningSecretKeyUpgradeTask(ApplicationPropertyDao applicationPropertyDao, HomeLayout homeLayout, BiConsumer<HomeLayout, String> keyFileWriter, SystemSigningKeyGenerator keyGenerator, LockService lockService, Supplier<String> passphraseGenerator) {
        this.applicationPropertyDao = applicationPropertyDao;
        this.homeLayout = homeLayout;
        this.keyFileWriter = keyFileWriter;
        this.keyGenerator = keyGenerator;
        this.lockService = lockService;
        this.passphraseGenerator = passphraseGenerator;
    }

    @PostConstruct
    public void apply() {
        Path markerFile = this.homeLayout.getUpgradesDir().resolve(KEY_TASK);
        if (Files.exists(markerFile, new LinkOption[0])) {
            log.debug("Skipping upgrade task to create system signing secret key as this has already been done");
            return;
        }
        try (LockGuard ignored = LockGuard.lock((Lock)this.lockService.getLock(KEY_TASK_LOCK));){
            log.debug("Locked upgrade task {}", (Object)KEY_TASK_LOCK);
            if (Files.exists(markerFile, new LinkOption[0])) {
                log.debug("Skipping upgrade task to create system signing secret key as this has already been done");
                return;
            }
            String newPassphrase = this.passphraseGenerator.get();
            this.keyFileWriter.accept(this.homeLayout, this.keyGenerator.generateSystemSigningKey(newPassphrase));
            this.applicationPropertyDao.deleteById(ApplicationProperty.Key.SYSTEM_SIGNED_GIT_OBJECTS_SECRET_PASSPHRASE);
            this.applicationPropertyDao.create(new ApplicationProperty(ApplicationProperty.Key.SYSTEM_SIGNED_GIT_OBJECTS_SECRET_PASSPHRASE, newPassphrase));
            MoreFiles.mkdir((Path)markerFile.getParent());
            MoreFiles.touch((Path)markerFile);
        }
        catch (IOException e) {
            throw new SystemSigningConfigurationException("Error performing upgrade task to create system signing key", (Throwable)e);
        }
        log.debug("Released upgrade task lock {}", (Object)KEY_TASK_LOCK);
    }
}

