/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.theme;

import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.atlassian.theme.api.Theme;
import com.atlassian.theme.api.ThemeColorMode;
import com.atlassian.theme.internal.api.ThemeService;
import com.atlassian.theme.internal.api.user.PreferredColorMode;
import com.atlassian.theme.internal.api.user.UserThemeService;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=UserThemeService.class)
@Component(value="userThemeService")
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class BitbucketUserThemeService
implements UserThemeService {
    private static final String PREFERRED_COLOR_MODE_KEY = "theme";
    private static final String PREFERRED_DARK_THEME = "preferred-dark-theme";
    private static final String PREFERRED_LIGHT_THEME = "preferred-light-theme";
    private final ThemeService themeService;
    private final UserSettingsService userSettingsService;

    @Autowired
    public BitbucketUserThemeService(ThemeService themeService, UserSettingsService userSettingsService) {
        this.themeService = Objects.requireNonNull(themeService, "themeService");
        this.userSettingsService = Objects.requireNonNull(userSettingsService, "userSettingsService");
    }

    public Optional<PreferredColorMode> getPreferredColorMode(UserKey userKey) {
        Objects.requireNonNull(userKey, "userKey");
        return this.userSettingsService.getUserSettings(userKey).getString(PREFERRED_COLOR_MODE_KEY).toOptional().flatMap(PreferredColorMode::optionalValueOf);
    }

    public Optional<Theme> getPreferredDarkTheme(UserKey userKey) {
        Objects.requireNonNull(userKey, "userKey");
        return this.themeService.findMatchingTheme(ThemeColorMode.DARK, (String)this.userSettingsService.getUserSettings(userKey).getString(PREFERRED_DARK_THEME).getOrNull());
    }

    public Optional<Theme> getPreferredLightTheme(UserKey userKey) {
        Objects.requireNonNull(userKey, "userKey");
        return this.themeService.findMatchingTheme(ThemeColorMode.LIGHT, (String)this.userSettingsService.getUserSettings(userKey).getString(PREFERRED_LIGHT_THEME).getOrNull());
    }

    public void setPreferredColorMode(UserKey userKey, PreferredColorMode preferredColorMode) {
        Objects.requireNonNull(userKey, "userKey");
        Objects.requireNonNull(preferredColorMode, "preferredColorMode");
        this.userSettingsService.updateUserSettings(userKey, userSettingsBuilder -> userSettingsBuilder.put(PREFERRED_COLOR_MODE_KEY, preferredColorMode.toString()).build());
    }

    public void setPreferredDarkTheme(UserKey userKey, Theme theme) {
        Objects.requireNonNull(userKey, "userKey");
        Objects.requireNonNull(theme, PREFERRED_COLOR_MODE_KEY);
        this.userSettingsService.updateUserSettings(userKey, userSettingsBuilder -> userSettingsBuilder.put(PREFERRED_DARK_THEME, theme.getThemeKey()).build());
    }

    public void setPreferredLightTheme(UserKey userKey, Theme theme) {
        Objects.requireNonNull(userKey, "userKey");
        Objects.requireNonNull(theme, PREFERRED_COLOR_MODE_KEY);
        this.userSettingsService.updateUserSettings(userKey, userSettingsBuilder -> userSettingsBuilder.put(PREFERRED_LIGHT_THEME, theme.getThemeKey()).build());
    }
}

