/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.throttle;

import jakarta.annotation.Nonnull;
import java.util.OptionalInt;

public class AdaptiveThrottlingUnavailableException
extends RuntimeException {
    private final Reason reason;
    private final OptionalInt fallbackFixedTickets;

    public AdaptiveThrottlingUnavailableException(@Nonnull Reason reason) {
        this.fallbackFixedTickets = OptionalInt.empty();
        this.reason = reason;
    }

    public AdaptiveThrottlingUnavailableException(int fallbackFixedTickets, @Nonnull Reason reason) {
        this.fallbackFixedTickets = OptionalInt.of(fallbackFixedTickets);
        this.reason = reason;
    }

    @Nonnull
    public Reason getReason() {
        return this.reason;
    }

    @Nonnull
    public OptionalInt getFixedTickets() {
        return this.fallbackFixedTickets;
    }

    public static enum Reason {
        ERROR_RUNTIME("error-runtime"),
        ERROR_CONFIGURATION("error-configuration"),
        MEMORY_INSUFFICIENT("memory-insufficient"),
        MEMORY_UNAVAILABLE("memory-unavailable");

        private final String id;

        private Reason(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }
}

