/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.throttle;

import com.atlassian.stash.internal.throttle.ResourceThrottleStrategy;
import com.atlassian.stash.internal.throttle.SemaphoreTicketBucket;
import jakarta.annotation.Nonnull;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;

class FixedResourceThrottleStrategy
implements ResourceThrottleStrategy {
    private final int acquireTimeoutSeconds;
    private final int ticketLimit;

    FixedResourceThrottleStrategy(int acquireTimeoutSeconds, int ticketLimit) {
        this.acquireTimeoutSeconds = acquireTimeoutSeconds;
        this.ticketLimit = ticketLimit;
    }

    @Override
    @Nonnull
    public SemaphoreTicketBucket create() {
        return new SemaphoreTicketBucket(this.ticketLimit, this.acquireTimeoutSeconds, TimeUnit.SECONDS);
    }

    @Override
    @Nonnull
    public OptionalLong getUpdateInterval(@Nonnull TimeUnit timeUnit) {
        return OptionalLong.empty();
    }

    @Override
    public void update(@Nonnull SemaphoreTicketBucket bucket) {
    }

    public String toString() {
        return "[tickets = " + this.ticketLimit + ", acquire timeout = " + this.acquireTimeoutSeconds + "s]";
    }

    int getAcquireTimeoutSeconds() {
        return this.acquireTimeoutSeconds;
    }

    int getTicketLimit() {
        return this.ticketLimit;
    }
}

