/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.throttle;

import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationModeSupplier;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.config.Clock;
import com.atlassian.stash.internal.server.OperatingSystemService;
import com.atlassian.stash.internal.throttle.AdaptiveResourceThrottleStrategy;
import com.atlassian.stash.internal.throttle.AdaptiveThrottlingMemoryEstimator;
import com.atlassian.stash.internal.throttle.AdaptiveThrottlingUnavailableException;
import com.atlassian.stash.internal.throttle.FixedResourceThrottleStrategy;
import com.atlassian.stash.internal.throttle.ResourceThrottleStrategy;
import com.atlassian.stash.internal.throttle.ThrottlingConstants;
import com.atlassian.stash.internal.throttle.ThrottlingStrategy;
import com.atlassian.stash.internal.throttle.analytics.AdaptiveThrottlingConfiguredAnalyticsEvent;
import com.atlassian.stash.internal.throttle.analytics.FixedThrottlingConfiguredAnalyticsEvent;
import com.atlassian.stash.internal.throttle.analytics.ThrottlingAnalyticsPublisher;
import com.atlassian.stash.internal.utils.ExpressionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.atlassian.fugue.Pair;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.net.URI;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component(value="resourceThrottleStrategyProvider")
@DependsOn(value={"loggingService"})
public class ResourceThrottleStrategyProvider
implements EnvironmentAware,
AdaptiveThrottlingMemoryEstimator {
    private static final Logger log = LoggerFactory.getLogger(ResourceThrottleStrategyProvider.class);
    private final ApplicationMode applicationMode;
    private final ThrottlingAnalyticsPublisher analyticsPublisher;
    private final Clock clock;
    private final OperatingSystemService operatingSystemService;
    private Environment environment;
    private Map<String, ResourceThrottleStrategy> resourceStrategies;

    @Autowired
    public ResourceThrottleStrategyProvider(ThrottlingAnalyticsPublisher analyticsPublisher, ApplicationModeSupplier applicationMode, Clock clock, OperatingSystemService operatingSystemService) {
        this.analyticsPublisher = analyticsPublisher;
        this.applicationMode = applicationMode.getMode();
        this.clock = clock;
        this.operatingSystemService = operatingSystemService;
        this.resourceStrategies = Collections.emptyMap();
    }

    @PostConstruct
    public void initialize() {
        int strategyLength = ".strategy".length();
        this.resourceStrategies = (Map)this.getSubProperties("throttle.resource.", this.environment).keySet().stream().map(key -> {
            int split = key.indexOf(46);
            if (split == -1) {
                return key;
            }
            if (key.length() == split + strategyLength && key.endsWith(".strategy")) {
                return key.substring(0, split);
            }
            return null;
        }).filter(Objects::nonNull).distinct().collect(MoreCollectors.toImmutableMap(name -> name, this::load));
    }

    @Nonnull
    public Map<String, ResourceThrottleStrategy> getAll() {
        return this.resourceStrategies;
    }

    public int getSearchMemoryReservedMemory() {
        if (this.isSearchResident("scm-hosting")) {
            return this.getSearchMemoryEstimate("scm-hosting");
        }
        return 0;
    }

    public int getWebappReservedMemory() {
        return this.getWebappMemoryEstimate("scm-hosting");
    }

    public void setEnvironment(@Nonnull Environment environment) {
        this.environment = environment;
    }

    @VisibleForTesting
    OptionalLong getJvmMaxMemoryInBytes() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory == Long.MAX_VALUE) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(maxMemory);
    }

    private int getJvmMaxMemoryOrFail(String resourceName) {
        OptionalLong memory = this.getJvmMaxMemoryInBytes();
        if (memory.isPresent()) {
            return Ints.saturatedCast((long)(memory.getAsLong() / 0x100000L));
        }
        log.warn("[{}] The maximum memory required by this JVM cannot be determined by adaptive throttling. Selecting fixed throttling instead", (Object)resourceName);
        throw new AdaptiveThrottlingUnavailableException(AdaptiveThrottlingUnavailableException.Reason.MEMORY_UNAVAILABLE);
    }

    private static int parseBucketLimit(String resourceName, String expression, String limitDescription, Supplier<Integer> fallbackValue) {
        Supplier<Integer> safeFallbackValue = () -> {
            Integer result = (Integer)fallbackValue.get();
            Preconditions.checkNotNull((Object)result, (String)"[%s] The fallback %s ticket limit cannot be null", (Object)resourceName, (Object)limitDescription, (Object)result);
            Preconditions.checkArgument((result >= 0 ? 1 : 0) != 0, (String)"[%s] The fallback %s ticket limit must be positive", (Object)resourceName, (Object)limitDescription, (Object)result);
            return result;
        };
        if (StringUtils.isBlank((CharSequence)expression)) {
            int fallback = safeFallbackValue.get();
            log.warn("[{}] The {} ticket limit property is missing. Defaulting to '{}'", new Object[]{resourceName, limitDescription, fallback});
            return fallback;
        }
        OptionalInt expressionResult = ExpressionUtils.parseExpressionAsInt((String)expression);
        if (!expressionResult.isPresent()) {
            int fallback = safeFallbackValue.get();
            log.warn("[{}] The {} ticket limit expression '{}' is invalid. Only numbers, +, -, /, *, (, ) and cpu are supported. Defaulting to {}", new Object[]{resourceName, limitDescription, expression, fallback});
            return fallback;
        }
        if (expressionResult.getAsInt() >= 1) {
            log.debug("[{}] Configuration-derived value for {} ticket limit: {}", new Object[]{resourceName, limitDescription, expressionResult.getAsInt()});
            return expressionResult.getAsInt();
        }
        log.warn("[{}] The {} ticket limit expression '{}' evaluated to an invalid value ({}). It must evaluate to a positive number. Defaulting to {}", new Object[]{resourceName, limitDescription, expression, expressionResult.getAsInt(), 1});
        return 1;
    }

    @Nonnull
    private ResourceThrottleStrategy load(@Nonnull String resourceName) {
        try {
            ThrottlingStrategy strategy = this.getThrottlingStrategyFor(resourceName);
            if (strategy == ThrottlingStrategy.ADAPTIVE) {
                if (!"scm-hosting".equals(resourceName)) {
                    log.warn("[{}] Adaptive throttling is not compatible with this resource. Selecting fixed throttling instead", (Object)resourceName);
                    throw new AdaptiveThrottlingUnavailableException(AdaptiveThrottlingUnavailableException.Reason.ERROR_CONFIGURATION);
                }
                try {
                    return this.loadAdaptive(resourceName);
                }
                catch (AdaptiveThrottlingUnavailableException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    log.error("[{}]: Error while configuring adaptive throttling. Selecting fixed throttling instead", (Object)resourceName, (Object)e);
                    throw new AdaptiveThrottlingUnavailableException(AdaptiveThrottlingUnavailableException.Reason.ERROR_RUNTIME);
                }
            }
        }
        catch (AdaptiveThrottlingUnavailableException e) {
            return this.loadFixedAsFallback(resourceName, e.getFixedTickets(), e.getReason());
        }
        return this.loadFixed(resourceName);
    }

    private Map<String, String> getSubProperties(String keyPrefix, Environment environment) {
        keyPrefix = StringUtils.stripEnd((String)keyPrefix, (String)".");
        return (Map)Binder.get((Environment)environment).bind(keyPrefix, Bindable.mapOf(String.class, String.class)).orElseGet(Collections::emptyMap);
    }

    private ResourceThrottleStrategy loadAdaptive(String resourceName) {
        int queueTimeoutSeconds = this.parseTicketAcquireTimeout(resourceName);
        int minTicketsConfigured = this.getAdaptiveMinTickets(resourceName);
        int maxTicketsConfigured = this.getAdaptiveMaxTickets(resourceName);
        int maxTicketsSafeForMemory = Integer.MAX_VALUE;
        Pair<Integer, Integer> minMaxTickets = Pair.pair((Object)minTicketsConfigured, (Object)maxTicketsConfigured);
        if (this.isMemoryBackstopEnabled(resourceName)) {
            maxTicketsSafeForMemory = this.getMaxTicketsSafeForMemory(resourceName);
            minMaxTickets = this.chooseValidMinMaxTickets(resourceName, minTicketsConfigured, maxTicketsConfigured, maxTicketsSafeForMemory);
        }
        int noCpuTickets = this.getFixedTicketLimit(resourceName);
        int intervalSeconds = this.getAdaptiveIntervalInSeconds(resourceName);
        int noCpuThresholdSeconds = 4 * intervalSeconds;
        double cpuTargetLoad = this.getCpuTargetLoad(resourceName);
        double cpuPerTypicalTicket = this.getCpuPerTypicalTicket(resourceName);
        double cpuHistoricalWeighting = this.getCpuHistoricalWeighting(resourceName);
        log.debug("[{}] Configured adaptive throttling: [range={}..{}, no-cpu-tickets={}, cpu-target={}, cpu-per-typical-ticket={}, cpu-historical-weighting={}, interval={}s, queue-timeout={}s, no-cpu-threshold={}s]", new Object[]{resourceName, minMaxTickets.left(), minMaxTickets.right(), noCpuTickets, cpuTargetLoad, cpuPerTypicalTicket, cpuHistoricalWeighting, intervalSeconds, queueTimeoutSeconds, noCpuThresholdSeconds});
        AdaptiveResourceThrottleStrategy strategy = new AdaptiveResourceThrottleStrategy(resourceName, this.clock, this.operatingSystemService, intervalSeconds, (Integer)minMaxTickets.left(), (Integer)minMaxTickets.right(), noCpuTickets, cpuTargetLoad, cpuPerTypicalTicket, cpuHistoricalWeighting, queueTimeoutSeconds, noCpuThresholdSeconds);
        this.analyticsPublisher.publish(new AdaptiveThrottlingConfiguredAnalyticsEvent(this, resourceName, queueTimeoutSeconds, intervalSeconds, (Integer)minMaxTickets.left(), (Integer)minMaxTickets.right(), maxTicketsConfigured, maxTicketsSafeForMemory, cpuTargetLoad, cpuPerTypicalTicket, cpuHistoricalWeighting));
        return strategy;
    }

    private Pair<Integer, Integer> chooseValidMinMaxTickets(String resourceName, int configMinTickets, int configMaxTickets, int memorySafeMaxTickets) {
        int minTickets = configMinTickets;
        int maxTickets = configMaxTickets;
        if (memorySafeMaxTickets < minTickets) {
            log.warn("[{}] This machine's total memory cannot safely support the configured minimum number of tickets ({} configured, {} possible). Selecting fixed throttling instead", new Object[]{resourceName, minTickets, memorySafeMaxTickets});
            throw new AdaptiveThrottlingUnavailableException(AdaptiveThrottlingUnavailableException.Reason.MEMORY_INSUFFICIENT);
        }
        if (memorySafeMaxTickets < maxTickets) {
            if ((double)maxTickets != ThrottlingConstants.FALLBACK_ADAPTIVE_TICKETS) {
                log.info("[{}] This machine's total available memory cannot safely support the configured maximum of {} tickets. Reducing maximum tickets to {} instead", new Object[]{resourceName, maxTickets, memorySafeMaxTickets});
            } else {
                log.debug("[{}] This machine's total available memory cannot safely support the default maximum of {} tickets. Reducing maximum tickets to {} instead", new Object[]{resourceName, maxTickets, memorySafeMaxTickets});
            }
            maxTickets = memorySafeMaxTickets;
        }
        if (minTickets >= maxTickets) {
            log.warn("[{}] Unable to set minimum tickets to {}. The maximum number of tickets {} is {}. Selecting fixed throttling instead", new Object[]{resourceName, minTickets, maxTickets != configMaxTickets ? "permitted for the total memory" : "configured", maxTickets});
            throw new AdaptiveThrottlingUnavailableException(maxTickets, AdaptiveThrottlingUnavailableException.Reason.ERROR_CONFIGURATION);
        }
        log.debug("[{}] Choosing an adaptive ticket range of {}..{}", new Object[]{resourceName, minTickets, maxTickets});
        return Pair.pair((Object)minTickets, (Object)maxTickets);
    }

    private int getMaxTicketsSafeForMemory(String resourceName) {
        long nonTicketOperationalMemoryBytes;
        OptionalLong totalPhysicalMemoryBytes = this.operatingSystemService.getTotalPhysicalMemory();
        if (!totalPhysicalMemoryBytes.isPresent()) {
            log.warn("[{}] The total memory on this machine cannot be determined. Selecting fixed throttling instead", (Object)resourceName);
            throw new AdaptiveThrottlingUnavailableException(AdaptiveThrottlingUnavailableException.Reason.MEMORY_UNAVAILABLE);
        }
        log.debug("[{}] The total memory on this machine is {} MB", (Object)resourceName, (Object)(totalPhysicalMemoryBytes.getAsLong() / 0x100000L));
        int typicalMemPerTicket = this.getTypicalMemPerTicket(resourceName);
        log.debug("[{}] Estimated typical memory per ticket: {} MB", (Object)resourceName, (Object)typicalMemPerTicket);
        int mainJvmMaxMemory = this.getWebappMemoryEstimate(resourceName);
        log.debug("[{}] Estimated application webapp requirement: {} MB", (Object)resourceName, (Object)mainJvmMaxMemory);
        int searchJvmMaxMemory = 0;
        if (this.isSearchResident(resourceName)) {
            searchJvmMaxMemory = this.getSearchMemoryEstimate(resourceName);
            log.debug("[{}] Estimated application search requirement: {} MB", (Object)resourceName, (Object)searchJvmMaxMemory);
        }
        if ((nonTicketOperationalMemoryBytes = (long)(mainJvmMaxMemory + searchJvmMaxMemory) * 0x100000L) > totalPhysicalMemoryBytes.getAsLong()) {
            log.warn("[{}] This machine's total memory cannot support the application webapp and search memory requirements ({} MB required, {} MB total). Selecting fixed throttling instead", new Object[]{resourceName, mainJvmMaxMemory + searchJvmMaxMemory, totalPhysicalMemoryBytes.getAsLong() / 0x100000L});
            throw new AdaptiveThrottlingUnavailableException(AdaptiveThrottlingUnavailableException.Reason.MEMORY_INSUFFICIENT);
        }
        long ticketOperationalMemoryBytes = totalPhysicalMemoryBytes.getAsLong() - nonTicketOperationalMemoryBytes;
        log.debug("[{}] Estimated combined application webapp and search requirements: {} MB", (Object)resourceName, (Object)(nonTicketOperationalMemoryBytes / 0x100000L));
        log.debug("[{}] Estimated remaining memory available to ticketed operations: {} MB", (Object)resourceName, (Object)(ticketOperationalMemoryBytes / 0x100000L));
        int memorySafeMax = (int)Math.floor(ticketOperationalMemoryBytes / ((long)typicalMemPerTicket * 0x100000L));
        log.debug("[{}] Estimated safe max tickets: {}", (Object)resourceName, (Object)memorySafeMax);
        return memorySafeMax;
    }

    private boolean isMemoryBackstopEnabled(String resourceName) {
        boolean fallback = ThrottlingConstants.FALLBACK_ADAPTIVE_MEM_BACKSTOP_ENABLED;
        String value = StringUtils.trimToNull((String)this.resourceProperty(resourceName, ".adaptive.mem.backstop.enabled"));
        if (value == null) {
            return fallback;
        }
        boolean result = Boolean.parseBoolean(value);
        if (!result) {
            log.debug("[{}] Memory backstop has been disabled (value: '{}'). Adaptive throttling will not keep the ticket limit min/max within safe limits for the machine's total memory'", (Object)resourceName, (Object)value);
        }
        return result;
    }

    private boolean isSearchResident(String resourceName) {
        String isResident = this.resourceProperty(resourceName, ".adaptive.mem.search.resident");
        if (isResident != null) {
            return Boolean.parseBoolean(isResident);
        }
        if (this.applicationMode == ApplicationMode.MIRROR) {
            return false;
        }
        String searchUrl = this.getSearchUrl();
        if (searchUrl == null) {
            return true;
        }
        try {
            return Optional.ofNullable(URI.create(searchUrl).getHost()).map(host -> host.equals("localhost")).orElse(true);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Unable to determine the host name of for the custom search URL {}. Assuming the application search is not resident on this machine for memory estimation purposes", new Object[]{resourceName, searchUrl, e});
            return false;
        }
    }

    private String getSearchUrl() {
        String searchUrl = this.environment.getProperty("plugin.search.config.baseurl");
        if (searchUrl == null) {
            return this.environment.getProperty("plugin.search.elasticsearch.baseurl");
        }
        return searchUrl;
    }

    private FixedResourceThrottleStrategy loadFixed(String resourceName) {
        int tickets = this.getFixedTicketLimit(resourceName);
        int queueTimeoutSeconds = this.parseTicketAcquireTimeout(resourceName);
        log.debug("[{}] Configured fixed throttling: [tickets={}, queue-timeout={}s]", new Object[]{resourceName, tickets, queueTimeoutSeconds});
        this.analyticsPublisher.publish(new FixedThrottlingConfiguredAnalyticsEvent(this, resourceName, queueTimeoutSeconds, tickets, null));
        return new FixedResourceThrottleStrategy(queueTimeoutSeconds, tickets);
    }

    private FixedResourceThrottleStrategy loadFixedAsFallback(String resourceName, OptionalInt suggestedFixedTickets, AdaptiveThrottlingUnavailableException.Reason fallbackReason) {
        int tickets = suggestedFixedTickets.orElseGet(() -> this.getFixedTicketLimit(resourceName));
        int queueTimeoutSeconds = this.parseTicketAcquireTimeout(resourceName);
        log.debug("[{}] Configured fixed throttling as a fallback: [tickets={}, queue-timeout={}s, reason={}]", new Object[]{resourceName, tickets, queueTimeoutSeconds, fallbackReason});
        this.analyticsPublisher.publish(new FixedThrottlingConfiguredAnalyticsEvent(this, resourceName, queueTimeoutSeconds, tickets, fallbackReason));
        return new FixedResourceThrottleStrategy(queueTimeoutSeconds, tickets);
    }

    private String resourceProperty(String resourceName, String suffix) {
        return this.environment.getProperty("throttle.resource." + resourceName + suffix);
    }

    private double getCpuTargetLoad(String resourceName) {
        double fallback = 0.75;
        String value = this.resourceProperty(resourceName, ".adaptive.cpu.target");
        if (value == null) {
            log.debug("[{}] The adaptive throttling target CPU usage is unspecified. Defaulting to '{}%'", (Object)resourceName, (Object)(fallback * 100.0));
        } else {
            try {
                double targetCpuUsage = Double.parseDouble(value);
                if (targetCpuUsage >= 0.0 && targetCpuUsage <= 1.0) {
                    return targetCpuUsage;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            log.warn("[{}] Invalid adaptive throttling target CPU load of '{}' specified. This value must be a floating point number between 0.0 and 1.0. Defaulting to '{}' ('{}%')", new Object[]{resourceName, value, fallback, fallback * 100.0});
        }
        return fallback;
    }

    private double getCpuPerTypicalTicket(String resourceName) {
        double fallback = ThrottlingConstants.FALLBACK_ADAPTIVE_CPU_PER_TICKET;
        String expression = this.resourceProperty(resourceName, ".adaptive.cpu.per.ticket");
        if (expression == null) {
            log.debug("[{}] The value for the typical CPU usage per ticketed operation is unspecified. Defaulting to '{}' ('{}%')", new Object[]{resourceName, fallback, fallback * 100.0});
        } else {
            OptionalDouble typicalCpuUsage = ExpressionUtils.parseExpressionAsDouble((String)expression);
            if (typicalCpuUsage.isPresent() && typicalCpuUsage.getAsDouble() > 0.0 && typicalCpuUsage.getAsDouble() <= 1.0) {
                return typicalCpuUsage.getAsDouble();
            }
            log.warn("[{}] Invalid expression '{}' specified for the typical CPU usage per ticketed operation. This must evaluate to a positive value of 1.0 or lower (evaulated as {}). Defaulting to '{}' ('{}%')", new Object[]{resourceName, expression, typicalCpuUsage.isPresent() ? Double.valueOf(typicalCpuUsage.getAsDouble()) : "<error>", fallback, fallback * 100.0});
        }
        return fallback;
    }

    private double getCpuHistoricalWeighting(String resourceName) {
        double fallback = 0.8;
        String value = this.resourceProperty(resourceName, ".adaptive.cpu.historical.weighting");
        if (value == null) {
            log.debug("[{}] The adaptive throttling CPU historical weighting is unspecified. Defaulting to '{}'", (Object)resourceName, (Object)fallback);
        } else {
            try {
                double baseCpuUsage = Double.parseDouble(value);
                if (baseCpuUsage >= 0.0 && baseCpuUsage < 1.0) {
                    return baseCpuUsage;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            log.warn("[{}] Invalid adaptive throttling CPU historical weighting of '{}' specified. This value must be a floating point number between 0.0 (inclusive) and 1.0 (exclusive). Defaulting to '{}'", new Object[]{resourceName, value, fallback});
        }
        return fallback;
    }

    private int getAdaptiveIntervalInSeconds(String resourceName) {
        int fallback = 5;
        String value = this.resourceProperty(resourceName, ".adaptive.interval");
        if (value == null) {
            log.debug("[{}] The adaptive throttling interval property is unspecified. Defaulting to '{}' seconds", (Object)resourceName, (Object)fallback);
        } else {
            try {
                int intervalSeconds = Integer.parseInt(value);
                if (intervalSeconds > 0) {
                    return intervalSeconds;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            log.warn("[{}] Invalid adaptive throttling interval of '{}' specified. Defaulting to '{}' seconds", new Object[]{resourceName, value, fallback});
        }
        return fallback;
    }

    private int getAdaptiveMaxTickets(String resourceName) {
        String expression = this.resourceProperty(resourceName, ".adaptive.limit.max");
        return ResourceThrottleStrategyProvider.parseBucketLimit(resourceName, expression, "maximum", this::getDefaultAdaptiveMaxTickets);
    }

    private int getAdaptiveMinTickets(String resourceName) {
        String expression = this.resourceProperty(resourceName, ".adaptive.limit.min");
        return ResourceThrottleStrategyProvider.parseBucketLimit(resourceName, expression, "minimum", this::getDefaultAdaptiveMinTickets);
    }

    private int getDefaultAdaptiveMaxTickets() {
        return (int)Math.round(4.0 * (double)Runtime.getRuntime().availableProcessors());
    }

    private int getDefaultAdaptiveMinTickets() {
        return (int)Math.round(1.0 * (double)Runtime.getRuntime().availableProcessors());
    }

    private int getFixedTicketLimit(String resourceName) {
        int fallbackValue = (Integer)MoreObjects.firstNonNull((Object)ThrottlingConstants.FALLBACK_FIXED_TICKETS.get(resourceName), (Object)1);
        String expression = (String)MoreObjects.firstNonNull((Object)StringUtils.trimToNull((String)this.environment.getProperty("throttle.resource." + resourceName)), (Object)((String)MoreObjects.firstNonNull((Object)this.resourceProperty(resourceName, ".fixed.limit"), (Object)"")));
        if (expression.isEmpty()) {
            return fallbackValue;
        }
        return ResourceThrottleStrategyProvider.parseBucketLimit(resourceName, expression, "fixed", () -> fallbackValue);
    }

    private ThrottlingStrategy getThrottlingStrategyFor(String resourceName) {
        String deprecatedFixedLimit = this.environment.getProperty("throttle.resource." + resourceName);
        if (deprecatedFixedLimit != null) {
            if (resourceName.equals("scm-hosting")) {
                String throttlingPropertiesUrl = "https://confluence.atlassian.com/display/BitbucketServer/Bitbucket+Server+config+properties#BitbucketServerconfigproperties-throttling";
                log.info("A custom configuration for the {} tickets was detected and will be used. Please note that you may get better throughput by configuring adaptive throttling. See {} for more details.", (Object)resourceName, (Object)throttlingPropertiesUrl);
            }
            return ThrottlingStrategy.FIXED;
        }
        String value = this.resourceProperty(resourceName, ".strategy");
        if (value == null) {
            log.debug("[{}] No throttling strategy specified. Selecting {} throttling", (Object)resourceName, (Object)ThrottlingStrategy.FIXED.getId());
            return ThrottlingStrategy.FIXED;
        }
        return ThrottlingStrategy.fromId(value.toLowerCase(Locale.ROOT)).orElseGet(() -> {
            log.warn("[{}] Invalid throttling strategy: '{}'. Selecting {} throttling", new Object[]{resourceName, value, ThrottlingStrategy.FIXED.getId()});
            throw new AdaptiveThrottlingUnavailableException(AdaptiveThrottlingUnavailableException.Reason.ERROR_CONFIGURATION);
        });
    }

    private int getTypicalMemPerTicket(String resourceName) {
        return this.getEstimatedMemoryValueInMb(resourceName, "estimated memory usage per ticketed operation", ".adaptive.mem.per.ticket", ExpressionUtils::parseExpressionAsInt, () -> ThrottlingConstants.FALLBACK_ADAPTIVE_MEM_PER_TICKET);
    }

    private int getWebappMemoryEstimate(String resourceName) {
        Function<String, OptionalInt> toMemory = value -> {
            if (value.trim().equalsIgnoreCase("jvmmax")) {
                return OptionalInt.of(this.getJvmMaxMemoryOrFail(resourceName));
            }
            return ExpressionUtils.parseExpressionAsInt((String)value);
        };
        return this.getEstimatedMemoryValueInMb(resourceName, "application webapp size", ".adaptive.mem.webapp", toMemory, () -> this.getJvmMaxMemoryOrFail(resourceName));
    }

    private int getSearchMemoryEstimate(String resourceName) {
        return this.getEstimatedMemoryValueInMb(resourceName, "application search size", ".adaptive.mem.search", ExpressionUtils::parseExpressionAsInt, () -> ThrottlingConstants.FALLBACK_ADAPTIVE_MEM_SEARCH_SIZE);
    }

    private int getEstimatedMemoryValueInMb(String resourceName, String description, String property, Function<String, OptionalInt> converter, Supplier<Integer> fallback) {
        String value = this.resourceProperty(resourceName, property);
        if (value == null) {
            int fallbackValue = fallback.get();
            log.debug("[{}] The estimated adaptive throttling {} is missing. Defaulting to '{} MB'", new Object[]{resourceName, description, fallbackValue});
            return fallbackValue;
        }
        try {
            OptionalInt memory = converter.apply(value);
            if (memory.isPresent() && (long)memory.getAsInt() > 0L) {
                return memory.getAsInt();
            }
        }
        catch (NumberFormatException memory) {
            // empty catch block
        }
        int fallbackValue = fallback.get();
        log.warn("[{}] Invalid estimate adaptive throttling {} value of '{}' specified. Defaulting to '{} MB'", new Object[]{resourceName, description, value, fallbackValue});
        return fallbackValue;
    }

    private int parseTicketAcquireTimeout(String resourceName) {
        int fallback = (Integer)MoreObjects.firstNonNull((Object)ThrottlingConstants.FALLBACK_TICKET_TIMEOUT_SECONDS.get(resourceName), (Object)0);
        String value = this.resourceProperty(resourceName, ".timeout");
        if (value == null) {
            log.debug("[{}] Ticket acquire timeout is unspecified. Defaulting to '{}' seconds", (Object)resourceName, (Object)fallback);
            return fallback;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            log.warn("[{}] Invalid ticket acquire timeout of '{}' seconds. Defaulting to '{}' seconds", new Object[]{resourceName, value, fallback});
            return fallback;
        }
    }
}

