/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.throttle;

import com.atlassian.bitbucket.NoSuchResourceException;
import com.atlassian.bitbucket.ResourceBusyException;
import com.atlassian.bitbucket.dmz.throttle.DmzThrottleService;
import com.atlassian.bitbucket.dmz.throttle.Ticket;
import com.atlassian.bitbucket.dmz.throttle.TicketContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.annotation.NotProfiled;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.config.Clock;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.throttle.AbstractTicket;
import com.atlassian.stash.internal.throttle.InternalThrottleService;
import com.atlassian.stash.internal.throttle.ResourceThrottleStrategy;
import com.atlassian.stash.internal.throttle.ResourceThrottleStrategyProvider;
import com.atlassian.stash.internal.throttle.SemaphoreTicketBucket;
import com.atlassian.stash.internal.throttle.TicketSummary;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@AvailableToPlugins(value=DmzThrottleService.class)
@Deprecated
public class SemaphoreThrottleService
implements InternalThrottleService,
StatefulService,
ScheduledJobSource {
    static final JobId JOB_ID = JobId.of((String)ThrottleAdjustingJobRunner.class.getSimpleName());
    static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)ThrottleAdjustingJobRunner.class.getName());
    private static final Logger log = LoggerFactory.getLogger(SemaphoreThrottleService.class);
    private final Map<String, SemaphoreTicketBucket> buckets;
    private final Clock clock;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final RequestContext requestContext;
    private final ResourceThrottleStrategyProvider throttleStrategyProvider;
    private final ThreadLocal<CountedTicket> tickets;

    @Autowired
    public SemaphoreThrottleService(Clock clock, EventPublisher eventPublisher, I18nService i18nService, RequestContext requestContext, ResourceThrottleStrategyProvider throttleStrategyProvider) {
        this.clock = clock;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.requestContext = requestContext;
        this.throttleStrategyProvider = throttleStrategyProvider;
        this.buckets = new TreeMap<String, SemaphoreTicketBucket>();
        this.tickets = new ThreadLocal();
    }

    @Nonnull
    public Ticket acquireTicket(@Nonnull String resourceName) {
        CountedTicket ticket = this.tickets.get();
        if (ticket == null) {
            try {
                ticket = this.acquireTicketOrThrow(resourceName);
            }
            catch (InterruptedException e) {
                log.info("Interrupted while acquiring a [{}] ticket", (Object)resourceName);
                KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.resource.interrupted", new Object[0]);
                throw new ResourceBusyException(message, resourceName);
            }
        }
        ticket.acquire();
        return ticket;
    }

    public void cleanupTickets() {
        CountedTicket ticket = this.tickets.get();
        if (ticket != null) {
            ticket.closeNow();
        }
        this.tickets.remove();
    }

    public long getLongestQueueingTimeForCurrentTicketRequests(@Nonnull String resourceName) {
        long earliestQueuingTime = this.getBucketOrThrow(resourceName, true).getEarliestQueuingTime();
        return earliestQueuingTime == 0L ? 0L : System.currentTimeMillis() - earliestQueuingTime;
    }

    @Nonnull
    @NotProfiled
    public TransferableState getState() {
        return new TicketState(this.tickets.get());
    }

    @Nonnull
    public TicketSummary[] getSummaries() {
        return (TicketSummary[])this.buckets.entrySet().stream().map(entry -> ((SemaphoreTicketBucket)entry.getValue()).summarize((String)entry.getKey())).toArray(TicketSummary[]::new);
    }

    @Nonnull
    public TicketSummary getSummary(@Nonnull String resourceName) {
        return this.getBucketOrThrow(resourceName, false).summarize(resourceName);
    }

    public long getTimeSinceLastRejectedTicketRequest(@Nonnull String resourceName) {
        long lastRejectedTimestamp = this.getBucketOrThrow(resourceName, true).getLastRejectedTimestamp();
        return lastRejectedTimestamp == 0L ? 0L : System.currentTimeMillis() - lastRejectedTimestamp;
    }

    @PostConstruct
    public void initialise() {
        this.throttleStrategyProvider.getAll().forEach((name, strategy) -> {
            log.debug("Configured resource [{}]: {}", name, strategy);
            this.buckets.put((String)name, strategy.create());
        });
    }

    @DefaultApplicationMode
    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        Map<String, ResourceThrottleStrategy> strategyMap = this.throttleStrategyProvider.getAll();
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new ThrottleAdjustingJobRunner());
        long intervalSeconds = 0L;
        for (ResourceThrottleStrategy strategy : strategyMap.values()) {
            long value = strategy.getUpdateInterval(TimeUnit.SECONDS).orElse(0L);
            if (value <= 0L) continue;
            intervalSeconds = intervalSeconds == 0L ? value : BigInteger.valueOf(intervalSeconds).gcd(BigInteger.valueOf(value)).longValue();
        }
        if (intervalSeconds > 0L) {
            log.debug("Scheduling throttling adjustment job to run every {} seconds", (Object)intervalSeconds);
            long intervalMillis = TimeUnit.SECONDS.toMillis(intervalSeconds);
            schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)intervalMillis, (Date)new Date(this.clock.utcMillis() + intervalMillis))));
        }
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        schedulerService.unscheduleJob(JOB_ID);
    }

    @Nonnull
    @VisibleForTesting
    SemaphoreTicketBucket getBucketOrThrow(@Nonnull String resourceName, boolean logThrowing) {
        SemaphoreTicketBucket bucket = this.buckets.get(Objects.requireNonNull(resourceName, "resourceName"));
        if (bucket == null) {
            throw this.noSuchResource(resourceName, logThrowing);
        }
        return bucket;
    }

    private CountedTicket acquireTicketOrThrow(String resourceName) throws InterruptedException {
        SemaphoreTicketBucket bucket = this.getBucketOrThrow(resourceName, true);
        if (bucket.tryAcquire()) {
            SimpleTicketContext context = new SimpleTicketContext(resourceName);
            log.trace("Acquired [{}] ticket ({})", (Object)resourceName, (Object)bucket);
            SemaphoreTicket ticket = new SemaphoreTicket(resourceName, context);
            this.tickets.set(ticket);
            if (this.requestContext.isActive()) {
                this.requestContext.addCleanupCallback((Runnable)new ReleaseTickets());
            }
            return ticket;
        }
        log.warn("A [{}] ticket could not be acquired ({})", (Object)resourceName, (Object)bucket);
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.resource.busy", new Object[0]);
        throw new ResourceBusyException(message, resourceName);
    }

    private NoSuchResourceException noSuchResource(String resourceName, boolean logThrowing) {
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.resource.not.configured", new Object[]{resourceName});
        if (logThrowing) {
            log.error(message.getRootMessage());
        }
        return new NoSuchResourceException(message, resourceName);
    }

    @NotThreadSafe
    private class CountedTicket
    extends AbstractTicket {
        private final AtomicInteger count;

        private CountedTicket(String resourceName) {
            super(resourceName);
            this.count = new AtomicInteger(0);
        }

        public void acquire() {
            this.count.incrementAndGet();
        }

        public void close() {
            this.closeIf(input -> this.count.decrementAndGet() == 0);
        }

        protected void onRelease() {
            SemaphoreThrottleService.this.tickets.remove();
        }

        protected void onRetain(int count) {
        }

        private void closeIf(Predicate<Ticket> predicate) {
            Ticket removed = SemaphoreThrottleService.this.tickets.get();
            if (removed == this) {
                if (predicate.test(removed)) {
                    this.onRelease();
                } else {
                    this.onRetain(this.count.get());
                }
            } else {
                throw new IllegalStateException("Attempted to release a [" + this.resourceName + "] ticket on a thread which did not own it");
            }
        }

        private void closeNow() {
            this.closeIf(ticket -> true);
        }
    }

    private final class TicketState
    implements TransferableState {
        private final StubTicket state;

        public TicketState(CountedTicket ticket) {
            if (ticket == null) {
                this.state = null;
            } else {
                this.state = new StubTicket(SemaphoreThrottleService.this, ticket);
                this.state.acquire();
            }
        }

        public void apply() {
            SemaphoreThrottleService.this.tickets.set(this.state);
        }

        public void remove() {
            SemaphoreThrottleService.this.cleanupTickets();
        }
    }

    private class ThrottleAdjustingJobRunner
    implements JobRunner {
        private final Map<String, Long> nextUpdateTimestamps = new HashMap<String, Long>();

        private ThrottleAdjustingJobRunner() {
        }

        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            long now = SemaphoreThrottleService.this.clock.utcMillis();
            SemaphoreThrottleService.this.throttleStrategyProvider.getAll().forEach((name, strategy) -> strategy.getUpdateInterval(TimeUnit.MILLISECONDS).ifPresent(updateInterval -> {
                long nextRunTime = (Long)MoreObjects.firstNonNull((Object)this.nextUpdateTimestamps.get(name), (Object)now);
                if (nextRunTime <= now) {
                    try {
                        strategy.update(SemaphoreThrottleService.this.getBucketOrThrow((String)name, true));
                        this.nextUpdateTimestamps.put((String)name, now + updateInterval);
                    }
                    catch (Exception e) {
                        log.error("Failed to update throttle limits for {}", name, (Object)e);
                    }
                }
            }));
            return JobRunnerResponse.success((String)"Successfully update throttle limits");
        }
    }

    private static class SimpleTicketContext
    implements TicketContext {
        private final String resourceName;

        public SimpleTicketContext(String resourceName) {
            this.resourceName = resourceName;
        }

        @Nonnull
        public String getResourceName() {
            return this.resourceName;
        }
    }

    @NotThreadSafe
    private final class SemaphoreTicket
    extends CountedTicket {
        private final SimpleTicketContext context;

        private SemaphoreTicket(String resourceName, SimpleTicketContext context) {
            super(resourceName);
            this.context = context;
        }

        @Override
        protected void onRelease() {
            super.onRelease();
            SemaphoreTicketBucket bucket = SemaphoreThrottleService.this.buckets.get(this.resourceName);
            bucket.release();
            log.trace("Released [{}] ticket ({})", (Object)this.resourceName, (Object)bucket);
        }

        @Override
        protected void onRetain(int count) {
            log.trace("Not releasing [{}] ticket ({} acquire(s) remain)", (Object)this.resourceName, (Object)count);
        }
    }

    private class ReleaseTickets
    implements Runnable {
        private ReleaseTickets() {
        }

        @Override
        public void run() {
            SemaphoreThrottleService.this.cleanupTickets();
        }
    }

    @NotThreadSafe
    private class StubTicket
    extends CountedTicket {
        private StubTicket(SemaphoreThrottleService semaphoreThrottleService, CountedTicket ticket) {
            super(ticket.getResourceName());
        }
    }
}

