/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.throttle;

import com.atlassian.stash.internal.throttle.TicketSummary;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SemaphoreTicketBucket {
    private static final Logger log = LoggerFactory.getLogger(SemaphoreTicketBucket.class);
    private final long defaultAcquireTimeoutMillis;
    private final ResizeableSemaphore semaphore;
    private final ConcurrentSkipListSet<Timing> timings;
    private volatile int permits;
    private volatile long lastRejectedTimestamp;

    public SemaphoreTicketBucket(int permits, long defaultAcquireTimeout, @Nonnull TimeUnit unit) {
        this.defaultAcquireTimeoutMillis = Math.max(0L, unit.toMillis(defaultAcquireTimeout));
        this.permits = permits;
        this.semaphore = new ResizeableSemaphore(permits, defaultAcquireTimeout > 0L);
        this.timings = new ConcurrentSkipListSet();
    }

    public long getEarliestQueuingTime() {
        if (this.timings.isEmpty()) {
            return 0L;
        }
        try {
            return this.timings.first().start;
        }
        catch (NoSuchElementException e) {
            return 0L;
        }
    }

    public long getLastRejectedTimestamp() {
        return this.lastRejectedTimestamp;
    }

    public int getTotalTickets() {
        return this.permits;
    }

    public void release() {
        this.semaphore.release();
    }

    public TicketSummary summarize(String name) {
        long oldest = this.getEarliestQueuingTime();
        long lastRejection = this.getLastRejectedTimestamp();
        int availablePermits = this.semaphore.availablePermits();
        return new TicketSummary(availablePermits, lastRejection == 0L ? null : new Date(lastRejection), name, oldest == 0L ? null : new Date(oldest), this.semaphore.getQueueLength(), this.permits, this.permits - availablePermits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermits(int newPermits) {
        Preconditions.checkArgument((newPermits >= 0 ? 1 : 0) != 0, (Object)"Permits must be non-negative");
        if (newPermits == this.permits) {
            return;
        }
        SemaphoreTicketBucket semaphoreTicketBucket = this;
        synchronized (semaphoreTicketBucket) {
            int currentPermits = this.permits;
            if (newPermits == currentPermits) {
                return;
            }
            if (newPermits > currentPermits) {
                int delta = newPermits - currentPermits;
                log.trace("Increasing tickets by {}", (Object)delta);
                this.semaphore.release(delta);
            } else {
                int delta = currentPermits - newPermits;
                log.trace("Decreasing tickets by {}", (Object)delta);
                this.semaphore.reducePermits(delta);
            }
            this.permits = newPermits;
        }
    }

    public String toString() {
        int available = this.semaphore.availablePermits();
        return available < 0 ? "0/" + this.permits + "+" + -1 * available : available + "/" + this.permits;
    }

    public boolean tryAcquire() throws InterruptedException {
        return this.tryAcquire(this.defaultAcquireTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAcquire(long timeout, TimeUnit timeUnit) throws InterruptedException {
        Timing timing = new Timing();
        this.timings.add(timing);
        try {
            if (this.semaphore.tryAcquire(timeout, timeUnit)) {
                boolean bl = true;
                return bl;
            }
            this.lastRejectedTimestamp = System.currentTimeMillis();
            boolean bl = false;
            return bl;
        }
        finally {
            this.timings.remove(timing);
        }
    }

    @VisibleForTesting
    long getDefaultAcquireTimeoutMillis() {
        return this.defaultAcquireTimeoutMillis;
    }

    private static class ResizeableSemaphore
    extends Semaphore {
        public ResizeableSemaphore(int permits, boolean fair) {
            super(permits, fair);
        }

        @Override
        public void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }

    private static class Timing
    implements Comparable<Timing> {
        private final long start = System.currentTimeMillis();

        private Timing() {
        }

        @Override
        public int compareTo(@Nonnull Timing o) {
            return (int)(this.start - o.start);
        }
    }
}

