/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.throttle;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class ThrottlingConstants {
    public static final long MEM_1MB = 0x100000L;
    public static final int INTERVALS_MAX_WITHOUT_CPU = 4;
    public static final String RESOURCE_GIT_LFS = "git-lfs";
    public static final String RESOURCE_PROP_PREFIX = "throttle.resource.";
    public static final String RESOURCE_PROP_SUFFIX_ADAPTIVE_CPU_HISTORICAL_WEIGHTING = ".adaptive.cpu.historical.weighting";
    public static final String RESOURCE_PROP_SUFFIX_ADAPTIVE_CPU_PER_TICKET = ".adaptive.cpu.per.ticket";
    public static final String RESOURCE_PROP_SUFFIX_ADAPTIVE_CPU_TARGET_USAGE = ".adaptive.cpu.target";
    public static final String RESOURCE_PROP_SUFFIX_ADAPTIVE_INTERVAL = ".adaptive.interval";
    public static final String RESOURCE_PROP_SUFFIX_ADAPTIVE_MEM_BACKSTOP_ENABLED = ".adaptive.mem.backstop.enabled";
    public static final String RESOURCE_PROP_SUFFIX_ADAPTIVE_MEM_PER_TICKET = ".adaptive.mem.per.ticket";
    public static final String RESOURCE_PROP_SUFFIX_ADAPTIVE_MEM_SEARCH = ".adaptive.mem.search";
    public static final String RESOURCE_PROP_SUFFIX_ADAPTIVE_MEM_SEARCH_RESIDENT = ".adaptive.mem.search.resident";
    public static final String RESOURCE_PROP_SUFFIX_ADAPTIVE_MEM_WEBAPP = ".adaptive.mem.webapp";
    public static final String RESOURCE_PROP_SUFFIX_ADAPTIVE_LIMIT_MAX = ".adaptive.limit.max";
    public static final String RESOURCE_PROP_SUFFIX_ADAPTIVE_LIMIT_MIN = ".adaptive.limit.min";
    public static final String RESOURCE_PROP_SUFFIX_FIXED_LIMIT = ".fixed.limit";
    public static final String RESOURCE_PROP_SUFFIX_STRATEGY = ".strategy";
    public static final String RESOURCE_PROP_SUFFIX_TIMEOUT = ".timeout";
    public static final String RESOURCE_PROP_VALUE_ADAPTIVE_MEM_WEBAPP_JVM_MAX = "jvmmax";
    public static final String LOGGER_PREFIX_THROTTLING_PROFILE = "throttle.profile.";
    public static boolean FALLBACK_ADAPTIVE_MEM_BACKSTOP_ENABLED = true;
    public static int FALLBACK_ADAPTIVE_MEM_PER_TICKET = 256;
    public static int FALLBACK_ADAPTIVE_MEM_SEARCH_SIZE = 512;
    public static final double FALLBACK_ADAPTIVE_CPU_HISTORICAL_WEIGHTING = 0.8;
    public static final double FALLBACK_ADAPTIVE_CPU_PER_TICKET = 0.08 / (double)Runtime.getRuntime().availableProcessors();
    public static final int FALLBACK_ADAPTIVE_INTERVAL_SECONDS = 5;
    public static final double FALLBACK_ADAPTIVE_TARGET_CPU_USAGE = 0.75;
    public static final double FALLLBACK_ADAPTIVE_CPU_SCALE_MAX_TICKETS = 4.0;
    public static final double FALLBACK_ADAPTIVE_CPU_SCALE_MIN_TICKETS = 1.0;
    public static final double FALLBACK_ADAPTIVE_TICKETS = 4.0 * (double)Runtime.getRuntime().availableProcessors();
    public static final Map<String, Integer> FALLBACK_FIXED_TICKETS = ImmutableMap.of((Object)"scm-hosting", (Object)((int)Math.round(1.5 * (double)Runtime.getRuntime().availableProcessors())), (Object)"mirror-hosting", (Object)(2 * Runtime.getRuntime().availableProcessors()), (Object)"scm-command", (Object)25, (Object)"git-lfs", (Object)80);
    public static final Map<String, Integer> FALLBACK_TICKET_TIMEOUT_SECONDS = ImmutableMap.of((Object)"scm-hosting", (Object)300, (Object)"mirror-hosting", (Object)3600, (Object)"scm-command", (Object)2, (Object)"git-lfs", (Object)0);
}

