/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.throttle;

import com.atlassian.bitbucket.ResourceBusyException;
import com.atlassian.bitbucket.dmz.throttle.DmzThrottleService;
import com.atlassian.bitbucket.dmz.throttle.Ticket;
import com.atlassian.bitbucket.dmz.throttle.TicketContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.config.Clock;
import com.atlassian.stash.internal.profiles.MeshSidecar;
import com.atlassian.stash.internal.throttle.ResourceThrottleStrategyProvider;
import com.atlassian.stash.internal.throttle.SemaphoreThrottleService;
import com.atlassian.stash.internal.throttle.TicketSummary;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=DmzThrottleService.class)
@Deprecated
@MeshSidecar
@Service(value="throttleService")
public class UnlimitedThrottleService
extends SemaphoreThrottleService {
    private static final Set<String> UNLIMITED_RESOURCES = ImmutableSet.of((Object)"mirror-hosting", (Object)"scm-command", (Object)"scm-hosting", (Object)"scm-refs");
    private static final Logger log = LoggerFactory.getLogger(UnlimitedThrottleService.class);
    private final ConcurrentMap<String, Integer> ticketCounts = new ConcurrentHashMap<String, Integer>();

    public UnlimitedThrottleService(Clock clock, EventPublisher eventPublisher, I18nService i18nService, RequestContext requestContext, ResourceThrottleStrategyProvider throttleStrategyProvider) {
        super(clock, eventPublisher, i18nService, requestContext, throttleStrategyProvider);
    }

    @Override
    @Nonnull
    public Ticket acquireTicket(@Nonnull String resourceName) throws ResourceBusyException {
        if (UNLIMITED_RESOURCES.contains(Objects.requireNonNull(resourceName, "resourceName"))) {
            SimpleTicket ticket = new SimpleTicket(resourceName);
            return ticket;
        }
        return super.acquireTicket(resourceName);
    }

    @Override
    public long getLongestQueueingTimeForCurrentTicketRequests(@Nonnull String resourceName) {
        return UNLIMITED_RESOURCES.contains(Objects.requireNonNull(resourceName, "resourceName")) ? 0L : super.getLongestQueueingTimeForCurrentTicketRequests(resourceName);
    }

    @Override
    public long getTimeSinceLastRejectedTicketRequest(@Nonnull String resourceName) {
        return UNLIMITED_RESOURCES.contains(Objects.requireNonNull(resourceName, "resourceName")) ? 0L : super.getTimeSinceLastRejectedTicketRequest(resourceName);
    }

    @Override
    @Nonnull
    public TicketSummary[] getSummaries() {
        return (TicketSummary[])Arrays.stream(super.getSummaries()).filter(summary -> !UNLIMITED_RESOURCES.contains(Objects.requireNonNull(summary.getName(), "summaryName"))).toArray(TicketSummary[]::new);
    }

    @Override
    @Nonnull
    public TicketSummary getSummary(@Nonnull String resourceName) {
        if (UNLIMITED_RESOURCES.contains(Objects.requireNonNull(resourceName, "resourceName"))) {
            int currentTickets = this.ticketCounts.getOrDefault(Objects.requireNonNull(resourceName, "resourceName"), 0);
            return new TicketSummary(Integer.MAX_VALUE - currentTickets, null, resourceName, null, 0, Integer.MAX_VALUE, currentTickets);
        }
        return super.getSummary(resourceName);
    }

    private static final class SimpleTicket
    implements Ticket,
    TicketContext {
        private final AtomicBoolean closed;
        private final String resourceName;

        private SimpleTicket(String resourceName) {
            this.resourceName = resourceName;
            this.closed = new AtomicBoolean(false);
        }

        public void close() {
            this.closed.compareAndSet(false, true);
        }

        @Nonnull
        public String getResourceName() {
            return this.resourceName;
        }
    }
}

