/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.throttle.analytics;

import com.atlassian.bitbucket.event.ApplicationEvent;
import jakarta.annotation.Nonnull;

public abstract class BaseThrottlingConfiguredAnalyticsEvent
extends ApplicationEvent {
    private final String resourceName;
    private final long queueTimeoutSeconds;

    public BaseThrottlingConfiguredAnalyticsEvent(@Nonnull Object source, @Nonnull String resourceName, long queueTimeoutSeconds) {
        super(source);
        this.resourceName = this.normaliseResourceName(resourceName);
        this.queueTimeoutSeconds = queueTimeoutSeconds;
    }

    private String normaliseResourceName(String resourceName) {
        switch (resourceName) {
            case "scm-hosting": 
            case "scm-command": 
            case "git-lfs": {
                return resourceName;
            }
        }
        return "custom";
    }

    @Nonnull
    public String getResourceName() {
        return this.resourceName;
    }

    public long getQueueTimeoutSeconds() {
        return this.queueTimeoutSeconds;
    }
}

