/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.throttle.analytics;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import jakarta.annotation.Nonnull;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ThrottlingAnalyticsPublisher
extends AbstractSmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(ThrottlingAnalyticsPublisher.class);
    private final LinkedBlockingDeque<ApplicationEvent> events;
    private final EventPublisher eventPublisher;

    @Autowired
    public ThrottlingAnalyticsPublisher(@Nonnull EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.events = new LinkedBlockingDeque(1024);
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public void start() {
        super.start();
        this.pumpEvents();
    }

    public void publish(ApplicationEvent event) {
        if (this.isRunning()) {
            this.eventPublisher.publish((Object)event);
        } else {
            if (!this.events.offer(event)) {
                log.warn("Dropping throttling analytics event of type {} as the deque is full", (Object)event.getClass().getName());
            }
            if (this.isRunning()) {
                this.pumpEvents();
            }
        }
    }

    private void pumpEvents() {
        ApplicationEvent event = this.events.poll();
        while (event != null) {
            this.eventPublisher.publish((Object)event);
            event = this.events.poll();
        }
    }
}

