/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.timezone;

import com.atlassian.bitbucket.event.user.UserTimeZoneChangedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.timezone.TimeZoneService;
import com.atlassian.bitbucket.timezone.UserTimeZoneSupplier;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.IllegalUserStateException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.user.ApplicationUserDao;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalAuthenticationContext;
import com.atlassian.stash.internal.user.InternalNormalUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.ZoneId;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(interfaces={UserTimeZoneSupplier.class, TimeZoneService.class})
@Component(value="timezoneService")
@Transactional(propagation=Propagation.SUPPORTS)
public class DefaultTimeZoneService
implements TimeZoneService {
    private final InternalAuthenticationContext authenticationContext;
    private final InternalApplicationPropertiesService applicationPropertiesService;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final ApplicationUserDao applicationUserDao;

    @Autowired
    public DefaultTimeZoneService(InternalAuthenticationContext authenticationContext, InternalApplicationPropertiesService applicationPropertiesService, I18nService i18nService, EventPublisher eventPublisher, ApplicationUserDao applicationUserDao) {
        this.authenticationContext = authenticationContext;
        this.applicationPropertiesService = applicationPropertiesService;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.applicationUserDao = applicationUserDao;
    }

    @Nonnull
    @Unsecured(value="Anyone can look up the server timezone")
    public Optional<ZoneId> getServerTimeZone() {
        return this.applicationPropertiesService.getServerTimeZone();
    }

    @Nonnull
    @Unsecured(value="Anyone can query their own timezone")
    public Optional<ZoneId> getUserTimeZone() {
        return this.getUserTimeZone(this.authenticationContext.getCurrentUser());
    }

    @Nonnull
    @Unsecured(value="Anyone can look up the default timezone")
    public ZoneId getDefaultTimeZone() {
        return this.getServerTimeZone().orElseGet(this::getJvmTimeZone);
    }

    @Nonnull
    @Unsecured(value="Anyone can look up the JVM timezone")
    public ZoneId getJvmTimeZone() {
        return ZoneId.systemDefault();
    }

    @Nonnull
    @Unsecured(value="Anyone can look up their own timezone")
    public ZoneId getTimeZone() {
        return this.getTimeZone(this.authenticationContext.getCurrentUser());
    }

    @Nonnull
    @Unsecured(value="Anyone can look up another user's timezone")
    public ZoneId getTimeZone(@Nullable ApplicationUser user) {
        return this.getUserTimeZone(user).orElseGet(this::getDefaultTimeZone);
    }

    @Secured(value="Secured by ApplicationPropertiesService.setServiceTimeZone")
    @Transactional
    public void setServerTimeZone(@Nullable ZoneId zone) {
        this.applicationPropertiesService.setServerTimeZone(zone);
    }

    @PreAuthorize(value="hasUserPermission('USER_ADMIN')")
    @Transactional
    public void setUserTimeZone(@Nullable ZoneId zone) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        InternalNormalUser normalUser = (InternalNormalUser)InternalNormalUser.fromUser((ApplicationUser)currentUser).orElseThrow(() -> new IllegalUserStateException(this.i18nService.createKeyedMessage("bitbucket.service.timezone.user.cannot.set", new Object[]{InternalNormalUser.class, currentUser.getClass()})));
        ZoneId oldValue = normalUser.getTimeZone();
        if (ObjectUtils.notEqual((Object)oldValue, (Object)zone)) {
            InternalApplicationUser updatedUser = (InternalApplicationUser)this.applicationUserDao.update((Object)normalUser.copy().timeZone(zone).build());
            this.authenticationContext.refreshUser((ApplicationUser)updatedUser);
            this.eventPublisher.publish((Object)new UserTimeZoneChangedEvent((Object)this, (ApplicationUser)updatedUser, this.getIdOrNull(oldValue), this.getIdOrNull(zone)));
        }
    }

    private String getIdOrNull(ZoneId zone) {
        return zone == null ? null : zone.getId();
    }

    private Optional<ZoneId> getUserTimeZone(ApplicationUser user) {
        return Optional.ofNullable(user).flatMap(InternalNormalUser::fromUser).map(InternalNormalUser::getTimeZone);
    }
}

