/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.topic;

import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.stash.internal.topic.MessageQueue;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;

public class DeduplicatingQueue<T>
implements MessageQueue<T> {
    private final int capacity;
    private final LinkedHashSet<MessageEventWrapper<T>> queue;

    public DeduplicatingQueue(int capacity) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"capacity must be > 0");
        this.capacity = capacity;
        this.queue = new LinkedHashSet(16, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        LinkedHashSet<MessageEventWrapper<T>> linkedHashSet = this.queue;
        synchronized (linkedHashSet) {
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(@Nonnull MessageEvent<T> event) {
        Objects.requireNonNull(event);
        LinkedHashSet<MessageEventWrapper<T>> linkedHashSet = this.queue;
        synchronized (linkedHashSet) {
            if (this.queue.size() >= this.capacity) {
                return false;
            }
            this.queue.add(new MessageEventWrapper<T>(event));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageEvent<T> poll() {
        LinkedHashSet<MessageEventWrapper<T>> linkedHashSet = this.queue;
        synchronized (linkedHashSet) {
            if (this.queue.isEmpty()) {
                return null;
            }
            Iterator iterator = this.queue.iterator();
            MessageEvent element = ((MessageEventWrapper)iterator.next()).getDelegate();
            iterator.remove();
            return element;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        LinkedHashSet<MessageEventWrapper<T>> linkedHashSet = this.queue;
        synchronized (linkedHashSet) {
            return this.queue.size();
        }
    }

    private static class MessageEventWrapper<T> {
        private final MessageEvent<T> delegate;

        MessageEventWrapper(MessageEvent<T> event) {
            this.delegate = event;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MessageEventWrapper)) {
                return false;
            }
            MessageEventWrapper other = (MessageEventWrapper)o;
            return Objects.equals(this.delegate.getMessage(), other.delegate.getMessage());
        }

        public int hashCode() {
            return Objects.hashCode(this.delegate.getMessage());
        }

        private MessageEvent<T> getDelegate() {
            return this.delegate;
        }
    }
}

