/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.topic;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.topic.MessageEvent;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.Objects;

public class DefaultMessageEvent<T>
implements MessageEvent<T> {
    private final T message;
    private final ClusterNode source;
    private final long timestamp;
    private final String topic;

    public DefaultMessageEvent(@Nonnull ClusterNode source, long timestamp, @Nonnull String topic, @Nonnull T message) {
        this.message = Objects.requireNonNull(message, "message");
        this.source = Objects.requireNonNull(source, "source");
        this.timestamp = timestamp;
        this.topic = Objects.requireNonNull(topic, "topic");
    }

    @Nonnull
    public T getMessage() {
        return this.message;
    }

    @Nonnull
    public String getTopic() {
        return this.topic;
    }

    @Nonnull
    public Date getPublishTime() {
        return new Date(this.timestamp);
    }

    @Nonnull
    public ClusterNode getSource() {
        return this.source;
    }
}

