/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.topic;

import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.stash.internal.topic.MessageQueue;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class DefaultMessageQueue<T>
implements MessageQueue<T> {
    private final Queue<MessageEvent<T>> delegate;

    public DefaultMessageQueue(int capacity) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"capacity must be > 0");
        this.delegate = new LinkedBlockingQueue<MessageEvent<T>>(capacity);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public MessageEvent<T> poll() {
        return this.delegate.poll();
    }

    @Override
    public boolean offer(@Nonnull MessageEvent<T> event) {
        Objects.requireNonNull(event);
        return this.delegate.offer(event);
    }
}

