/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.topic;

import com.atlassian.bitbucket.dmz.cluster.exception.TopicSerializationException;
import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.util.concurrent.ExecutorUtils;
import com.atlassian.nutcluster.core.ITopic;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.nio.serialization.NutclusterSerializationException;
import com.atlassian.nutcluster.serialization.OsgiSafe;
import com.atlassian.stash.internal.cluster.NutclusterClusterNode;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.topic.DeduplicatingQueue;
import com.atlassian.stash.internal.topic.DefaultMessageEvent;
import com.atlassian.stash.internal.topic.DefaultMessageQueue;
import com.atlassian.stash.internal.topic.MessageQueue;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NutclusterTopicService
implements TopicService {
    private static final Logger log = LoggerFactory.getLogger(NutclusterTopicService.class);
    private final Map<String, AtomicInteger> activeDispatchCountByTopic;
    private final int defaultTopicQueueSize;
    private final ExecutorService executorService;
    private final NutclusterInstance nutcluster;
    private final int maxTopicQueueSize;
    private final InternalApplicationPropertiesService propertiesService;
    private final Map<String, DefaultTopic> topics;
    private volatile boolean destroyed;

    public NutclusterTopicService(ExecutorService executorService, NutclusterInstance nutcluster, InternalApplicationPropertiesService propertiesService, int defaultTopicQueueSize, int maxTopicQueueSize) {
        this.defaultTopicQueueSize = defaultTopicQueueSize;
        this.executorService = executorService;
        this.nutcluster = nutcluster;
        this.maxTopicQueueSize = maxTopicQueueSize;
        this.propertiesService = propertiesService;
        this.activeDispatchCountByTopic = new ConcurrentHashMap<String, AtomicInteger>();
        this.topics = new ConcurrentHashMap<String, DefaultTopic>();
    }

    @Nonnull
    public <T extends Serializable> Topic<T> getTopic(@Nonnull String topic, @Nonnull TopicSettings<T> settings) {
        return this.topics.computeIfAbsent(topic, name -> {
            TopicSettings effectiveSettings = new TopicSettings.Builder(settings).queueSize(this.getQueueSize((String)name, settings.getQueueSize())).build();
            return new DefaultTopic(topic, effectiveSettings);
        });
    }

    @PreDestroy
    public void destroy() {
        this.destroyed = true;
        ExecutorUtils.shutdown((ExecutorService)this.executorService, (Logger)log);
        this.topics.values().forEach(DefaultTopic::destroy);
        this.topics.clear();
        this.activeDispatchCountByTopic.clear();
    }

    private void checkNotDestroyed() {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"The TopicService has already been destroyed");
    }

    private void dispatchNextMessage(DefaultTopic<?> topic) {
        AtomicInteger messageCount = this.activeDispatchCountByTopic.computeIfAbsent(topic.getName(), name -> new AtomicInteger(0));
        int count = messageCount.incrementAndGet();
        if (count > 1) {
            return;
        }
        while (count > 0 && !this.destroyed) {
            topic.dispatchNextMessage();
            count = messageCount.decrementAndGet();
        }
    }

    private <T extends Serializable> ITopic<OsgiSafe<T>> getNutclusterTopic(String name) {
        return this.nutcluster.getTopic("topicService:" + name);
    }

    private int getQueueSize(String topicName, int queueSize) {
        if (queueSize != -1) {
            return this.limitQueueSize(topicName, queueSize);
        }
        String property = "topic." + topicName.replaceAll("\\s+", "_") + ".message.max.queue";
        int configuredDefault = Math.min(this.propertiesService.getProperty(property, Integer.MIN_VALUE), this.maxTopicQueueSize);
        if (configuredDefault != Integer.MIN_VALUE) {
            log.info("[{}] set message queue size to {} as configured in the application properties", (Object)topicName, (Object)configuredDefault);
            return this.limitQueueSize(topicName, configuredDefault);
        }
        return this.defaultTopicQueueSize;
    }

    private int limitQueueSize(String topicName, int size) {
        if (size > this.maxTopicQueueSize) {
            log.info("[{}] reducing message queue size to {} because the configured value ({}) exceeds the maximum allowed queue size", new Object[]{topicName, this.maxTopicQueueSize, size});
            return this.maxTopicQueueSize;
        }
        return size;
    }

    private void scheduleDispatch(DefaultTopic<?> topic) {
        this.executorService.submit(() -> this.dispatchNextMessage(topic));
    }

    private class DefaultTopic<T extends Serializable>
    implements Topic<T> {
        private final AtomicLong droppedEventCount;
        private final Object lock;
        private final MessageQueue<T> messages;
        private final TopicSettings<T> settings;
        private final List<Subscription<T>> subscriptions;
        private final String timerString;
        private final String topicName;
        private ITopic<OsgiSafe<T>> nutclusterTopic;
        private String registrationId;
        private volatile long nextLogTimestamp;

        DefaultTopic(@Nonnull String topicName, TopicSettings<T> settings) {
            this.settings = Objects.requireNonNull(settings, "settings");
            this.topicName = Objects.requireNonNull(topicName, "topicName");
            this.droppedEventCount = new AtomicLong();
            this.lock = new Object();
            this.messages = settings.isDedupePendingMessages() ? new DeduplicatingQueue(settings.getQueueSize()) : new DefaultMessageQueue(settings.getQueueSize());
            this.subscriptions = new CopyOnWriteArrayList<Subscription<T>>();
            this.timerString = "TopicListener.onMessage('" + topicName + "', T)";
        }

        @Nonnull
        public TopicSettings<T> getSettings() {
            return this.settings;
        }

        public void publish(@Nonnull T message) {
            NutclusterTopicService.this.checkNotDestroyed();
            try {
                this.getNutclusterTopic().publish((Object)new OsgiSafe((Object)((Serializable)Objects.requireNonNull(message, "message"))));
            }
            catch (NutclusterSerializationException e) {
                throw new TopicSerializationException((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        public String subscribe(@Nonnull TopicListener<T> listener) {
            NutclusterTopicService.this.checkNotDestroyed();
            Subscription<T> subscription = new Subscription<T>(NutclusterTopicService.this, Objects.requireNonNull(listener, "listener"));
            Object object = this.lock;
            synchronized (object) {
                this.subscriptions.add(subscription);
                if (this.subscriptions.size() == 1) {
                    this.register();
                }
            }
            return subscription.getId();
        }

        public String getName() {
            return this.topicName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean unsubscribe(@Nonnull String subscriptionId) {
            NutclusterTopicService.this.checkNotDestroyed();
            Objects.requireNonNull(subscriptionId, "subscriptionId");
            Object object = this.lock;
            synchronized (object) {
                if (this.subscriptions.removeIf(subscription -> subscriptionId.equals(subscription.getId()))) {
                    if (this.subscriptions.isEmpty()) {
                        this.unregister();
                        this.messages.clear();
                    }
                    return true;
                }
            }
            return false;
        }

        private T castMessage(Object value) {
            return (T)this.settings.getMessageType().map(type -> (Serializable)type.cast(value)).orElse((Serializable)value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void destroy() {
            Object object = this.lock;
            synchronized (object) {
                this.unregister();
                int messageCount = this.messages.size();
                this.messages.clear();
                this.subscriptions.clear();
                long dropped = this.droppedEventCount.get();
                if (dropped > 0L || messageCount > 0) {
                    log.info("[{}] shutting down. {} messages were still in the queue{}.", new Object[]{this.topicName, messageCount, dropped > 0L ? " (" + dropped + " were dropped in the last minute because the queue was full)" : ""});
                }
            }
        }

        private void dispatchNextMessage() {
            MessageEvent<T> message = this.messages.poll();
            if (message == null) {
                return;
            }
            int count = 0;
            for (Subscription<T> subscription : this.subscriptions) {
                TopicListener<T> listener = subscription.getListener();
                try {
                    Timer ignored = TimerUtils.start((String)this.timerString);
                    try {
                        listener.onMessage(message);
                        ++count;
                    }
                    finally {
                        if (ignored == null) continue;
                        ignored.close();
                    }
                }
                catch (Exception e) {
                    log.warn("[{}] error dispatching message to listener {}", new Object[]{this.topicName, listener.getClass(), e});
                }
            }
            if (log.isTraceEnabled() && count > 0) {
                log.trace("[{}] successfully dispatched a message from {} to {} listener{}", new Object[]{this.topicName, message.getSource().getAddress(), count, count > 1 ? "s" : ""});
            }
        }

        private ITopic<OsgiSafe<T>> getNutclusterTopic() {
            if (this.nutclusterTopic == null) {
                this.nutclusterTopic = NutclusterTopicService.this.getNutclusterTopic(this.topicName);
            }
            return this.nutclusterTopic;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeLogFullQueueWarning() {
            long dropped = this.droppedEventCount.get();
            long now = System.nanoTime();
            if (dropped > 0L && now > this.nextLogTimestamp) {
                Object object = this.lock;
                synchronized (object) {
                    if (now <= this.nextLogTimestamp) {
                        return;
                    }
                    this.nextLogTimestamp = now + TimeUnit.MINUTES.toNanos(1L);
                    dropped = this.droppedEventCount.getAndSet(0L);
                }
                log.warn("[{}] Message queue is full. Dropped {} events in the last minute.", (Object)this.topicName, (Object)dropped);
            }
        }

        private void register() {
            if (this.registrationId != null) {
                this.unregister();
            }
            this.registrationId = this.getNutclusterTopic().addMessageListener(message -> {
                T value = this.castMessage(((OsgiSafe)message.getMessageObject()).getValue());
                if (this.messages.offer(new DefaultMessageEvent<T>(NutclusterClusterNode.transform(message.getPublishingMember()), message.getPublishTime(), this.topicName, value))) {
                    log.trace("[{}] queued a message from {}", (Object)this.topicName, (Object)message.getPublishingMember());
                    NutclusterTopicService.this.scheduleDispatch(this);
                } else {
                    this.droppedEventCount.incrementAndGet();
                }
                this.maybeLogFullQueueWarning();
            });
        }

        private void unregister() {
            if (this.registrationId != null && this.nutclusterTopic != null) {
                this.nutclusterTopic.removeMessageListener(this.registrationId);
                this.registrationId = null;
            }
        }
    }

    private class Subscription<T extends Serializable> {
        private final String id;
        private final TopicListener<T> listener;

        private Subscription(NutclusterTopicService nutclusterTopicService, TopicListener<T> listener) {
            this.listener = listener;
            this.id = UUID.randomUUID().toString();
        }

        public String getId() {
            return this.id;
        }

        public TopicListener<T> getListener() {
            return this.listener;
        }
    }
}

