/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.upgrade;

import com.atlassian.bitbucket.dmz.upgrade.async.AsyncDatabaseTaskComplete;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.diagnostics.AlertRequest;
import com.atlassian.diagnostics.ComponentMonitor;
import com.atlassian.diagnostics.Issue;
import com.atlassian.diagnostics.MonitoringService;
import com.atlassian.diagnostics.Severity;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.upgrade.AsyncMigrationDao;
import com.atlassian.stash.internal.upgrade.AsyncMigrationService;
import com.atlassian.stash.internal.upgrade.AsyncMigrationStatus;
import com.atlassian.stash.internal.upgrade.AsyncMigrationStatusMXBean;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="asyncMigrationService")
public class DefaultAsyncMigrationService
implements AsyncMigrationService,
ScheduledJobSource {
    static final JobId ASYNC_DB_UPGRADE_JOB_ID = JobId.of((String)AsyncDbUpgradeJobRunner.class.getSimpleName());
    static final JobRunnerKey ASYNC_DB_UPGRADE_JOB_RUNNER_KEY = JobRunnerKey.of((String)AsyncDbUpgradeJobRunner.class.getName());
    static final String LIQUIBASE_LOCK_CLASS_NAME = "liquibase.lockservice.StandardLockService";
    static final String LIQUIBASE_LOCK_METHOD_NAME = "waitForLock";
    static final int MIGRATION_FAILED_ISSUE_ID = 1001;
    static final String UPGRADE_THREAD_NAME = "async-upgrade-thread";
    private static final Duration INITIAL_SCHEDULE_DELAY = Duration.ofSeconds(30L);
    private static final Logger log = LoggerFactory.getLogger(DefaultAsyncMigrationService.class);
    private final Topic<AsyncDatabaseTaskComplete> completeTopic;
    private final AsyncMigrationDao migrationDao;
    private final ComponentMonitor monitor;
    private final Issue migrationFailedIssue;
    private volatile Thread workerThread;

    public DefaultAsyncMigrationService(AsyncMigrationDao asyncMigrationDao, MonitoringService monitoringService, TopicService topicService) {
        this.completeTopic = topicService.getTopic("upgrade:async.database.complete", TopicSettings.builder(AsyncDatabaseTaskComplete.class).build());
        this.migrationDao = asyncMigrationDao;
        this.monitor = monitoringService.createMonitor("DefaultAsynchronousDatabaseUpgradeService", "bitbucket.db.migration.failed.name");
        this.migrationFailedIssue = this.monitor.defineIssue(1001).severity(Severity.ERROR).summaryI18nKey("bitbucket.db.migration.failed.summary").descriptionI18nKey("bitbucket.db.migration.failed.description").build();
    }

    public AsyncMigrationStatusMXBean getLockStatusBean() {
        AsyncMigrationStatus dbStatus = this.migrationDao.getStatus();
        Thread workerThread = this.getWorkerThread();
        boolean migrationRunning = workerThread != null;
        boolean blockedOnLock = false;
        if (migrationRunning) {
            for (StackTraceElement element : workerThread.getStackTrace()) {
                if (!LIQUIBASE_LOCK_CLASS_NAME.equals(element.getClassName()) || !LIQUIBASE_LOCK_METHOD_NAME.equals(element.getMethodName())) continue;
                blockedOnLock = true;
                break;
            }
        }
        return new InternalAsyncMigrationStatus(dbStatus.getLockedBy(), dbStatus.isLocked(), migrationRunning, dbStatus.getLockedGranted(), blockedOnLock);
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        AsyncDbUpgradeJobRunner jobRunner = new AsyncDbUpgradeJobRunner();
        schedulerService.registerJobRunner(ASYNC_DB_UPGRADE_JOB_RUNNER_KEY, (JobRunner)jobRunner);
        Date startTime = Date.from(Instant.now().plus(INITIAL_SCHEDULE_DELAY));
        schedulerService.scheduleJob(ASYNC_DB_UPGRADE_JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)ASYNC_DB_UPGRADE_JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce((Date)startTime)));
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        schedulerService.unregisterJobRunner(ASYNC_DB_UPGRADE_JOB_RUNNER_KEY);
    }

    @Nullable
    Thread getWorkerThread() {
        return this.workerThread;
    }

    private static class InternalAsyncMigrationStatus
    implements AsyncMigrationStatusMXBean {
        private final String dateLocked;
        private final boolean locked;
        private final String lockedBy;
        private final boolean migrationRunning;
        private final boolean waitingOnLock;

        public InternalAsyncMigrationStatus(String lockedBy, boolean locked, boolean migrationRunning, Date dateLocked, boolean waitingOnLock) {
            this.lockedBy = lockedBy;
            this.locked = locked;
            this.migrationRunning = migrationRunning;
            this.dateLocked = dateLocked == null ? null : dateLocked.toString();
            this.waitingOnLock = waitingOnLock;
        }

        public String getDateLocked() {
            return this.dateLocked;
        }

        public String getLockedBy() {
            return this.lockedBy;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public boolean isMigrationRunning() {
            return this.migrationRunning;
        }

        public boolean isMigrationWaitingOnLock() {
            return this.waitingOnLock;
        }
    }

    private class AsyncDbUpgradeJobRunner
    implements JobRunner {
        private AsyncDbUpgradeJobRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
            DefaultAsyncMigrationService.this.workerThread = Thread.currentThread();
            String oldName = DefaultAsyncMigrationService.this.workerThread.getName();
            try {
                DefaultAsyncMigrationService.this.workerThread.setName(DefaultAsyncMigrationService.UPGRADE_THREAD_NAME);
                DefaultAsyncMigrationService.this.migrationDao.upgrade();
                DefaultAsyncMigrationService.this.completeTopic.publish((Serializable)new AsyncDatabaseTaskComplete(true));
                JobRunnerResponse jobRunnerResponse = JobRunnerResponse.success();
                return jobRunnerResponse;
            }
            catch (RuntimeException e) {
                log.error("Async upgrade task failed", (Throwable)e);
                DefaultAsyncMigrationService.this.monitor.alert(new AlertRequest.Builder(DefaultAsyncMigrationService.this.migrationFailedIssue).timestamp(Instant.now()).build());
                DefaultAsyncMigrationService.this.completeTopic.publish((Serializable)new AsyncDatabaseTaskComplete(false));
                JobRunnerResponse jobRunnerResponse = JobRunnerResponse.failed((String)"Asynchronous upgrade failed, please see log earlier logs for details");
                return jobRunnerResponse;
            }
            finally {
                DefaultAsyncMigrationService.this.workerThread.setName(oldName);
                DefaultAsyncMigrationService.this.workerThread = null;
            }
        }
    }
}

