/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.user.PasswordResetHelper;
import jakarta.annotation.Nonnull;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="passwordResetHelper")
public class CrowdPasswordResetHelper
implements PasswordResetHelper {
    public static final String PASSWORD_RESET_TOKEN_ATTRIBUTE = "passwordResetToken";
    public static final Property<String> PASSWORD_RESET_PROPERTY = PropertyUtils.ofTypeString((String)"passwordResetToken");
    public static final String PASSWORD_RESET_TOKEN_EXPIRATION_ATTRIBUTE = "passwordResetExpiration";
    private final CrowdControl crowdControl;
    private final SecureTokenGenerator tokenGenerator;
    private final long tokenValidityPeriod;

    @Autowired
    public CrowdPasswordResetHelper(CrowdControl crowdControl, SecureTokenGenerator tokenGenerator, @Value(value="${password.reset.validity.period}") long tokenValidityPeriod) {
        this.crowdControl = crowdControl;
        this.tokenGenerator = tokenGenerator;
        this.tokenValidityPeriod = TimeUnit.MINUTES.toMillis(tokenValidityPeriod);
    }

    @Override
    @Nonnull
    public String addToken(@Nonnull User user) {
        String token = this.tokenGenerator.generateToken();
        this.crowdControl.setUserAttribute(user, PASSWORD_RESET_TOKEN_ATTRIBUTE, (Object)token);
        this.crowdControl.setUserAttribute(user, PASSWORD_RESET_TOKEN_EXPIRATION_ATTRIBUTE, (Object)(System.currentTimeMillis() + this.tokenValidityPeriod));
        return token;
    }

    @Override
    public void clearToken(@Nonnull User user) {
        this.crowdControl.removeUserAttribute(user, PASSWORD_RESET_TOKEN_EXPIRATION_ATTRIBUTE);
        this.crowdControl.removeUserAttribute(user, PASSWORD_RESET_TOKEN_ATTRIBUTE);
    }

    @Override
    public User findUserByToken(@Nonnull String token) {
        User user = this.crowdControl.findUserByProperty(PASSWORD_RESET_PROPERTY, (Object)token);
        return user == null || !this.hasValidToken(user) ? null : user;
    }

    @Override
    @Nonnull
    public String generatePassword() {
        return this.tokenGenerator.generateToken();
    }

    @Override
    public void resetPassword(@Nonnull User user, String password) {
        this.crowdControl.setPassword(user, password);
        this.clearToken(user);
    }

    private boolean hasValidToken(User user) {
        UserWithAttributes attributes = this.crowdControl.findUserWithAttributes(user.getName());
        if (attributes == null) {
            return false;
        }
        String token = attributes.getValue(PASSWORD_RESET_TOKEN_ATTRIBUTE);
        long expiration = NumberUtils.toLong((String)attributes.getValue(PASSWORD_RESET_TOKEN_EXPIRATION_ATTRIBUTE));
        return token != null && expiration >= System.currentTimeMillis();
    }
}

