/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.dmz.user.DetailedUserCallback;
import com.atlassian.bitbucket.dmz.user.DetailedUserSearchRequest;
import com.atlassian.bitbucket.dmz.user.UserExportFailedEvent;
import com.atlassian.bitbucket.dmz.user.UserExportStartedEvent;
import com.atlassian.bitbucket.dmz.user.UserExportSucceededEvent;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.supercsv.encoder.CsvEncoder;
import org.supercsv.encoder.DefaultCsvEncoder;
import org.supercsv.io.CsvMapWriter;
import org.supercsv.prefs.CsvPreference;

public class CsvExportingDetailedUserCallback
implements DetailedUserCallback {
    private static final String HEADER_NAME = "Name";
    private static final String HEADER_EMAIL = "Email";
    private static final String HEADER_USERNAME = "Username";
    private static final String HEADER_DIRECTORY = "Directory";
    private static final String HEADER_LAST_AUTHENTICATED = "Last Authenticated";
    private static final DateTimeFormatter LAST_AUTHENTICATED_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
    @VisibleForTesting
    static final String[] headers = new String[]{"Name", "Email", "Username", "Directory", "Last Authenticated"};
    @VisibleForTesting
    final MutableBoolean completedExceptionally = new MutableBoolean(false);
    @VisibleForTesting
    final CsvMapWriter writer;
    @VisibleForTesting
    Instant startTime;
    private final Clock clock;
    private final DetailedUserSearchRequest detailedUserSearchRequest;
    private final EventPublisher eventPublisher;
    private int rowsExported;

    public CsvExportingDetailedUserCallback(Clock clock, @Nonnull DetailedUserSearchRequest detailedUserSearchRequest, EventPublisher eventPublisher, OutputStream output) {
        Objects.requireNonNull(detailedUserSearchRequest, "detailedUserSearchRequest");
        this.clock = clock;
        this.detailedUserSearchRequest = detailedUserSearchRequest;
        this.writer = new CsvMapWriter((Writer)new OutputStreamWriter(output), new CsvPreference.Builder(CsvPreference.EXCEL_PREFERENCE).useEncoder((CsvEncoder)new DefaultCsvEncoder()).build());
        this.eventPublisher = eventPublisher;
    }

    public void onEnd() {
        Instant endTime = this.clock.instant();
        try {
            if (this.completedExceptionally.isTrue()) {
                this.writer.writeComment("Exceptions occurred during export, check application logs");
                this.eventPublisher.publish((Object)new UserExportFailedEvent((Object)this, this.detailedUserSearchRequest, Duration.between(this.startTime, endTime), false));
            } else {
                this.writer.writeComment("Finished exporting users successfully");
                this.eventPublisher.publish((Object)new UserExportSucceededEvent((Object)this, this.detailedUserSearchRequest, Duration.between(this.startTime, endTime), this.rowsExported, false));
            }
            this.writer.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to write summary line", e);
        }
    }

    public void onStart() {
        this.eventPublisher.publish((Object)new UserExportStartedEvent((Object)this, this.detailedUserSearchRequest, false));
        this.startTime = this.clock.instant();
        try {
            this.writer.writeHeader(headers);
            this.writer.flush();
        }
        catch (IOException e) {
            this.completedExceptionally.setTrue();
            throw new UncheckedIOException("Unable to write header line", e);
        }
    }

    public void onUser(@Nonnull DetailedUser user) {
        Objects.requireNonNull(user, "user");
        try {
            Date lastAuthenticationTimestamp = user.getLastAuthenticationTimestamp();
            String lastAuthenticated = lastAuthenticationTimestamp != null ? LAST_AUTHENTICATED_FORMATTER.format(LocalDateTime.ofInstant(lastAuthenticationTimestamp.toInstant(), ZoneId.of("UTC"))) : "";
            this.writer.write((Map)ImmutableMap.of((Object)HEADER_NAME, (Object)user.getDisplayName(), (Object)HEADER_EMAIL, (Object)((String)MoreObjects.firstNonNull((Object)user.getEmailAddress(), (Object)"")), (Object)HEADER_USERNAME, (Object)user.getName(), (Object)HEADER_DIRECTORY, (Object)((String)MoreObjects.firstNonNull((Object)user.getDirectoryName(), (Object)"")), (Object)HEADER_LAST_AUTHENTICATED, (Object)lastAuthenticated), headers);
            this.writer.flush();
            ++this.rowsExported;
        }
        catch (IOException e) {
            this.completedExceptionally.setTrue();
            throw new UncheckedIOException("Unable to write user", e);
        }
    }
}

