/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.dmz.user.ScopedPermission;
import com.atlassian.bitbucket.dmz.user.ScopedPermissionCallback;
import com.atlassian.bitbucket.dmz.user.UserExportFailedEvent;
import com.atlassian.bitbucket.dmz.user.UserExportStartedEvent;
import com.atlassian.bitbucket.dmz.user.UserExportSucceededEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.text.WordUtils;
import org.supercsv.encoder.CsvEncoder;
import org.supercsv.encoder.DefaultCsvEncoder;
import org.supercsv.io.CsvMapWriter;
import org.supercsv.prefs.CsvPreference;

public class CsvExportingScopedPermissionCallback
implements ScopedPermissionCallback {
    private static final String HEADER_NAME = "Name";
    private static final String HEADER_EMAIL = "Email";
    private static final String HEADER_USERNAME = "Username";
    private static final String HEADER_PERMISSION = "Permission";
    private static final String HEADER_PROJECT = "Project";
    private static final String HEADER_REPOSITORY = "Repository";
    private static final String HEADER_ORIGIN = "Origin";
    private static final String HEADER_GROUP = "Via Group";
    private static final int USER_BATCH_SIZE = 500;
    @VisibleForTesting
    static final String[] headers = new String[]{"Name", "Email", "Username", "Project", "Repository", "Permission", "Origin", "Via Group"};
    private final Clock clock;
    private final MutableBoolean completedExceptionally = new MutableBoolean(false);
    private final EventPublisher eventPublisher;
    private final UserService userService;
    private final CsvMapWriter writer;
    private int rowsExported;
    private Instant startTime;

    public CsvExportingScopedPermissionCallback(Clock clock, EventPublisher eventPublisher, OutputStream output, UserService userService) {
        this.clock = clock;
        this.eventPublisher = eventPublisher;
        this.userService = userService;
        this.writer = new CsvMapWriter((Writer)new OutputStreamWriter(output), new CsvPreference.Builder(CsvPreference.EXCEL_PREFERENCE).useEncoder((CsvEncoder)new DefaultCsvEncoder()).build());
    }

    public void onEnd() {
        Instant endTime = this.clock.instant();
        try {
            if (this.completedExceptionally.isTrue()) {
                this.writer.writeComment("Exceptions occurred during export, check application logs");
                this.eventPublisher.publish((Object)new UserExportFailedEvent((Object)this, Duration.between(this.startTime, endTime), true));
            } else {
                this.writer.writeComment("Finished exporting permissions successfully");
                this.eventPublisher.publish((Object)new UserExportSucceededEvent((Object)this, Duration.between(this.startTime, endTime), this.rowsExported, true));
            }
            this.writer.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to write summary line", e);
        }
    }

    public void onGroupPermission(@Nonnull ScopedPermission groupPermission) {
        Objects.requireNonNull(groupPermission, "groupPermission");
        String groupName = groupPermission.getGroup().orElse("");
        PageUtils.toStream(nextPage -> this.userService.findUsersByGroup(groupName, nextPage), (int)500).forEach(user -> this.writePermissionAsCsv(groupPermission, (ApplicationUser)user));
    }

    public void onStart() {
        this.startTime = this.clock.instant();
        this.eventPublisher.publish((Object)new UserExportStartedEvent((Object)this, true));
        try {
            this.writer.writeHeader(headers);
            this.writer.flush();
        }
        catch (IOException e) {
            this.completedExceptionally.setTrue();
            throw new UncheckedIOException("Unable to write header line", e);
        }
    }

    public void onUserPermission(@Nonnull ScopedPermission userPermission) {
        Objects.requireNonNull(userPermission, "userPermission");
        this.writePermissionAsCsv(userPermission, null);
    }

    private void writePermissionAsCsv(ScopedPermission permission, ApplicationUser fallbackUser) {
        String projectKey = permission.getProject().map(Project::getKey).orElse(permission.getRepository().map(r -> r.getProject().getKey()).orElse(""));
        String repoSlug = permission.getRepository().map(Repository::getSlug).orElse("");
        ApplicationUser user = permission.getUser().orElse(fallbackUser);
        try {
            this.writer.write((Map)ImmutableMap.of((Object)HEADER_NAME, (Object)user.getDisplayName(), (Object)HEADER_EMAIL, (Object)((String)MoreObjects.firstNonNull((Object)user.getEmailAddress(), (Object)"")), (Object)HEADER_USERNAME, (Object)user.getName(), (Object)HEADER_PROJECT, (Object)projectKey, (Object)HEADER_REPOSITORY, (Object)repoSlug, (Object)HEADER_PERMISSION, (Object)CsvExportingScopedPermissionCallback.getPermissionString(permission.getPermission()), (Object)HEADER_ORIGIN, (Object)CsvExportingScopedPermissionCallback.getPermissionOrigin(permission.getPermission()), (Object)HEADER_GROUP, (Object)permission.getGroup().orElse("")), headers);
            this.writer.flush();
            ++this.rowsExported;
        }
        catch (IOException e) {
            this.completedExceptionally.setTrue();
            throw new UncheckedIOException("Unable to write user permission", e);
        }
    }

    private static String getPermissionOrigin(Permission permission) {
        if (permission.isGlobal()) {
            return "Global";
        }
        if (permission.isResource(Project.class)) {
            return HEADER_PROJECT;
        }
        if (permission.isResource(Repository.class)) {
            return HEADER_REPOSITORY;
        }
        return "Unknown";
    }

    private static String getPermissionString(Permission permission) {
        switch (permission) {
            case LICENSED_USER: {
                return "Bitbucket User";
            }
            case SYS_ADMIN: {
                return "System Admin";
            }
            case PROJECT_CREATE: {
                return "Project Creator";
            }
            case REPO_CREATE: {
                return "Create repository";
            }
        }
        String[] permissionParts = permission.toString().split("_");
        return WordUtils.capitalizeFully((String)(permissionParts.length == 2 ? permissionParts[1] : permission.toString()));
    }
}

