/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.dmz.user.DetailedUserCallback;
import com.atlassian.bitbucket.dmz.user.DetailedUserSearchRequest;
import com.atlassian.bitbucket.dmz.user.DmzCsvExportService;
import com.atlassian.bitbucket.dmz.user.DmzPermissionAdminService;
import com.atlassian.bitbucket.dmz.user.DmzUserAdminService;
import com.atlassian.bitbucket.dmz.user.ScopedPermissionCallback;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.user.CsvExportingDetailedUserCallback;
import com.atlassian.stash.internal.user.CsvExportingScopedPermissionCallback;
import jakarta.annotation.Nonnull;
import java.io.OutputStream;
import java.time.Clock;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=DmzCsvExportService.class)
@Service(value="csvExportService")
public class DefaultCsvExportService
extends AbstractService
implements DmzCsvExportService {
    private final EventPublisher eventPublisher;
    private final DmzPermissionAdminService permissionAdminService;
    private final DmzUserAdminService userAdminService;
    private final UserService userService;

    @Autowired
    public DefaultCsvExportService(EventPublisher eventPublisher, DmzPermissionAdminService permissionAdminService, DmzUserAdminService userAdminService, UserService userService) {
        this.eventPublisher = eventPublisher;
        this.permissionAdminService = permissionAdminService;
        this.userAdminService = userAdminService;
        this.userService = userService;
    }

    public void exportPermissionsToCsv(@Nonnull OutputStream output) {
        Objects.requireNonNull(output, "output");
        this.permissionAdminService.streamGrantedPermissions((ScopedPermissionCallback)new CsvExportingScopedPermissionCallback(Clock.systemDefaultZone(), this.eventPublisher, output, this.userService));
    }

    public void exportUsersToCsv(@Nonnull OutputStream output, @Nonnull DetailedUserSearchRequest request) {
        Objects.requireNonNull(output, "output");
        Objects.requireNonNull(request, "request");
        this.userAdminService.streamUsers((DetailedUserCallback)new CsvExportingDetailedUserCallback(Clock.systemDefaultZone(), request, this.eventPublisher, output), request);
    }
}

