/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.auth.SimpleAuthentication;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.stash.internal.permission.CompositePermissionVoter;
import com.atlassian.stash.internal.permission.EscalatedPermissionVoter;
import com.atlassian.stash.internal.permission.GrantedPermissionVoter;
import com.atlassian.stash.internal.permission.PermissionVoterFactory;
import com.atlassian.stash.internal.permission.ServiceAccountPermissionVoter;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

class DefaultEscalatedSecurityContext
implements EscalatedSecurityContext {
    private static final Logger log = LoggerFactory.getLogger(DefaultEscalatedSecurityContext.class);
    private final GrantedPermissionVoter escalatedVoter;
    private final boolean impersonateUser;
    private final String reason;
    private final RequestManager requestManager;
    private final ApplicationUser user;
    private final PermissionVoterFactory voterFactory;

    private DefaultEscalatedSecurityContext(Builder builder) {
        this.escalatedVoter = builder.permissionsBuilder.build();
        this.impersonateUser = builder.impersonateUser;
        this.reason = builder.reason;
        this.requestManager = builder.requestManager;
        this.user = builder.user;
        this.voterFactory = builder.voterFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T call(@Nonnull Operation<T, E> operation) throws E {
        Objects.requireNonNull(operation, "operation cannot be null");
        org.springframework.security.core.Authentication authToken = SecurityContextHolder.getContext().getAuthentication();
        StashUserAuthenticationToken runAsToken = this.createRunAsToken();
        SecurityContextHolder.getContext().setAuthentication((org.springframework.security.core.Authentication)runAsToken);
        try {
            log.trace("doWithPermission: running as {}, reason: {}", (Object)runAsToken, (Object)this.reason);
            Object object = operation.perform();
            return (T)object;
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(authToken);
        }
    }

    public void applyToRequest() {
        RequestContext requestContext = this.requestManager.getRequestContext();
        if (requestContext == null || !requestContext.isActive()) {
            throw new IllegalStateException("No request is active");
        }
        SecurityContextHolder.getContext().setAuthentication((org.springframework.security.core.Authentication)this.createRunAsToken());
    }

    @Nonnull
    public EscalatedSecurityContext withPermission(@Nonnull Permission permission) {
        return new Builder(this).withPermission(Objects.requireNonNull(permission, "permission")).build();
    }

    @Nonnull
    public EscalatedSecurityContext withPermission(@Nonnull Object resource, @Nonnull Permission permission) {
        return new Builder(this).withPermission(resource, permission).build();
    }

    @Nonnull
    public EscalatedSecurityContext withPermissions(@Nonnull Set<Permission> permissions) {
        GrantedPermissionVoter.Builder builder = new GrantedPermissionVoter.Builder().addAll(this.escalatedVoter);
        int index = 0;
        for (Permission permission : permissions) {
            builder.add((Permission)Preconditions.checkNotNull((Object)permission, (String)"permissions[%s]", (int)index++), null);
        }
        return new Builder(this).withPermissions(permissions).build();
    }

    private StashUserAuthenticationToken createRunAsToken() {
        PermissionVoter tokenVoter;
        ApplicationUser tokenUser;
        org.springframework.security.core.Authentication currentToken = SecurityContextHolder.getContext().getAuthentication();
        PermissionVoter activeVoter = null;
        ApplicationUser activeUser = null;
        HashMap authProperties = new HashMap();
        if (currentToken instanceof StashUserAuthenticationToken) {
            StashUserAuthenticationToken stashToken = (StashUserAuthenticationToken)currentToken;
            activeUser = stashToken.getPrincipal();
            activeVoter = stashToken.getVoter();
            authProperties.putAll(stashToken.getProperties());
        }
        if (this.impersonateUser) {
            tokenUser = this.user;
            Authentication bitbucketAuthentication = new SimpleAuthentication.Builder(this.user).properties(authProperties).build();
            CompositePermissionVoter.Builder nextEscalationVoterBuilder = new CompositePermissionVoter.Builder();
            nextEscalationVoterBuilder.add(this.escalatedVoter, new PermissionVoter[0]);
            if (authProperties.containsKey("bbs.auth.service-account.id")) {
                nextEscalationVoterBuilder.add(new ServiceAccountPermissionVoter(bitbucketAuthentication), new PermissionVoter[0]);
            }
            PermissionVoter userVoter = this.voterFactory.create(bitbucketAuthentication);
            tokenVoter = EscalatedPermissionVoter.maybeEscalate(activeVoter, nextEscalationVoterBuilder.build(), userVoter);
        } else {
            tokenUser = activeUser;
            tokenVoter = EscalatedPermissionVoter.maybeEscalate(activeVoter, this.escalatedVoter, activeVoter);
        }
        return new StashUserAuthenticationToken.Builder().user(tokenUser).voter(tokenVoter).build();
    }

    static class Builder {
        private final RequestManager requestManager;
        private final String reason;
        private final PermissionVoterFactory voterFactory;
        private final GrantedPermissionVoter.Builder permissionsBuilder;
        private boolean impersonateUser;
        private ApplicationUser user;

        Builder(@Nonnull String reason, @Nonnull RequestManager requestManager, @Nonnull PermissionVoterFactory voterFactory) {
            this.requestManager = Objects.requireNonNull(requestManager, "requestManager");
            this.reason = Objects.requireNonNull(reason, "reason");
            this.voterFactory = Objects.requireNonNull(voterFactory, "voterFactory");
            this.permissionsBuilder = new GrantedPermissionVoter.Builder();
        }

        Builder(@Nonnull DefaultEscalatedSecurityContext escalatedSecurityContext) {
            Objects.requireNonNull(escalatedSecurityContext, "escalatedSecurityContext");
            this.impersonateUser = escalatedSecurityContext.impersonateUser;
            this.permissionsBuilder = new GrantedPermissionVoter.Builder().addAll(escalatedSecurityContext.escalatedVoter);
            this.reason = escalatedSecurityContext.reason;
            this.requestManager = escalatedSecurityContext.requestManager;
            this.user = escalatedSecurityContext.user;
            this.voterFactory = escalatedSecurityContext.voterFactory;
        }

        @Nonnull
        Builder anonymously() {
            this.impersonateUser = true;
            this.user = null;
            return this;
        }

        @Nonnull
        DefaultEscalatedSecurityContext build() {
            return new DefaultEscalatedSecurityContext(this);
        }

        @Nonnull
        Builder impersonating(@Nonnull ApplicationUser user) {
            this.impersonateUser = true;
            this.user = Objects.requireNonNull(user, "user");
            return this;
        }

        @Nonnull
        Builder withPermission(@Nonnull Permission permission) {
            this.permissionsBuilder.add(Objects.requireNonNull(permission, "permission"), null);
            return this;
        }

        @Nonnull
        Builder withPermission(@Nonnull Object resource, @Nonnull Permission permission) {
            Integer resourceId;
            if (Objects.requireNonNull(resource, "resource") instanceof Repository) {
                resourceId = ((Repository)resource).getId();
                Preconditions.checkArgument((boolean)permission.isResource(Repository.class), (Object)"Repository permission required");
            } else if (resource instanceof Project) {
                resourceId = ((Project)resource).getId();
                Preconditions.checkArgument((boolean)permission.isResource(Project.class), (Object)"Project permission required");
            } else if (resource instanceof ApplicationUser) {
                resourceId = ((ApplicationUser)resource).getId();
                Preconditions.checkArgument((boolean)permission.isResource(ApplicationUser.class), (Object)"ApplicationUser permission required");
            } else {
                throw new IllegalArgumentException("Only repository and project resources are supported. Got " + resource.getClass().getCanonicalName());
            }
            this.permissionsBuilder.add(permission, resourceId);
            return this;
        }

        @Nonnull
        Builder withPermissions(@Nonnull Iterable<Permission> permissions) {
            int index = 0;
            for (Permission permission : Objects.requireNonNull(permissions, "permissions")) {
                this.permissionsBuilder.add((Permission)Preconditions.checkNotNull((Object)permission, (String)"permissions[%s]", (int)index++), null);
            }
            return this;
        }
    }
}

