/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.user.ApplicationUserDao;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalAuthenticationContext;
import com.atlassian.stash.internal.user.InternalLocaleManager;
import com.atlassian.stash.internal.user.InternalNormalUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="localeManager")
public class DefaultLocaleManager
implements InternalLocaleManager {
    private final InternalAuthenticationContext authenticationContext;
    private final PermissionService permissionService;
    private final ApplicationUserDao userDao;

    @Autowired
    public DefaultLocaleManager(ApplicationUserDao userDao, InternalAuthenticationContext authenticationContext, PermissionService permissionService) {
        this.authenticationContext = authenticationContext;
        this.permissionService = permissionService;
        this.userDao = userDao;
    }

    @Transactional
    public void setLocale(@Nonnull ApplicationUser user, @Nullable Locale locale) throws ServerException {
        InternalNormalUser.fromUser((ApplicationUser)user).ifPresent(normalUser -> {
            InternalApplicationUser updatedUser = (InternalApplicationUser)this.userDao.update((Object)new InternalNormalUser.Builder(normalUser).locale(locale).build());
            if (this.permissionService.hasUserPermission(user, Permission.USER_ADMIN)) {
                this.authenticationContext.refreshUser((ApplicationUser)updatedUser);
            }
        });
    }

    @Nullable
    public Locale getLocale(@Nullable ApplicationUser user) {
        return InternalNormalUser.fromUser((ApplicationUser)user).map(InternalNormalUser::getLocale).orElse(null);
    }
}

