/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.ForbiddenException;
import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.RequestCanceledException;
import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.dmz.user.DmzPermissionAdminService;
import com.atlassian.bitbucket.dmz.user.PermittedGroupGlobalSearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedGroupProjectSearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedGroupRepositorySearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedGroupSearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedPrincipal;
import com.atlassian.bitbucket.dmz.user.PermittedPrincipalProjectSearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedPrincipalRepositorySearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedPrincipalSearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedUserGlobalSearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedUserProjectSearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedUserRepositorySearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedUserSearchRequest;
import com.atlassian.bitbucket.dmz.user.ProjectPermission;
import com.atlassian.bitbucket.dmz.user.ProjectPermissionRequest;
import com.atlassian.bitbucket.dmz.user.ProjectPermissionSearchRequest;
import com.atlassian.bitbucket.dmz.user.RepositoryPermission;
import com.atlassian.bitbucket.dmz.user.RepositoryPermissionRequest;
import com.atlassian.bitbucket.dmz.user.RepositoryPermissionSearchRequest;
import com.atlassian.bitbucket.dmz.user.ScopedPermission;
import com.atlassian.bitbucket.dmz.user.ScopedPermissionCallback;
import com.atlassian.bitbucket.event.permission.GlobalPermissionGrantRequestedEvent;
import com.atlassian.bitbucket.event.permission.GlobalPermissionGrantedEvent;
import com.atlassian.bitbucket.event.permission.GlobalPermissionModificationRequestedEvent;
import com.atlassian.bitbucket.event.permission.GlobalPermissionModifiedEvent;
import com.atlassian.bitbucket.event.permission.GlobalPermissionRevocationRequestedEvent;
import com.atlassian.bitbucket.event.permission.GlobalPermissionRevokedEvent;
import com.atlassian.bitbucket.event.permission.PermissionEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionGrantRequestedEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionGrantedEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionModificationRequestedEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionModifiedEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionRevocationRequestedEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionRevokedEvent;
import com.atlassian.bitbucket.event.permission.RepositoryPermissionEvent;
import com.atlassian.bitbucket.event.permission.RepositoryPermissionGrantRequestedEvent;
import com.atlassian.bitbucket.event.permission.RepositoryPermissionGrantedEvent;
import com.atlassian.bitbucket.event.permission.RepositoryPermissionModificationRequestedEvent;
import com.atlassian.bitbucket.event.permission.RepositoryPermissionModifiedEvent;
import com.atlassian.bitbucket.event.permission.RepositoryPermissionRevocationRequestedEvent;
import com.atlassian.bitbucket.event.permission.RepositoryPermissionRevokedEvent;
import com.atlassian.bitbucket.event.user.GroupCleanupEvent;
import com.atlassian.bitbucket.event.user.UserCleanupEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionAdminService;
import com.atlassian.bitbucket.permission.PermissionGrantCanceledException;
import com.atlassian.bitbucket.permission.PermissionModificationCanceledException;
import com.atlassian.bitbucket.permission.PermissionRevocationCanceledException;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.permission.PermittedGroup;
import com.atlassian.bitbucket.permission.PermittedUser;
import com.atlassian.bitbucket.permission.SetPermissionRequest;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.CancelState;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.bitbucket.util.SimpleCancelState;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.CommonValidations;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.user.EffectivePermissionDao;
import com.atlassian.stash.internal.user.GlobalPermissionDao;
import com.atlassian.stash.internal.user.GroupPageFilter;
import com.atlassian.stash.internal.user.InIteratorPredicate;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalGlobalPermission;
import com.atlassian.stash.internal.user.InternalProjectPermission;
import com.atlassian.stash.internal.user.InternalRepositoryPermission;
import com.atlassian.stash.internal.user.InternalScopedPermission;
import com.atlassian.stash.internal.user.InternalUserService;
import com.atlassian.stash.internal.user.ProjectPermissionDao;
import com.atlassian.stash.internal.user.RepositoryPermissionDao;
import com.atlassian.stash.internal.user.UserPageFilter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(interfaces={PermissionAdminService.class, DmzPermissionAdminService.class})
@Service(value="permissionAdminService")
@Transactional(readOnly=true)
public class DefaultPermissionAdminService
implements DmzPermissionAdminService {
    public static final int INTERNAL_PAGE_LIMIT = 500;
    private static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = IdentifierUtils::compareToInLowerCase;
    private static final Comparator<ApplicationUser> CASE_INSENSITIVE_NAME_COMPARATOR = (u1, u2) -> IdentifierUtils.compareToInLowerCase((String)u1.getName(), (String)u2.getName());
    private final EventPublisher eventPublisher;
    private final GlobalPermissionDao globalPermissionDao;
    private final EffectivePermissionDao effectivePermissionDao;
    private final ProjectPermissionDao projectPermissionDao;
    private final RepositoryPermissionDao repositoryPermissionDao;
    private final I18nService i18nService;
    private final LicenseService licenseService;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final AuthenticationContext authenticationContext;
    private final InternalUserService userService;
    private final ProjectSettingsRestrictionService projectSettingsRestrictionService;
    @Value(value="${page.max.groups}")
    private int maxGroups;
    @Value(value="${page.max.users}")
    private int maxUsers;

    @Autowired
    public DefaultPermissionAdminService(InternalUserService userService, GlobalPermissionDao globalPermissionDao, EffectivePermissionDao effectivePermissionDao, ProjectPermissionDao projectPermissionDao, RepositoryPermissionDao repositoryPermissionDao, AuthenticationContext authenticationContext, PermissionService permissionService, PermissionValidationService permissionValidationService, ProjectSettingsRestrictionService projectSettingsRestrictionService, I18nService i18nService, LicenseService licenseService, EventPublisher eventPublisher) {
        this.userService = userService;
        this.globalPermissionDao = globalPermissionDao;
        this.effectivePermissionDao = effectivePermissionDao;
        this.projectPermissionDao = projectPermissionDao;
        this.repositoryPermissionDao = repositoryPermissionDao;
        this.authenticationContext = authenticationContext;
        this.permissionService = permissionService;
        this.permissionValidationService = permissionValidationService;
        this.i18nService = i18nService;
        this.licenseService = licenseService;
        this.eventPublisher = eventPublisher;
        this.projectSettingsRestrictionService = projectSettingsRestrictionService;
    }

    public long countGlobalPermissionsForAllGroups() {
        return this.globalPermissionDao.countPermissionsForAllGroups();
    }

    public long countGlobalPermissionsForAllUsers() {
        return this.globalPermissionDao.countPermissionsForAllUsers();
    }

    public long countProjectPermissionsForAllGroups() {
        return this.projectPermissionDao.countPermissionsForAllGroups();
    }

    public long countProjectPermissionsForAllUsers() {
        return this.projectPermissionDao.countPermissionsForAllUsers();
    }

    public long countRepositoryPermissionsForAllGroups() {
        return this.repositoryPermissionDao.countPermissionsForAllGroups();
    }

    public long countRepositoryPermissionsForAllUsers() {
        return this.repositoryPermissionDao.countPermissionsForAllUsers();
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void streamGrantedPermissions(@Nonnull ScopedPermissionCallback callback) {
        Objects.requireNonNull(callback, "callback");
        boolean callEnd = false;
        try (Stream permissions = this.effectivePermissionDao.streamGrantedPermissions();){
            callback.onStart();
            callEnd = true;
            for (ScopedPermission p : MoreStreams.asIterable((Stream)permissions)) {
                p.getGroup().ifPresent(ignored -> callback.onGroupPermission(p));
                p.getUser().ifPresent(ignored -> callback.onUserPermission(p));
            }
            callEnd = false;
            callback.onEnd();
        }
        catch (RuntimeException e) {
            if (callEnd) {
                try {
                    callback.onEnd();
                }
                catch (RuntimeException suppressed) {
                    e.addSuppressed(suppressed);
                }
            }
            throw e;
        }
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Map<Permission, Long> countByPermissionForAllGroups() {
        return this.projectPermissionDao.countByPermissionForAllGroups();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Map<Permission, Long> countByPermissionForAllUsers() {
        return this.projectPermissionDao.countByPermissionForAllUsers();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<ProjectPermission> searchProjects(@Nonnull ProjectPermissionSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        return this.projectPermissionDao.findHighestPermissionsForUser(request.getUser().getId(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<RepositoryPermission> searchRepositories(@Nonnull RepositoryPermissionSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        return this.repositoryPermissionDao.findHighestPermissionsForUser(request.getUser().getId(), pageRequest);
    }

    @Nonnull
    @Secured(value="Secured internally using the PermissionValidationService")
    public Page<PermittedUser> searchUsers(@Nonnull PermittedUserSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        final PageRequest restrictedPageRequest = pageRequest.buildRestrictedPageRequest(this.maxUsers);
        return (Page)request.accept((PermittedUserSearchRequest.Visitor)new PermittedUserSearchRequest.Visitor<Page<PermittedUser>>(){

            public Page<PermittedUser> visit(@Nonnull PermittedUserGlobalSearchRequest request) {
                DefaultPermissionAdminService.this.permissionValidationService.validateForGlobal(Permission.ADMIN);
                return DefaultPermissionAdminService.this.globalPermissionDao.findHighestPermissionPerUser(request.getUserType(), request.getNameFilter(), restrictedPageRequest);
            }

            public Page<PermittedUser> visit(@Nonnull PermittedUserProjectSearchRequest request) {
                DefaultPermissionAdminService.this.permissionValidationService.validateForProject(request.getProject(), Permission.PROJECT_ADMIN);
                return DefaultPermissionAdminService.this.projectPermissionDao.findHighestPermissionPerUser(request.getProject().getId(), request.getUserType(), request.getNameFilter(), restrictedPageRequest);
            }

            public Page<PermittedUser> visit(@Nonnull PermittedUserRepositorySearchRequest request) {
                DefaultPermissionAdminService.this.permissionValidationService.validateForRepository(request.getRepository(), Permission.REPO_ADMIN);
                return DefaultPermissionAdminService.this.repositoryPermissionDao.findHighestPermissionPerUser(request.getRepository().getId(), request.getUserType(), request.getNameFilter(), restrictedPageRequest);
            }
        });
    }

    @Nonnull
    @Secured(value="Secured internally using the PermissionValidationService")
    public Page<PermittedGroup> searchGroups(@Nonnull PermittedGroupSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        final PageRequest restrictedPageRequest = pageRequest.buildRestrictedPageRequest(this.maxGroups);
        return (Page)request.accept((PermittedGroupSearchRequest.Visitor)new PermittedGroupSearchRequest.Visitor<Page<PermittedGroup>>(){

            public Page<PermittedGroup> visit(@Nonnull PermittedGroupGlobalSearchRequest request) {
                DefaultPermissionAdminService.this.permissionValidationService.validateForGlobal(Permission.ADMIN);
                return DefaultPermissionAdminService.this.globalPermissionDao.findHighestPermissionPerGroup(request.getNameFilter(), restrictedPageRequest);
            }

            public Page<PermittedGroup> visit(@Nonnull PermittedGroupProjectSearchRequest request) {
                DefaultPermissionAdminService.this.permissionValidationService.validateForProject(request.getProject(), Permission.PROJECT_ADMIN);
                return DefaultPermissionAdminService.this.projectPermissionDao.findHighestPermissionPerGroup(request.getProject().getId(), request.getNameFilter(), restrictedPageRequest);
            }

            public Page<PermittedGroup> visit(@Nonnull PermittedGroupRepositorySearchRequest request) {
                DefaultPermissionAdminService.this.permissionValidationService.validateForRepository(request.getRepository(), Permission.REPO_ADMIN);
                return DefaultPermissionAdminService.this.repositoryPermissionDao.findHighestPermissionPerGroup(request.getRepository().getId(), request.getNameFilter(), restrictedPageRequest);
            }
        });
    }

    @Nonnull
    @Secured(value="Secured internally using the PermissionValidationService")
    public Page<ApplicationUser> searchUsersLacking(@Nonnull PermittedUserSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        PageProvider provider = (PageProvider)request.accept((PermittedUserSearchRequest.Visitor)new PermittedUserSearchRequest.Visitor<PageProvider<ApplicationUser>>(){

            public PageProvider<ApplicationUser> visit(@Nonnull PermittedUserGlobalSearchRequest request) {
                DefaultPermissionAdminService.this.permissionValidationService.validateForGlobal(Permission.ADMIN);
                return innerPageRequest -> DefaultPermissionAdminService.this.globalPermissionDao.findUsersWithPermission(request.getUserType(), innerPageRequest);
            }

            public PageProvider<ApplicationUser> visit(@Nonnull PermittedUserProjectSearchRequest request) {
                DefaultPermissionAdminService.this.permissionValidationService.validateForProject(request.getProject(), Permission.PROJECT_ADMIN);
                return innerPageRequest -> DefaultPermissionAdminService.this.projectPermissionDao.findUsersWithPermission(request.getProject().getId(), request.getUserType(), innerPageRequest);
            }

            public PageProvider<ApplicationUser> visit(@Nonnull PermittedUserRepositorySearchRequest request) {
                DefaultPermissionAdminService.this.permissionValidationService.validateForRepository(request.getRepository(), Permission.REPO_ADMIN);
                return innerPageRequest -> DefaultPermissionAdminService.this.repositoryPermissionDao.findUsersWithPermission(request.getRepository().getId(), request.getUserType(), innerPageRequest);
            }
        });
        return this.getUsersWithoutPermission(DefaultPermissionAdminService.withoutUsers((PageProvider<ApplicationUser>)provider), request.getUserType(), request.getNameFilter(), pageRequest);
    }

    @Nonnull
    @Secured(value="Secured internally using the PermissionValidationService")
    public Page<String> searchGroupsLacking(@Nonnull PermittedGroupSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        PageProvider provider = (PageProvider)request.accept((PermittedGroupSearchRequest.Visitor)new PermittedGroupSearchRequest.Visitor<PageProvider<String>>(){

            public PageProvider<String> visit(@Nonnull PermittedGroupGlobalSearchRequest request) {
                DefaultPermissionAdminService.this.permissionValidationService.validateForGlobal(Permission.ADMIN);
                return arg_0 -> ((GlobalPermissionDao)DefaultPermissionAdminService.this.globalPermissionDao).findGroupsWithPermission(arg_0);
            }

            public PageProvider<String> visit(@Nonnull PermittedGroupProjectSearchRequest request) {
                DefaultPermissionAdminService.this.permissionValidationService.validateForProject(request.getProject(), Permission.PROJECT_ADMIN);
                return innerPageRequest -> DefaultPermissionAdminService.this.projectPermissionDao.findGroupsWithPermission(request.getProject().getId(), innerPageRequest);
            }

            public PageProvider<String> visit(@Nonnull PermittedGroupRepositorySearchRequest request) {
                DefaultPermissionAdminService.this.permissionValidationService.validateForRepository(request.getRepository(), Permission.REPO_ADMIN);
                return innerPageRequest -> DefaultPermissionAdminService.this.repositoryPermissionDao.findGroupsWithPermission(request.getRepository().getId(), innerPageRequest);
            }
        });
        return this.getGroupsWithoutPermission(request.getNameFilter(), DefaultPermissionAdminService.withoutGroups((PageProvider<String>)provider), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<PermittedUser> findUsersWithGlobalPermission(String filter, @Nonnull PageRequest pageRequest) {
        return this.searchUsers((PermittedUserSearchRequest)((PermittedUserSearchRequest.Builder)new PermittedUserSearchRequest.Builder().nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<ApplicationUser> findUsersWithoutGlobalPermission(String filter, @Nonnull PageRequest pageRequest) {
        return this.searchUsersLacking((PermittedUserSearchRequest)((PermittedUserSearchRequest.Builder)new PermittedUserSearchRequest.Builder().nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<PermittedGroup> findGroupsWithGlobalPermission(String filter, @Nonnull PageRequest pageRequest) {
        return this.searchGroups((PermittedGroupSearchRequest)((PermittedGroupSearchRequest.Builder)new PermittedGroupSearchRequest.Builder().nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<String> findGroupsWithoutGlobalPermission(String filter, @Nonnull PageRequest pageRequest) {
        return this.searchGroupsLacking((PermittedGroupSearchRequest)((PermittedGroupSearchRequest.Builder)new PermittedGroupSearchRequest.Builder().nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public Page<PermittedUser> findUsersWithProjectPermission(@Nonnull Project project, String filter, @Nonnull PageRequest pageRequest) {
        return this.searchUsers((PermittedUserSearchRequest)((PermittedUserSearchRequest.ProjectBuilder)new PermittedUserSearchRequest.Builder().project(project).nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @Unsecured(value="Secured internally in searchUsersLacking()")
    public Page<ApplicationUser> findLicensedUsersWithoutProjectPermission(@Nonnull Project project, String filter, @Nonnull PageRequest pageRequest) {
        PageProvider userProvider = request -> this.searchUsersLacking((PermittedUserSearchRequest)((PermittedUserSearchRequest.ProjectBuilder)new PermittedUserSearchRequest.Builder().project(project).nameFilter(filter)).build(), request);
        return PageUtils.filterPages((PageProvider)userProvider, this.licensedOnly(), (PageRequest)pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public Page<PermittedGroup> findGroupsWithProjectPermission(@Nonnull Project project, String filter, @Nonnull PageRequest pageRequest) {
        return this.searchGroups((PermittedGroupSearchRequest)((PermittedGroupSearchRequest.ProjectBuilder)new PermittedGroupSearchRequest.Builder().project(project).nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public Page<String> findGroupsWithoutProjectPermission(@Nonnull Project project, String filter, @Nonnull PageRequest pageRequest) {
        return this.searchGroupsLacking((PermittedGroupSearchRequest)((PermittedGroupSearchRequest.ProjectBuilder)new PermittedGroupSearchRequest.Builder().project(project).nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Page<PermittedUser> findUsersWithRepositoryPermission(@Nonnull Repository repository, String filter, @Nonnull PageRequest pageRequest) {
        return this.searchUsers((PermittedUserSearchRequest)((PermittedUserSearchRequest.RepositoryBuilder)new PermittedUserSearchRequest.Builder().repository(repository).nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @Unsecured(value="Secured internally in searchUsersLacking()")
    public Page<ApplicationUser> findLicensedUsersWithoutRepositoryPermission(@Nonnull Repository repository, String filter, @Nonnull PageRequest pageRequest) {
        PageProvider userProvider = request -> this.searchUsersLacking((PermittedUserSearchRequest)((PermittedUserSearchRequest.RepositoryBuilder)new PermittedUserSearchRequest.Builder().repository(repository).nameFilter(filter)).build(), request);
        return PageUtils.filterPages((PageProvider)userProvider, this.licensedOnly(), (PageRequest)pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Page<PermittedGroup> findGroupsWithRepositoryPermission(@Nonnull Repository repository, String filter, @Nonnull PageRequest pageRequest) {
        return this.searchGroups((PermittedGroupSearchRequest)((PermittedGroupSearchRequest.RepositoryBuilder)new PermittedGroupSearchRequest.Builder().repository(repository).nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Page<String> findGroupsWithoutRepositoryPermission(@Nonnull Repository repository, String filter, @Nonnull PageRequest pageRequest) {
        return this.searchGroupsLacking((PermittedGroupSearchRequest)((PermittedGroupSearchRequest.RepositoryBuilder)new PermittedGroupSearchRequest.Builder().repository(repository).nameFilter(filter)).build(), pageRequest);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void revokeAllGlobalPermissions(@Nonnull String group) {
        CommonValidations.validateGroup(group);
        Permission revoked = this.doRevokeAllGlobalPermissions(group);
        if (revoked != null) {
            this.fireGlobalPermissionRequestedEvent(revoked, null, group, null);
            this.fireGlobalPermissionEvent(revoked, null, group, null);
        }
    }

    private Permission doRevokeAllGlobalPermissions(String group) {
        if (this.permissionService.hasGlobalGroupPermission(Permission.SYS_ADMIN, group) && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.revoke.insufficient.permission", new Object[]{group}));
        }
        Permission revoked = null;
        for (Permission permission : Permission.getGlobalPermissions()) {
            InternalGlobalPermission perm = this.buildPermission(permission, group, null);
            if (!this.globalPermissionDao.hasPermissionEntry((InternalScopedPermission)perm) || !this.revokeGlobalPermission(permission, group)) continue;
            revoked = Permission.max(revoked, (Permission)permission);
        }
        return revoked;
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void revokeAllGlobalPermissions(@Nonnull ApplicationUser user) {
        Objects.requireNonNull(user, "user");
        Permission revoked = this.doRevokeAllGlobalPermissions(user);
        if (revoked != null) {
            this.fireGlobalPermissionRequestedEvent(revoked, null, null, user);
            this.fireGlobalPermissionEvent(revoked, null, null, user);
        }
    }

    private Permission doRevokeAllGlobalPermissions(ApplicationUser user) {
        if (!this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN) && this.permissionService.hasGlobalPermission(user, Permission.SYS_ADMIN)) {
            throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.revoke.insufficient.permission", new Object[]{user.getDisplayName()}));
        }
        Permission revoked = null;
        for (Permission permission : Permission.getGlobalPermissions()) {
            InternalGlobalPermission perm = this.buildPermission(permission, null, user);
            if (!this.globalPermissionDao.hasPermissionEntry((InternalScopedPermission)perm) || !this.revokeGlobalPermission(permission, user)) continue;
            revoked = Permission.max(revoked, (Permission)permission);
        }
        return revoked;
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void revokeAllProjectPermissions(@Nonnull Project project, @Nonnull String group) {
        Objects.requireNonNull(project, "project");
        CommonValidations.validateGroup(group);
        Permission revoked = this.doRevokeAllProjectPermissions(project, group);
        if (revoked != null) {
            this.fireProjectPermissionRequestedEvent(project, revoked, null, group, null);
            this.fireProjectPermissionEvent(project, revoked, null, group, null);
        }
    }

    private Permission doRevokeAllProjectPermissions(Project project, String group) {
        Permission revoked = null;
        for (Permission permission : Permission.getPermissionsOn(Project.class)) {
            if (!this.revokeProjectPermission(permission, project, group)) continue;
            revoked = Permission.max(revoked, (Permission)permission);
        }
        return revoked;
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void revokeAllProjectPermissions(@Nonnull Project project, @Nonnull ApplicationUser user) {
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(user, "user");
        Permission revoked = this.doRevokeAllProjectPermissions(project, user);
        if (revoked != null) {
            this.fireProjectPermissionRequestedEvent(project, revoked, null, null, user);
            this.fireProjectPermissionEvent(project, revoked, null, null, user);
        }
    }

    private Permission doRevokeAllProjectPermissions(Project project, ApplicationUser user) {
        Permission revoked = null;
        for (Permission permission : Permission.getPermissionsOn(Project.class)) {
            if (!this.revokeProjectPermission(permission, project, user)) continue;
            revoked = Permission.max(revoked, (Permission)permission);
        }
        return revoked;
    }

    @Transactional
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public void revokeAllRepositoryPermissions(@Nonnull Repository repository, @Nonnull String group) {
        Objects.requireNonNull(repository, "repository");
        CommonValidations.validateGroup(group);
        Permission revoked = this.doRevokeAllRepositoryPermissions(repository, group);
        if (revoked != null) {
            this.fireRepositoryPermissionRequestedEvent(repository, revoked, null, group, null);
            this.fireRepositoryPermissionEvent(repository, revoked, null, group, null);
        }
    }

    private Permission doRevokeAllRepositoryPermissions(Repository repository, String group) {
        Permission revoked = null;
        for (Permission permission : Permission.getPermissionsOn(Repository.class)) {
            if (!this.revokeRepositoryPermission(permission, repository, group)) continue;
            revoked = Permission.max(revoked, (Permission)permission);
        }
        return revoked;
    }

    @Transactional
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public void revokeAllRepositoryPermissions(@Nonnull Repository repository, @Nonnull ApplicationUser user) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(user, "user");
        Permission revoked = this.doRevokeAllRepositoryPermissions(repository, user);
        if (revoked != null) {
            this.fireRepositoryPermissionRequestedEvent(repository, revoked, null, null, user);
            this.fireRepositoryPermissionEvent(repository, revoked, null, null, user);
        }
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void revokeAllProjectPermissions(@Nonnull Project project, @Nonnull Set<String> groups, @Nonnull Set<ApplicationUser> users) {
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(groups, "groups");
        Objects.requireNonNull(users, "users");
        groups.forEach(group -> this.revokeAllProjectPermissions(project, (String)group));
        users.forEach(user -> this.revokeAllProjectPermissions(project, (ApplicationUser)user));
    }

    @Transactional
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public void revokeAllRepositoryPermissions(@Nonnull Repository repository, @Nonnull Set<String> groups, @Nonnull Set<ApplicationUser> users) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(groups, "groups");
        Objects.requireNonNull(users, "users");
        groups.forEach(group -> this.revokeAllRepositoryPermissions(repository, (String)group));
        users.forEach(user -> this.revokeAllRepositoryPermissions(repository, (ApplicationUser)user));
    }

    private Permission doRevokeAllRepositoryPermissions(Repository repository, ApplicationUser user) {
        Permission revoked = null;
        for (Permission permission : Permission.getPermissionsOn(Repository.class)) {
            if (!this.revokeRepositoryPermission(permission, repository, user)) continue;
            revoked = Permission.max(revoked, (Permission)permission);
        }
        return revoked;
    }

    @Transactional
    @Secured(value="Permissions checks done internally")
    public void setPermission(@Nonnull SetPermissionRequest request) {
        boolean hasInsufficientPermission;
        Permission permission = request.getPermission();
        Project project = request.getProject();
        Repository repository = request.getRepository();
        boolean hasInsufficientGlobalPermission = permission.isGlobal() && !this.permissionService.hasGlobalPermission(Permission.max((Permission)permission, (Permission)Permission.ADMIN));
        boolean hasInsufficientProjectPermission = permission.isResource(Project.class) && !this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN);
        boolean hasInsufficientRepositoryPermission = permission.isResource(Repository.class) && !this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN);
        boolean bl = hasInsufficientPermission = hasInsufficientGlobalPermission || hasInsufficientProjectPermission || hasInsufficientRepositoryPermission;
        if (hasInsufficientPermission) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.usercannotgrantpermission", new Object[]{permission}));
        }
        if (permission.isResource(Repository.class)) {
            this.validateIsNotRestricted(request.getUsers(), request.getGroups(), repository, "bitbucket.service.settingsrestriction.permissionadmin.restrictionexists.set", repository.getName(), repository.getProject().getName());
        }
        this.doSetPermission(request);
    }

    private void doSetPermission(@Nonnull SetPermissionRequest request) {
        Permission permission = request.getPermission();
        Project project = request.getProject();
        Repository repository = request.getRepository();
        Set users = request.getUsers();
        Set groups = request.getGroups();
        CommonValidations.validateGrantablePermission(permission);
        if (permission.isGlobal()) {
            users.forEach(user -> this.grantGlobalPermission(permission, (ApplicationUser)user));
            groups.forEach(group -> this.grantGlobalPermission(permission, (String)group));
        } else if (permission.isResource(Project.class)) {
            Permission revoked;
            for (ApplicationUser user2 : users) {
                revoked = this.doRevokeAllProjectPermissions(project, user2);
                this.fireProjectPermissionRequestedEvent(project, revoked, permission, null, user2);
                this.grantPermission(((InternalProjectPermission.Builder)((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).user(InternalConverter.convertToInternalUser((ApplicationUser)user2))).build());
                this.fireProjectPermissionEvent(project, revoked, permission, null, user2);
            }
            for (String group2 : groups) {
                revoked = this.doRevokeAllProjectPermissions(project, group2);
                this.fireProjectPermissionRequestedEvent(project, revoked, permission, group2, null);
                this.grantPermission(((InternalProjectPermission.Builder)((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).group(group2)).build());
                this.fireProjectPermissionEvent(project, revoked, permission, group2, null);
            }
        } else if (permission.isResource(Repository.class)) {
            Permission revoked;
            for (ApplicationUser user3 : users) {
                revoked = this.doRevokeAllRepositoryPermissions(repository, user3);
                this.fireRepositoryPermissionRequestedEvent(repository, revoked, permission, null, user3);
                this.grantPermission(((InternalRepositoryPermission.Builder)((InternalRepositoryPermission.Builder)new InternalRepositoryPermission.Builder().permission(permission)).repository(InternalConverter.convertToInternalRepository((Repository)repository)).user(InternalConverter.convertToInternalUser((ApplicationUser)user3))).build());
                this.fireRepositoryPermissionEvent(repository, revoked, permission, null, user3);
            }
            for (String group3 : groups) {
                revoked = this.doRevokeAllRepositoryPermissions(repository, group3);
                this.fireRepositoryPermissionRequestedEvent(repository, revoked, permission, group3, null);
                this.grantPermission(((InternalRepositoryPermission.Builder)((InternalRepositoryPermission.Builder)new InternalRepositoryPermission.Builder().permission(permission)).repository(InternalConverter.convertToInternalRepository((Repository)repository)).group(group3)).build());
                this.fireRepositoryPermissionEvent(repository, revoked, permission, group3, null);
            }
        } else {
            throw new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.cannotgrantunknownpermission", new Object[]{Product.NAME, permission}));
        }
    }

    private PageProvider<ApplicationUser> createUserProvider(UserType userType, String usernamePattern) {
        if (userType == UserType.NORMAL) {
            return pageRequest -> this.userService.findUsersByName(usernamePattern, pageRequest);
        }
        return pageRequest -> PageUtils.asPageOf(ApplicationUser.class, (Page)this.userService.findServiceUsersByName(usernamePattern, pageRequest));
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public boolean hasAllProjectPermission(@Nonnull Permission permission, @Nonnull Project project) {
        CommonValidations.validateProjectPermission(permission);
        CommonValidations.validateGrantablePermission(permission);
        Objects.requireNonNull(project, "project");
        return this.projectPermissionDao.hasPermissionEntry((InternalScopedPermission)((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).build());
    }

    @PreAuthorize(value="hasProjectPermission(#request.project, 'PROJECT_ADMIN')")
    public Permission getProjectPermission(@Nonnull ProjectPermissionRequest request) {
        Objects.requireNonNull(request, "request");
        return this.projectPermissionDao.getHighestPermissionForUser(request.getUser().getId(), request.getProject().getId());
    }

    @PreAuthorize(value="hasRepositoryPermission(#request.repository, 'REPO_ADMIN')")
    public Permission getRepositoryPermission(@Nonnull RepositoryPermissionRequest request) {
        Objects.requireNonNull(request, "request");
        return this.repositoryPermissionDao.getHighestPermissionForUser(request.getUser().getId(), request.getRepository().getId());
    }

    @Nonnull
    @Unsecured(value="Permission checks are applied while searching for principals matching the provided criteria")
    public Page<PermittedPrincipal> searchPrincipals(@Nonnull PermittedPrincipalSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        final PageRequest restrictedPageRequest = pageRequest.buildRestrictedPageRequest(this.maxUsers);
        return (Page)request.accept((PermittedPrincipalSearchRequest.Visitor)new PermittedPrincipalSearchRequest.Visitor<Page<PermittedPrincipal>>(){

            public Page<PermittedPrincipal> visit(@Nonnull PermittedPrincipalProjectSearchRequest request) {
                DefaultPermissionAdminService.this.permissionValidationService.validateForProject(request.getProject(), Permission.PROJECT_ADMIN);
                return DefaultPermissionAdminService.this.projectPermissionDao.findPrincipalsWithAccess(request, restrictedPageRequest);
            }

            public Page<PermittedPrincipal> visit(@Nonnull PermittedPrincipalRepositorySearchRequest request) {
                DefaultPermissionAdminService.this.permissionValidationService.validateForRepository(request.getRepository(), Permission.REPO_ADMIN);
                return DefaultPermissionAdminService.this.repositoryPermissionDao.findPrincipalsWithAccess(request, restrictedPageRequest);
            }
        });
    }

    private void grantGlobalPermission(@Nonnull Permission permission, @Nonnull ApplicationUser user) {
        this.licenseService.validateCanLicenseUser(user, permission);
        Permission revoked = this.doRevokeAllGlobalPermissions(user);
        this.fireGlobalPermissionRequestedEvent(revoked, permission, null, user);
        InternalGlobalPermission perm = this.buildPermission(permission, null, user);
        this.grantPermission(perm);
        this.fireGlobalPermissionEvent(revoked, permission, null, user);
    }

    private void grantGlobalPermission(@Nonnull Permission permission, @Nonnull String group) {
        this.licenseService.validateCanLicenseGroup(group, permission);
        Permission revoked = this.doRevokeAllGlobalPermissions(group);
        this.fireGlobalPermissionRequestedEvent(revoked, permission, group, null);
        InternalGlobalPermission perm = this.buildPermission(permission, group, null);
        this.grantPermission(perm);
        this.fireGlobalPermissionEvent(revoked, permission, group, null);
    }

    private void grantPermission(InternalGlobalPermission perm) {
        if (!this.globalPermissionDao.hasPermissionEntry((InternalScopedPermission)perm)) {
            this.globalPermissionDao.create((Object)perm);
        }
    }

    private boolean grantPermission(InternalProjectPermission perm) {
        if (perm.getProject().getType() == ProjectType.PERSONAL) {
            throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.personalproject.grant", new Object[0]));
        }
        if (!this.projectPermissionDao.hasPermissionEntry((InternalScopedPermission)perm)) {
            this.projectPermissionDao.create((Object)perm);
            return true;
        }
        return false;
    }

    private void grantPermission(InternalRepositoryPermission perm) {
        if (!this.repositoryPermissionDao.hasPermissionEntry((InternalScopedPermission)perm)) {
            this.repositoryPermissionDao.create((Object)perm);
        }
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void grantAllProjectPermission(@Nonnull Permission permission, @Nonnull Project project) {
        CommonValidations.validateProjectPermission(permission);
        CommonValidations.validateGrantablePermission(permission);
        Objects.requireNonNull(project, "project");
        InternalProjectPermission perm = ((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).build();
        Permission previousPermission = this.projectPermissionDao.getHighestDefaultPermission(project.getId());
        boolean granted = this.grantPermission(perm);
        if (granted) {
            boolean effectivePermissionChange;
            boolean bl = effectivePermissionChange = previousPermission == null || previousPermission.getImplyingPermissions().contains(permission);
            if (effectivePermissionChange) {
                this.fireProjectPermissionRequestedEvent(project, previousPermission, permission, null, null);
                this.fireProjectPermissionEvent(project, previousPermission, permission, null, null);
            }
        }
    }

    private boolean revokeRepositoryPermission(@Nonnull Permission permission, @Nonnull Repository repository, @Nonnull ApplicationUser user) {
        boolean revokeAllowed;
        Objects.requireNonNull(repository, "repository");
        CommonValidations.validateRepositoryPermission(permission);
        CommonValidations.validateGrantablePermission(permission);
        this.validateIsNotRestricted(Collections.singleton(user), Collections.emptySet(), repository, "bitbucket.service.settingsrestriction.permissionadmin.restrictionexists.revoke", repository.getName(), repository.getProject().getName());
        boolean bl = revokeAllowed = !user.equals((Object)this.authenticationContext.getCurrentUser());
        if (!revokeAllowed) {
            revokeAllowed = this.currentUserHasImpliedRepositoryPermission(permission, repository);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasRepositoryPermissionThroughGroupMembership(repository, permission, Collections.emptySet());
        }
        if (!revokeAllowed) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.cantrevokeownrepositorypermission", new Object[]{repository.getName()});
            throw new IntegrityException(message);
        }
        return this.revokePermission(((InternalRepositoryPermission.Builder)((InternalRepositoryPermission.Builder)new InternalRepositoryPermission.Builder().permission(permission)).repository(InternalConverter.convertToInternalRepository((Repository)repository)).user(InternalConverter.convertToInternalUser((ApplicationUser)user))).build());
    }

    private boolean revokeRepositoryPermission(@Nonnull Permission permission, @Nonnull Repository repository, @Nonnull String group) {
        boolean revokeAllowed;
        Objects.requireNonNull(repository, "repository");
        CommonValidations.validateRepositoryPermission(permission);
        CommonValidations.validateGrantablePermission(permission);
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        this.validateIsNotRestricted(Collections.emptySet(), Collections.singleton(group), repository, "bitbucket.service.settingsrestriction.permissionadmin.restrictionexists.revoke", repository.getName(), repository.getProject().getName());
        boolean bl = revokeAllowed = currentUser == null || !this.userService.isUserInGroup(currentUser, group);
        if (!revokeAllowed) {
            revokeAllowed = this.currentUserHasImpliedRepositoryPermission(permission, repository);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasDirectRepositoryUserPermission(repository, permission);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasRepositoryPermissionThroughGroupMembership(repository, permission, Collections.singleton(group));
        }
        if (!revokeAllowed) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.cantrevokegrouprepositorypermission", new Object[]{repository.getName(), group});
            throw new IntegrityException(message);
        }
        return this.revokePermission(((InternalRepositoryPermission.Builder)((InternalRepositoryPermission.Builder)new InternalRepositoryPermission.Builder().permission(permission)).repository(InternalConverter.convertToInternalRepository((Repository)repository)).group(group)).build());
    }

    private boolean currentUserHasImpliedRepositoryPermission(Permission permission, Repository repository) {
        return Iterables.any((Iterable)permission.getImplyingPermissions(), higherPermission -> {
            if (higherPermission.isGlobal()) {
                return this.permissionService.hasGlobalPermission(higherPermission);
            }
            if (higherPermission.isResource(Project.class)) {
                return this.permissionService.hasProjectPermission(repository.getProject(), higherPermission);
            }
            if (higherPermission.isResource(Repository.class)) {
                return this.permissionService.hasRepositoryPermission(repository, higherPermission);
            }
            return false;
        });
    }

    private boolean revokeProjectPermission(@Nonnull Permission permission, @Nonnull Project project, @Nonnull ApplicationUser user) {
        boolean revokeAllowed;
        boolean bl = revokeAllowed = !user.equals((Object)this.authenticationContext.getCurrentUser());
        if (!revokeAllowed) {
            revokeAllowed = this.currentUserHasImpliedProjectPermission(permission, project);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasProjectPermissionThroughGroupMembership(project, permission, Collections.emptySet());
        }
        if (revokeAllowed) {
            return this.revokePermission(((InternalProjectPermission.Builder)((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).user(InternalConverter.convertToInternalUser((ApplicationUser)user))).build());
        }
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.cantrevokeownprojectpermission", new Object[]{project.getName()});
        throw new IntegrityException(message);
    }

    private boolean revokeProjectPermission(@Nonnull Permission permission, @Nonnull Project project, @Nonnull String group) {
        boolean revokeAllowed;
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        boolean bl = revokeAllowed = currentUser == null || !this.userService.isUserInGroup(currentUser, group);
        if (!revokeAllowed) {
            revokeAllowed = this.currentUserHasImpliedProjectPermission(permission, project);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasDirectProjectUserPermission(project, permission);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasProjectPermissionThroughGroupMembership(project, permission, Collections.singleton(group));
        }
        if (revokeAllowed) {
            return this.revokePermission(((InternalProjectPermission.Builder)((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).group(group)).build());
        }
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.cantrevokegroupprojectpermission", new Object[]{project.getName(), group});
        throw new IntegrityException(message);
    }

    private boolean currentUserHasImpliedProjectPermission(Permission permission, Project project) {
        return Iterables.any((Iterable)permission.getImplyingPermissions(), higherPermission -> {
            if (higherPermission.isGlobal()) {
                return this.permissionService.hasGlobalPermission(higherPermission);
            }
            if (higherPermission.isResource(Project.class)) {
                return this.permissionService.hasProjectPermission(project, higherPermission);
            }
            return false;
        });
    }

    private boolean revokeGlobalPermission(@Nonnull Permission permission, @Nonnull ApplicationUser user) {
        boolean revokeAllowed;
        boolean bl = revokeAllowed = !user.equals((Object)this.authenticationContext.getCurrentUser());
        if (!revokeAllowed) {
            Permission higherPermission;
            Set implyingPermissions = permission.getImplyingPermissions();
            Iterator iterator = implyingPermissions.iterator();
            while (iterator.hasNext() && !(revokeAllowed = this.permissionService.hasGlobalPermission(higherPermission = (Permission)iterator.next()))) {
            }
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasGlobalPermissionThroughGroupMembership(permission, Collections.emptySet());
        }
        if (revokeAllowed) {
            return this.revokePermission(((InternalGlobalPermission.Builder)((InternalGlobalPermission.Builder)new InternalGlobalPermission.Builder().permission(permission)).user(InternalConverter.convertToInternalUser((ApplicationUser)user))).build());
        }
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.cantrevokeownpermission", new Object[0]);
        throw new IntegrityException(message);
    }

    private boolean revokePermission(InternalGlobalPermission globalPermission) {
        return this.globalPermissionDao.revoke((InternalScopedPermission)globalPermission) > 0;
    }

    private boolean revokePermission(InternalProjectPermission projectPermission) {
        if (projectPermission.getProject().getType() == ProjectType.PERSONAL) {
            throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.personalproject.revoke", new Object[0]));
        }
        return this.projectPermissionDao.revoke((InternalScopedPermission)projectPermission) > 0;
    }

    private boolean revokePermission(InternalRepositoryPermission repositoryPermission) {
        return this.repositoryPermissionDao.revoke((InternalScopedPermission)repositoryPermission) > 0;
    }

    private boolean revokeGlobalPermission(@Nonnull Permission permission, @Nonnull String group) {
        boolean revokeAllowed;
        InternalApplicationUser currentUser = InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser());
        boolean bl = revokeAllowed = currentUser == null || !this.userService.isUserInGroup((ApplicationUser)currentUser, group);
        if (!revokeAllowed) {
            Permission higherPermission;
            Set implyingPermissions = permission.getImplyingPermissions();
            Iterator iterator = implyingPermissions.iterator();
            while (iterator.hasNext() && !(revokeAllowed = this.permissionService.hasGlobalPermission(higherPermission = (Permission)iterator.next()))) {
            }
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasDirectGlobalUserPermission(permission);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasGlobalPermissionThroughGroupMembership(permission, Collections.singleton(group));
        }
        if (revokeAllowed) {
            return this.revokePermission(((InternalGlobalPermission.Builder)((InternalGlobalPermission.Builder)new InternalGlobalPermission.Builder().permission(permission)).group(group)).build());
        }
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.cantrevokegrouppermission", new Object[]{group});
        throw new IntegrityException(message);
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void revokeAllProjectPermission(@Nonnull Permission permission, @Nonnull Project project) {
        CommonValidations.validateProjectPermission(permission);
        CommonValidations.validateGrantablePermission(permission);
        Objects.requireNonNull(project, "project");
        boolean revoked = this.revokePermission(((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).build());
        if (revoked) {
            boolean effectivePermissionChange;
            Permission newPermission = this.projectPermissionDao.getHighestDefaultPermission(project.getId());
            boolean bl = effectivePermissionChange = newPermission == null || newPermission.getImplyingPermissions().contains(permission);
            if (effectivePermissionChange) {
                this.fireProjectPermissionRequestedEvent(project, permission, newPermission, null, null);
                this.fireProjectPermissionEvent(project, permission, newPermission, null, null);
            }
        }
    }

    @Transactional
    @PreAuthorize(value="not isCurrentUser(#username) and (hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#username, 'SYS_ADMIN')))")
    public void revokeAllUserPermissions(@Nonnull String username) {
        CommonValidations.validateUser(username);
        ApplicationUser user = this.userService.getUserByName(username, true);
        if (user != null) {
            this.revokeAllUserPermissions(user);
        }
    }

    @Transactional
    @PreAuthorize(value="not isCurrentUser(#user) and (hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#user, 'SYS_ADMIN')))")
    public void revokeAllUserPermissions(@Nonnull ApplicationUser user) {
        Objects.requireNonNull(user, "user");
        this.globalPermissionDao.revokeAll(user.getId());
        this.projectPermissionDao.revokeAll(user.getId());
        this.repositoryPermissionDao.revokeAll(user.getId());
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void revokeAllGroupPermissions(@Nonnull String name) {
        CommonValidations.validateGroup(name);
        this.canRemovePermissionsFromGroup(name);
        this.globalPermissionDao.revokeAll(name);
        this.projectPermissionDao.revokeAll(name);
        this.repositoryPermissionDao.revokeAll(name);
    }

    private void canRemovePermissionsFromGroup(String name) {
        try {
            this.canDeleteGroup(name);
        }
        catch (IntegrityException e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.cannotremovepermissionsgroup", new Object[0]);
            throw new IntegrityException(message);
        }
        catch (ForbiddenException e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.cannotdeletegroup", new Object[]{"You cannot remove the permissions of the group {0} as it has System Administrator privileges, and you are not a System Administrator.", name});
            throw new ForbiddenException(message);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void canRemoveUserFromGroup(@Nonnull String username, @Nonnull String group) {
        CommonValidations.validateUser(username);
        CommonValidations.validateGroup(group);
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null && IdentifierUtils.equalsInLowerCase((String)currentUser.getName(), (String)username)) {
            if (!this.userService.isUserInGroup(currentUser, group)) {
                return;
            }
            if (!this.canRemoveCurrentUserFromGroup(group)) {
                KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.cannotremoveself", new Object[0]);
                throw new IntegrityException(message);
            }
        } else if (this.permissionService.hasGlobalGroupPermission(Permission.SYS_ADMIN, group) && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.cannotremoveuser", new Object[]{username, group});
            throw new ForbiddenException(message);
        }
    }

    private boolean canRemoveCurrentUserFromGroup(String group) {
        return !(this.permissionService.hasGlobalGroupPermission(Permission.SYS_ADMIN, group) ? !this.permissionService.hasDirectGlobalUserPermission(Permission.SYS_ADMIN) && !this.permissionService.hasGlobalPermissionThroughGroupMembership(Permission.SYS_ADMIN, Collections.singleton(group)) : this.permissionService.hasGlobalGroupPermission(Permission.ADMIN, group) && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN) && !this.permissionService.hasDirectGlobalUserPermission(Permission.ADMIN) && !this.permissionService.hasGlobalPermissionThroughGroupMembership(Permission.ADMIN, Collections.singleton(group)));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void canAddUserToGroup(@Nonnull String group) {
        CommonValidations.validateGroup(group);
        if (!this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN) && this.permissionService.hasGlobalGroupPermission(Permission.SYS_ADMIN, group)) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.cannotaddusertogroup", new Object[]{group});
            throw new ForbiddenException(message);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void canDeleteGroup(@Nonnull String group) {
        CommonValidations.validateGroup(group);
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null && this.userService.isUserInGroup(currentUser, group)) {
            if (!this.canRemoveCurrentUserFromGroup(group)) {
                KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.cannotremovegroup", new Object[0]);
                throw new IntegrityException(message);
            }
        } else if (!this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN) && this.permissionService.hasGlobalGroupPermission(Permission.SYS_ADMIN, group)) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.cannotdeletegroup", new Object[]{group});
            throw new ForbiddenException(message);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void canDeleteUser(@Nonnull String username) {
        CommonValidations.validateUser(username);
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null && IdentifierUtils.equalsInLowerCase((String)currentUser.getName(), (String)username)) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.selfdelete", new Object[0]);
            throw new IntegrityException(message);
        }
        ApplicationUser user = this.userService.getUserByName(username);
        if (user == null) {
            return;
        }
        if (this.permissionService.hasGlobalPermission(user, Permission.SYS_ADMIN) && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.cannotdeleteuser", new Object[]{user.getName()});
            throw new ForbiddenException(message);
        }
    }

    @EventListener
    public void onGroupDeleted(GroupCleanupEvent event) {
        this.globalPermissionDao.revokeAll(event.getGroup());
        this.projectPermissionDao.revokeAll(event.getGroup());
        this.repositoryPermissionDao.revokeAll(event.getGroup());
    }

    @EventListener
    public void onUserDeleted(UserCleanupEvent event) {
        this.globalPermissionDao.revokeAll(event.getDeletedUser().getId());
        this.projectPermissionDao.revokeAll(event.getDeletedUser().getId());
        this.repositoryPermissionDao.revokeAll(event.getDeletedUser().getId());
    }

    private InternalGlobalPermission buildPermission(Permission permission, String group, ApplicationUser user) {
        return ((InternalGlobalPermission.Builder)((InternalGlobalPermission.Builder)((InternalGlobalPermission.Builder)new InternalGlobalPermission.Builder().permission(permission)).user(InternalConverter.convertToInternalUser((ApplicationUser)user))).group(group)).build();
    }

    private void fireGlobalPermissionEvent(final Permission oldValue, final Permission newValue, final String group, final ApplicationUser user) {
        this.eventPublisher.publish((Object)DefaultPermissionAdminService.visitPermissionAction(oldValue, newValue, new PermissionActionVisitor<PermissionEvent>(){

            @Override
            public GlobalPermissionGrantedEvent visitPermissionGranted() {
                return new GlobalPermissionGrantedEvent((Object)DefaultPermissionAdminService.this, newValue, group, user);
            }

            @Override
            public GlobalPermissionModifiedEvent visitPermissionModified() {
                return new GlobalPermissionModifiedEvent((Object)DefaultPermissionAdminService.this, oldValue, newValue, group, user);
            }

            @Override
            public GlobalPermissionRevokedEvent visitPermissionRevoked() {
                return new GlobalPermissionRevokedEvent((Object)DefaultPermissionAdminService.this, oldValue, group, user);
            }
        }));
    }

    private void fireGlobalPermissionRequestedEvent(final Permission oldValue, final Permission newValue, final String group, final ApplicationUser user) {
        final SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)DefaultPermissionAdminService.visitPermissionAction(oldValue, newValue, new PermissionActionVisitor<PermissionEvent>(){

            @Override
            public GlobalPermissionGrantRequestedEvent visitPermissionGranted() {
                return new GlobalPermissionGrantRequestedEvent((Object)DefaultPermissionAdminService.this, newValue, group, user, (CancelState)cancelState);
            }

            @Override
            public GlobalPermissionModificationRequestedEvent visitPermissionModified() {
                return new GlobalPermissionModificationRequestedEvent((Object)DefaultPermissionAdminService.this, oldValue, newValue, group, user, (CancelState)cancelState);
            }

            @Override
            public GlobalPermissionRevocationRequestedEvent visitPermissionRevoked() {
                return new GlobalPermissionRevocationRequestedEvent((Object)DefaultPermissionAdminService.this, oldValue, group, user, (CancelState)cancelState);
            }
        }));
        this.maybeCancelRequest(oldValue, newValue, cancelState);
    }

    private void fireProjectPermissionEvent(final Project project, final Permission oldValue, final Permission newValue, final String group, final ApplicationUser user) {
        this.eventPublisher.publish((Object)DefaultPermissionAdminService.visitPermissionAction(oldValue, newValue, new PermissionActionVisitor<ProjectPermissionEvent>(){

            @Override
            public ProjectPermissionGrantedEvent visitPermissionGranted() {
                return new ProjectPermissionGrantedEvent((Object)DefaultPermissionAdminService.this, newValue, project, group, user);
            }

            @Override
            public ProjectPermissionModifiedEvent visitPermissionModified() {
                return new ProjectPermissionModifiedEvent((Object)DefaultPermissionAdminService.this, oldValue, newValue, project, group, user);
            }

            @Override
            public ProjectPermissionRevokedEvent visitPermissionRevoked() {
                return new ProjectPermissionRevokedEvent((Object)DefaultPermissionAdminService.this, oldValue, project, group, user);
            }
        }));
    }

    private void fireProjectPermissionRequestedEvent(final Project project, final Permission oldValue, final Permission newValue, final String group, final ApplicationUser user) {
        final SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)DefaultPermissionAdminService.visitPermissionAction(oldValue, newValue, new PermissionActionVisitor<PermissionEvent>(){

            @Override
            public ProjectPermissionGrantRequestedEvent visitPermissionGranted() {
                return new ProjectPermissionGrantRequestedEvent((Object)DefaultPermissionAdminService.this, newValue, project, group, user, (CancelState)cancelState);
            }

            @Override
            public ProjectPermissionModificationRequestedEvent visitPermissionModified() {
                return new ProjectPermissionModificationRequestedEvent((Object)DefaultPermissionAdminService.this, oldValue, newValue, project, group, user, (CancelState)cancelState);
            }

            @Override
            public ProjectPermissionRevocationRequestedEvent visitPermissionRevoked() {
                return new ProjectPermissionRevocationRequestedEvent((Object)DefaultPermissionAdminService.this, oldValue, project, group, user, (CancelState)cancelState);
            }
        }));
        this.maybeCancelRequest(oldValue, newValue, cancelState);
    }

    private void fireRepositoryPermissionEvent(final Repository repository, final Permission oldValue, final Permission newValue, final String group, final ApplicationUser user) {
        this.eventPublisher.publish((Object)DefaultPermissionAdminService.visitPermissionAction(oldValue, newValue, new PermissionActionVisitor<RepositoryPermissionEvent>(){

            @Override
            public RepositoryPermissionGrantedEvent visitPermissionGranted() {
                return new RepositoryPermissionGrantedEvent((Object)DefaultPermissionAdminService.this, newValue, repository, group, user);
            }

            @Override
            public RepositoryPermissionModifiedEvent visitPermissionModified() {
                return new RepositoryPermissionModifiedEvent((Object)DefaultPermissionAdminService.this, oldValue, newValue, repository, group, user);
            }

            @Override
            public RepositoryPermissionRevokedEvent visitPermissionRevoked() {
                return new RepositoryPermissionRevokedEvent((Object)DefaultPermissionAdminService.this, oldValue, repository, group, user);
            }
        }));
    }

    private void fireRepositoryPermissionRequestedEvent(final Repository repository, final Permission oldValue, final Permission newValue, final String group, final ApplicationUser user) {
        final SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)DefaultPermissionAdminService.visitPermissionAction(oldValue, newValue, new PermissionActionVisitor<RepositoryPermissionEvent>(){

            @Override
            public RepositoryPermissionGrantRequestedEvent visitPermissionGranted() {
                return new RepositoryPermissionGrantRequestedEvent((Object)DefaultPermissionAdminService.this, newValue, repository, group, user, (CancelState)cancelState);
            }

            @Override
            public RepositoryPermissionModificationRequestedEvent visitPermissionModified() {
                return new RepositoryPermissionModificationRequestedEvent((Object)DefaultPermissionAdminService.this, oldValue, newValue, repository, group, user, (CancelState)cancelState);
            }

            @Override
            public RepositoryPermissionRevocationRequestedEvent visitPermissionRevoked() {
                return new RepositoryPermissionRevocationRequestedEvent((Object)DefaultPermissionAdminService.this, oldValue, repository, group, user, (CancelState)cancelState);
            }
        }));
        this.maybeCancelRequest(oldValue, newValue, cancelState);
    }

    private Page<ApplicationUser> getUsersWithoutPermission(Predicate<ApplicationUser> pageFilter, UserType userType, String filter, PageRequest request) {
        PageProvider<ApplicationUser> userProvider = this.createUserProvider(userType, filter);
        UserPageFilter userMatchFilter = new UserPageFilter(filter);
        PageRequest pageRequest = request.buildRestrictedPageRequest(this.maxUsers);
        return PageUtils.filterPages(userProvider, userMatchFilter.and(pageFilter), (PageRequest)pageRequest);
    }

    private Page<String> getGroupsWithoutPermission(String groupnamePattern, Predicate<String> groupsWithoutPermissionFilter, PageRequest request) {
        PageProvider groupsProvider = request1 -> this.userService.findGroupsByName(groupnamePattern, request1);
        GroupPageFilter groupPageFilter = new GroupPageFilter(groupnamePattern);
        PageRequest pageRequest = request.buildRestrictedPageRequest(this.maxGroups);
        return PageUtils.filterPages((PageProvider)groupsProvider, groupPageFilter.and(groupsWithoutPermissionFilter), (PageRequest)pageRequest).transform(IdentifierUtils.TO_LOWER_CASE::apply);
    }

    private void maybeCancelRequest(Permission oldValue, Permission newValue, final SimpleCancelState cancelState) {
        if (cancelState.isCanceled()) {
            throw DefaultPermissionAdminService.visitPermissionAction(oldValue, newValue, new PermissionActionVisitor<RequestCanceledException>(){

                @Override
                public PermissionGrantCanceledException visitPermissionGranted() {
                    return new PermissionGrantCanceledException(DefaultPermissionAdminService.this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.grantcanceled", new Object[0]), cancelState.getCancelMessages());
                }

                @Override
                public PermissionModificationCanceledException visitPermissionModified() {
                    return new PermissionModificationCanceledException(DefaultPermissionAdminService.this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.modificationcanceled", new Object[0]), cancelState.getCancelMessages());
                }

                @Override
                public PermissionRevocationCanceledException visitPermissionRevoked() {
                    return new PermissionRevocationCanceledException(DefaultPermissionAdminService.this.i18nService.createKeyedMessage("bitbucket.service.permissionadmin.revocationcanceled", new Object[0]), cancelState.getCancelMessages());
                }
            });
        }
    }

    private void validateIsNotRestricted(Set<ApplicationUser> users, Set<String> groups, Repository repository, String errorKey, Object ... params) {
        boolean requestContainsNonServiceUsers;
        boolean bl = requestContainsNonServiceUsers = users.stream().anyMatch(user -> user.getType() != UserType.SERVICE) || !groups.isEmpty();
        if (requestContainsNonServiceUsers && !this.permissionService.hasProjectPermission(repository.getProject(), Permission.PROJECT_ADMIN) && this.projectSettingsRestrictionService.hasRestriction(repository.getProject(), ProjectSettingsRestrictionKeys.REPOSITORY_PERMISSIONS)) {
            throw new ForbiddenException(this.i18nService.createKeyedMessage(errorKey, params));
        }
    }

    @VisibleForTesting
    static Predicate<String> withoutGroups(PageProvider<String> provider) {
        return new InIteratorPredicate<String>(CASE_INSENSITIVE_COMPARATOR, new PagedIterable(provider, 500).iterator()).negate();
    }

    @VisibleForTesting
    static Predicate<ApplicationUser> withoutUsers(PageProvider<ApplicationUser> provider) {
        return new InIteratorPredicate<ApplicationUser>(CASE_INSENSITIVE_NAME_COMPARATOR, new PagedIterable(provider, 500).iterator()).negate();
    }

    private static <T> T visitPermissionAction(Permission existingPermission, Permission newPermission, PermissionActionVisitor<T> visitor) {
        if (existingPermission == null) {
            return visitor.visitPermissionGranted();
        }
        if (newPermission == null) {
            return visitor.visitPermissionRevoked();
        }
        return visitor.visitPermissionModified();
    }

    private Predicate<ApplicationUser> licensedOnly() {
        return user -> this.permissionService.hasGlobalPermission(user, Permission.LICENSED_USER);
    }

    private static interface PermissionActionVisitor<T> {
        public T visitPermissionGranted();

        public T visitPermissionModified();

        public T visitPermissionRevoked();
    }
}

