/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.event.request.RequestStartedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.NotProfiled;
import com.atlassian.stash.internal.permission.PermissionVoterFactory;
import com.atlassian.stash.internal.user.DefaultEscalatedSecurityContext;
import jakarta.annotation.Nonnull;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=SecurityService.class)
@NotProfiled
@Service(value="securityService")
public class DefaultSecurityService
implements SecurityService {
    private final RequestManager requestManager;
    private final PermissionVoterFactory voterFactory;

    @Autowired
    public DefaultSecurityService(RequestManager requestManager, PermissionVoterFactory voterFactory) {
        this.requestManager = requestManager;
        this.voterFactory = voterFactory;
    }

    @Nonnull
    public EscalatedSecurityContext anonymously(@Nonnull String reason) {
        return this.contextBuilder(reason).anonymously().build();
    }

    @Nonnull
    public EscalatedSecurityContext escalate(@Nonnull String reason) {
        return this.contextBuilder(reason).build();
    }

    @Nonnull
    public EscalatedSecurityContext impersonating(@Nonnull ApplicationUser user, @Nonnull String reason) {
        return this.contextBuilder(reason).impersonating(user).build();
    }

    @EventListener
    public void onRequestStarted(RequestStartedEvent event) {
        event.getRequestContext().addCleanupCallback(SecurityContextHolder::clearContext);
    }

    @Nonnull
    public EscalatedSecurityContext withPermission(@Nonnull Permission permission, @Nonnull String reason) {
        return this.contextBuilder(reason).withPermission(permission).build();
    }

    @Nonnull
    public EscalatedSecurityContext withPermission(@Nonnull Permission permission, @Nonnull Object resource, @Nonnull String reason) {
        return this.contextBuilder(reason).withPermission(resource, permission).build();
    }

    @Nonnull
    public EscalatedSecurityContext withPermissions(@Nonnull Set<Permission> permissions, @Nonnull String reason) {
        return this.contextBuilder(reason).withPermissions(permissions).build();
    }

    private DefaultEscalatedSecurityContext.Builder contextBuilder(String reason) {
        return new DefaultEscalatedSecurityContext.Builder(reason, this.requestManager, this.voterFactory);
    }
}

