/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.ForbiddenException;
import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.dmz.user.DetailedUserCallback;
import com.atlassian.bitbucket.dmz.user.DetailedUserSearchRequest;
import com.atlassian.bitbucket.dmz.user.DmzUserAdminService;
import com.atlassian.bitbucket.dmz.user.LicenseStatus;
import com.atlassian.bitbucket.event.user.GroupCleanupEvent;
import com.atlassian.bitbucket.event.user.UserCleanupEvent;
import com.atlassian.bitbucket.event.user.UserErasedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.license.LicenseLimitException;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.mail.MailException;
import com.atlassian.bitbucket.permission.PermissionAdminService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.DetailedGroup;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.IllegalUserStateException;
import com.atlassian.bitbucket.user.InvalidPasswordResetTokenException;
import com.atlassian.bitbucket.user.NoSuchGroupException;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.ServiceUserCreateRequest;
import com.atlassian.bitbucket.user.ServiceUserUpdateRequest;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserErasureRequest;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.crowd.CrowdUserSearchRequest;
import com.atlassian.stash.internal.crowd.InternalTombstoneCleanupService;
import com.atlassian.stash.internal.group.DeletedGroupDao;
import com.atlassian.stash.internal.group.InternalDeletedGroup;
import com.atlassian.stash.internal.license.LicensedUserCache;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.AbstractVoidInternalStashUserVisitor;
import com.atlassian.stash.internal.user.AnalyticsUserErasureFailedEvent;
import com.atlassian.stash.internal.user.ApplicationUserDao;
import com.atlassian.stash.internal.user.EmailNotifier;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalCaptchaService;
import com.atlassian.stash.internal.user.InternalDetailedGroup;
import com.atlassian.stash.internal.user.InternalDetailedUser;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalServiceUser;
import com.atlassian.stash.internal.user.InternalStashUserVisitor;
import com.atlassian.stash.internal.user.PasswordResetHelper;
import com.atlassian.stash.internal.user.UserErasureIdentifierGenerator;
import com.atlassian.stash.internal.user.UserErasureService;
import com.atlassian.stash.internal.user.UserHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.internal.constraintvalidators.hv.EmailValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(interfaces={DmzUserAdminService.class, UserAdminService.class})
@Service(value="userAdminService")
public class DefaultUserAdminService
extends AbstractService
implements DmzUserAdminService,
ScheduledJobSource {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserAdminService.class);
    private static final JobId GROUP_CLEANUP_JOB_ID = JobId.of((String)GroupCleanUpJob.class.getSimpleName());
    private static final JobRunnerKey GROUP_CLEANUP_JOB_RUNNER_KEY = JobRunnerKey.of((String)GroupCleanUpJob.class.getName());
    private static final String LICENSE_STATUS_PROPERTY = "licenseStatus";
    private static final JobId USER_CLEANUP_JOB_ID = JobId.of((String)UserCleanupJob.class.getSimpleName());
    private static final JobRunnerKey USER_CLEANUP_JOB_RUNNER_KEY = JobRunnerKey.of((String)UserCleanupJob.class.getName());
    private final Clock clock;
    private final CrowdControl crowdControl;
    private final EmailNotifier emailNotifier;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final LicenseService licenseService;
    private final LicensedUserCache licensedUserCache;
    private final PasswordResetHelper passwordResetHelper;
    private final PermissionAdminService permissionAdminService;
    private final ApplicationUserDao userDao;
    private final UserHelper userHelper;
    private final DeletedGroupDao deletedGroupDao;
    private final InternalCaptchaService captchaService;
    private final TransactionTemplate requiresNewTransactionTemplate;
    private final SecureTokenGenerator secureTokenGenerator;
    private final UserErasureIdentifierGenerator userErasureIdentifierGenerator;
    private final UserErasureService userErasureService;
    private int maxUserPageSize;
    private InternalTombstoneCleanupService tombstoneCleanupService;
    private int userCleanupJobBatchSize;
    private long userCleanupJobDelay;
    private long userCleanupJobInterval;
    private int groupCleanupJobBatchSize;
    private long groupCleanupJobDelay;
    private long groupCleanupJobInterval;

    @Autowired
    public DefaultUserAdminService(Clock clock, CrowdControl crowdControl, PermissionAdminService permissionAdminService, PasswordResetHelper passwordResetHelper, EmailNotifier emailNotifier, LicenseService licenseService, LicensedUserCache licensedUserCache, I18nService i18nService, UserHelper userHelper, EventPublisher eventPublisher, ApplicationUserDao userDao, DeletedGroupDao deletedGroupDao, InternalCaptchaService captchaService, PlatformTransactionManager transactionManager, SecureTokenGenerator secureTokenGenerator, UserErasureIdentifierGenerator userErasureIdentifierGenerator, UserErasureService userErasureService, InternalTombstoneCleanupService tombstoneCleanupService) {
        this.captchaService = captchaService;
        this.clock = clock;
        this.crowdControl = crowdControl;
        this.deletedGroupDao = deletedGroupDao;
        this.emailNotifier = emailNotifier;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.licenseService = licenseService;
        this.licensedUserCache = licensedUserCache;
        this.permissionAdminService = permissionAdminService;
        this.passwordResetHelper = passwordResetHelper;
        this.secureTokenGenerator = secureTokenGenerator;
        this.userErasureIdentifierGenerator = userErasureIdentifierGenerator;
        this.userErasureService = userErasureService;
        this.userHelper = userHelper;
        this.userDao = userDao;
        this.tombstoneCleanupService = tombstoneCleanupService;
        this.requiresNewTransactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @Value(value="${page.max.users}")
    public void setMaxUserPageSize(int value) {
        this.maxUserPageSize = value;
    }

    @Value(value="${group.cleanup.job.batch.size}")
    public void setGroupCleanupJobBatchSize(int value) {
        this.groupCleanupJobBatchSize = value;
    }

    @Value(value="${group.cleanup.job.delay}")
    public void setGroupCleanupJobDelay(long value) {
        this.groupCleanupJobDelay = value;
    }

    @Value(value="${group.cleanup.job.interval}")
    public void setGroupCleanupJobInterval(long value) {
        this.groupCleanupJobInterval = value;
    }

    @Value(value="${user.cleanup.job.batch.size}")
    public void setUserCleanupJobBatchSize(int value) {
        this.userCleanupJobBatchSize = value;
    }

    @Value(value="${user.cleanup.job.delay}")
    public void setUserCleanupJobDelay(long value) {
        this.userCleanupJobDelay = value;
    }

    @Value(value="${user.cleanup.job.interval}")
    public void setUserCleanupJobInterval(long value) {
        this.userCleanupJobInterval = value;
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void addUserToGroups(@Nonnull String username, @Nonnull Set<String> groupNames) throws ForbiddenException, LicenseLimitException, NoSuchGroupException, NoSuchUserException {
        Objects.requireNonNull(username, "username");
        Objects.requireNonNull(groupNames, "groupNames");
        Preconditions.checkArgument((boolean)Iterables.all(groupNames, (Predicate)Predicates.notNull()), (Object)"groupNames contains a null group name");
        for (String groupName : groupNames) {
            this.doAddUserToGroup(username, groupName);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void addMembersToGroup(@Nonnull String groupName, @Nonnull Set<String> usernames) throws ForbiddenException, LicenseLimitException, NoSuchGroupException, NoSuchUserException {
        Objects.requireNonNull(groupName, "groupName");
        Objects.requireNonNull(usernames, "usernames");
        Preconditions.checkArgument((boolean)Iterables.all(usernames, (Predicate)Predicates.notNull()), (Object)"usernames contains a null username");
        for (String username : usernames) {
            this.doAddUserToGroup(username, groupName);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public boolean canCreateGroups() {
        return this.isAllowedInAnyDirectory(OperationType.CREATE_GROUP);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public boolean canUpdateGroups() {
        return this.isAllowedInAnyDirectory(OperationType.UPDATE_GROUP);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public boolean canCreateUsers() {
        return this.isAllowedInAnyDirectory(OperationType.CREATE_USER);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public boolean canDeleteGroups() {
        return this.isAllowedInAnyDirectory(OperationType.DELETE_GROUP);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public boolean newUserCanResetPassword() {
        return this.crowdControl.getCapabilitiesForNewUsers().canResetPassword();
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#username, 'SYS_ADMIN'))")
    public void clearCaptchaChallenge(@Nonnull String username) {
        this.captchaService.clear(username);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public InternalDetailedGroup createGroup(@Nonnull String groupName) {
        Objects.requireNonNull(groupName, "groupName");
        this.crowdControl.createGroup((Group)new ImmutableGroup(groupName));
        return new InternalDetailedGroup.Builder().deletable(this.canDeleteGroups()).name(groupName).build();
    }

    @Nonnull
    @Unsecured(value="This should only ever be called by plugins")
    @Transactional
    public ServiceUser createServiceUser(@Nonnull ServiceUserCreateRequest userRequest) throws IntegrityException {
        Objects.requireNonNull(userRequest, "userRequest");
        if (userRequest.getName() != null && this.userDao.findServiceUserByName(userRequest.getName(), true) != null) {
            throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.service.user.alreadyexists", new Object[]{userRequest.getName()}));
        }
        String username = StringUtils.substring((String)this.secureTokenGenerator.generateToken(), (int)0, (int)16);
        return this.userDao.create(((InternalServiceUser.Builder)new InternalServiceUser.Builder().active(userRequest.isActive()).displayName(userRequest.getDisplayName()).emailAddress(userRequest.getEmailAddress()).label(userRequest.getLabel()).name(StringUtils.isNotBlank((CharSequence)userRequest.getName()) ? userRequest.getName() : username)).build());
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void createUser(@Nonnull String username, @Nonnull String password, @Nonnull String displayName, @Nonnull String emailAddress) {
        this.createUser(username, password, displayName, emailAddress, true);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void createUser(@Nonnull String username, @Nonnull String password, @Nonnull String displayName, @Nonnull String emailAddress, boolean addToDefaultGroup) {
        Preconditions.checkArgument((!Objects.requireNonNull(displayName, "displayName").trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank display name is required");
        Preconditions.checkArgument((!Objects.requireNonNull(emailAddress, "emailAddress").trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank e-mail address is required");
        Preconditions.checkArgument((boolean)new EmailValidator().isValid((CharSequence)emailAddress, null), (Object)"A valid e-mail address is required");
        Preconditions.checkArgument((!Objects.requireNonNull(password, "password").trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank password is required");
        Objects.requireNonNull(username, "username");
        ImmutableUser user = ImmutableUser.newUser().displayName(displayName).emailAddress(emailAddress).name(username).toUser();
        this.createUser((User)user, password, addToDefaultGroup);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void createUserWithGeneratedPassword(@Nonnull String username, @Nonnull String displayName, @Nonnull String emailAddress) {
        Preconditions.checkArgument((!Objects.requireNonNull(displayName, "displayName").trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank display name is required");
        Preconditions.checkArgument((!Objects.requireNonNull(emailAddress, "emailAddress").trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank e-mail address is required");
        Preconditions.checkArgument((boolean)new EmailValidator().isValid((CharSequence)emailAddress, null), (Object)"A valid e-mail address is required");
        Objects.requireNonNull(username, "username");
        this.emailNotifier.validateCanSendEmails();
        ImmutableUser user = ImmutableUser.newUser().displayName(displayName).emailAddress(emailAddress).name(username).toUser();
        this.createUser((User)user, this.passwordResetHelper.generatePassword(), true);
        if (!this.crowdControl.canResetPassword(username)) {
            throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.service.cant.send.email.passwordReset", new Object[]{Product.NAME}));
        }
        String token = this.passwordResetHelper.addToken((User)user);
        this.emailNotifier.sendCreatedUser((User)user, token);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public InternalDetailedGroup deleteGroup(@Nonnull String groupName) {
        Objects.requireNonNull(groupName, "groupName");
        this.permissionAdminService.canDeleteGroup(groupName);
        this.permissionAdminService.revokeAllGroupPermissions(groupName);
        Group group = this.crowdControl.getGroup(groupName);
        this.crowdControl.deleteGroup(group);
        return new InternalDetailedGroup.Builder().deletable(false).name(groupName).build();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public InternalDetailedUser deleteUser(@Nonnull String username) {
        Objects.requireNonNull(username, "username");
        this.permissionAdminService.canDeleteUser(username);
        User user = this.crowdControl.getUser(username);
        this.crowdControl.deleteUser(user);
        return new InternalDetailedUser.Builder((InternalApplicationUser)this.userHelper.transformOrCreate(user)).build();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public String eraseUser(@Nonnull String username) {
        InternalNormalUser erasedUser;
        Objects.requireNonNull(username, "username");
        long startTime = System.nanoTime();
        try {
            erasedUser = this.renameUserForErasure(username);
            this.userErasureService.eraseUser(new UserErasureRequest.Builder((ApplicationUser)erasedUser, username).build());
        }
        catch (IllegalUserStateException | NoSuchUserException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.eventPublisher.publish((Object)new AnalyticsUserErasureFailedEvent(this.calculateDuration(startTime)));
            throw e;
        }
        this.eventPublisher.publish((Object)new UserErasedEvent((Object)this, this.calculateDuration(startTime), username, (ApplicationUser)erasedUser));
        return erasedUser.getUsername();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<DetailedGroup> findGroups(@Nonnull PageRequest pageRequest) {
        return this.transformGroups((Page<String>)this.crowdControl.findGroups(pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<DetailedGroup> findGroupsByName(String groupName, @Nonnull PageRequest pageRequest) {
        return this.transformGroups((Page<String>)this.crowdControl.findGroupsByName(groupName, pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<DetailedGroup> findGroupsWithUser(@Nonnull String username, String groupName, @Nonnull PageRequest pageRequest) {
        return this.transformGroups((Page<String>)this.crowdControl.findGroupsByUser(username, groupName, false, pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<DetailedGroup> findGroupsWithoutUser(@Nonnull String username, String groupName, @Nonnull PageRequest pageRequest) {
        return this.transformGroups((Page<String>)this.crowdControl.findGroupsByUser(username, groupName, true, pageRequest));
    }

    @Unsecured(value="Password reset runs in a non-authenticated context and requires no permissions")
    public InternalDetailedUser findUserByPasswordResetToken(@Nonnull String token) {
        User user = this.passwordResetHelper.findUserByToken(token);
        return user == null ? null : this.transformOrCreateUser(user);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    @Transactional
    public Page<DetailedUser> findUsers(@Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return this.transformOrCreateUsers((Page<User>)this.crowdControl.findUsers(pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    @Transactional
    public Page<DetailedUser> findUsersByName(String username, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return this.transformOrCreateUsers((Page<User>)this.crowdControl.findUsersByName(username, pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    @Transactional
    public Page<DetailedUser> findUsersWithGroup(@Nonnull String groupName, String username, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return this.transformOrCreateUsers((Page<User>)this.crowdControl.findUsersByGroup(groupName, username, false, pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    @Transactional
    public Page<DetailedUser> findUsersWithoutGroup(@Nonnull String groupName, String username, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return this.transformOrCreateUsers((Page<User>)this.crowdControl.findUsersByGroup(groupName, username, true, pageRequest));
    }

    @PostAuthorize(value="hasGlobalPermission('ADMIN') or hasUserPermission(returnObject, 'USER_ADMIN')")
    @Transactional
    public InternalDetailedUser getUserDetails(@Nonnull String username) {
        User user = this.crowdControl.findUser(username, true);
        return user == null ? null : this.transformOrCreateUser(user);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN') or hasUserPermission(#user, 'USER_ADMIN')")
    @Transactional
    public InternalDetailedUser getUserDetails(@Nonnull ApplicationUser user) {
        if (user instanceof InternalApplicationUser) {
            return this.transformUser((InternalApplicationUser)user);
        }
        InternalDetailedUser detailedUser = this.getUserDetails(Objects.requireNonNull(user, "user").getName());
        if (detailedUser == null) {
            throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.service.user.nosuchuser", new Object[]{user.getName()}), user.getName());
        }
        return detailedUser;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public List<Directory> listDirectories(boolean includeInactive) {
        return (List)this.crowdControl.listDirectories().stream().filter(dir -> includeInactive || dir.isActive()).sorted(Comparator.comparing(Directory::getName, String.CASE_INSENSITIVE_ORDER)).collect(MoreCollectors.toImmutableList());
    }

    @EventListener
    public void onGroupDeleted(GroupDeletedEvent event) {
        final String groupName = event.getGroupName();
        if (this.crowdControl.findGroup(event.getGroupName()) == null) {
            this.requiresNewTransactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    InternalDeletedGroup deletedGroup = DefaultUserAdminService.this.deletedGroupDao.findByName(groupName);
                    if (deletedGroup == null) {
                        DefaultUserAdminService.this.deletedGroupDao.create((Object)new InternalDeletedGroup.Builder().name(groupName).deletedDate(Date.from(DefaultUserAdminService.this.clock.instant())).build());
                    } else {
                        DefaultUserAdminService.this.deletedGroupDao.update((Object)new InternalDeletedGroup.Builder(deletedGroup).deletedDate(Date.from(DefaultUserAdminService.this.clock.instant())).build());
                    }
                }
            });
        }
    }

    @EventListener
    public void onUserDeleted(UserDeletedEvent event) {
        final String username = event.getUsername();
        this.requiresNewTransactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                if (DefaultUserAdminService.this.crowdControl.findUser(username, true) != null) {
                    return;
                }
                InternalNormalUser stashUser = DefaultUserAdminService.this.userDao.findByName(username);
                if (stashUser != null) {
                    InternalNormalUser userWithDeletedDate = stashUser.copy().deletedDate(new Date()).build();
                    DefaultUserAdminService.this.userDao.update((Object)userWithDeletedDate);
                } else {
                    log.debug("Crowd dispatched a {} for a user ({}) with no corresponding {} and was ignored.", new Object[]{UserDeletedEvent.class.getSimpleName(), ApplicationUser.class.getSimpleName(), username});
                }
            }
        });
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void removeUserFromGroup(@Nonnull String groupName, @Nonnull String username) {
        Objects.requireNonNull(groupName, "groupName");
        Objects.requireNonNull(username, "username");
        this.permissionAdminService.canRemoveUserFromGroup(username, groupName);
        Group group = this.crowdControl.getGroup(groupName);
        User user = this.crowdControl.getUser(username);
        if (!this.crowdControl.removeGroupMember(group, user)) {
            Directory directory = this.crowdControl.findDirectoryFor(user);
            String directoryName = directory == null ? "<Unknown>" : directory.getName();
            log.info(String.format("Failed to remove user %1$s from group %2$s. Group %2$s may not exist in the same directory as the primary user with name %1$s. The 'primary' user is the first user with that name resolved from the ordered list of User Directories.", username, groupName));
            throw new NoSuchGroupException(this.i18nService.createKeyedMessage("bitbucket.service.removeUserFromGroup.notFromGroup", new Object[]{username, directoryName, groupName}), groupName);
        }
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#currentUsername, 'SYS_ADMIN'))")
    public DetailedUser renameUser(@Nonnull String currentUsername, @Nonnull String newUsername) {
        Objects.requireNonNull(currentUsername, "currentUserName");
        Objects.requireNonNull(newUsername, "newUserName");
        User user = this.crowdControl.getUser(currentUsername);
        user = this.crowdControl.renameUser(user, newUsername);
        return this.transformOrCreateUser(user);
    }

    @Transactional
    @Unsecured(value="Password reset runs in a non-authenticated context and requires no permissions")
    public void requestPasswordReset(@Nonnull String username) throws NoSuchEntityException, MailException {
        User user = this.crowdControl.getUser(username);
        this.emailNotifier.sendPasswordReset(user, this.crowdControl.canResetPassword(username) ? this.passwordResetHelper.addToken(user) : null);
    }

    @Transactional
    @Unsecured(value="Password reset runs in a non-authenticated context and requires no permissions")
    public void resetPassword(@Nonnull String token, @Nonnull String password) {
        Objects.requireNonNull(token, "token");
        Preconditions.checkArgument((!Objects.requireNonNull(password, "password").trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank password is required");
        User user = this.passwordResetHelper.findUserByToken(token);
        if (user == null) {
            throw new InvalidPasswordResetTokenException(this.i18nService.createKeyedMessage("bitbucket.service.invalidtoken", new Object[0]), token);
        }
        this.passwordResetHelper.resetPassword(user, password);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional(readOnly=true)
    public Page<DetailedUser> search(@Nonnull PageRequest request, @Nonnull DetailedUserSearchRequest searchRequest) {
        Set filteredUsers;
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(searchRequest, "searchRequest");
        request = request.buildRestrictedPageRequest(this.maxUserPageSize);
        List directories = this.crowdControl.listDirectories();
        CrowdUserSearchRequest crowdUserSearchRequest = this.buildCrowdUserSearchRequest(searchRequest, directories);
        Set<String> usersWithLicensedStatus = this.licensedUserCache.getUsernames();
        Stream<String> stream = MoreStreams.streamIterable((Iterable)this.crowdControl.findUsernames(crowdUserSearchRequest));
        Optional licenseStatus = searchRequest.getLicenseStatus();
        if (licenseStatus.isPresent()) {
            LicenseStatus status = (LicenseStatus)licenseStatus.get();
            stream = stream.filter(user -> status == LicenseStatus.LICENSED == usersWithLicensedStatus.contains(IdentifierUtils.toLowerCase((String)user)));
        }
        if ((filteredUsers = (Set)stream.skip(request.getStart()).limit(request.getLimit() + 1).collect(MoreCollectors.toImmutableSet())).isEmpty()) {
            return PageUtils.createEmptyPage((PageRequest)request);
        }
        List<DetailedUser> results = this.convertToDetailedUser(this.userHelper.transformOrCreate(this.crowdControl.findUsersWithAttributes((Collection)filteredUsers)), directories, usersWithLicensedStatus, licenseStatus);
        return PageUtils.createPage(results, (PageRequest)request);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void streamUsers(@Nonnull DetailedUserCallback callback, @Nonnull DetailedUserSearchRequest detailedUserSearchRequest) {
        Objects.requireNonNull(callback, "callback");
        Objects.requireNonNull(detailedUserSearchRequest, "detailedUserSearchRequest");
        boolean callEnd = false;
        try (Stream userStream = PageUtils.toStream(request -> this.search(request, detailedUserSearchRequest), (int)this.maxUserPageSize);){
            callback.onStart();
            callEnd = true;
            userStream.forEach(arg_0 -> ((DetailedUserCallback)callback).onUser(arg_0));
            callEnd = false;
            callback.onEnd();
        }
        catch (RuntimeException e) {
            log.error("Exception while streaming users", (Throwable)e);
            if (callEnd) {
                try {
                    callback.onEnd();
                }
                catch (RuntimeException suppressed) {
                    e.addSuppressed(suppressed);
                }
            }
            throw e;
        }
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#username, 'SYS_ADMIN'))")
    public void updatePassword(@Nonnull String username, @Nonnull String newPassword) {
        Objects.requireNonNull(username, "username");
        Preconditions.checkArgument((!Objects.requireNonNull(newPassword, "newPassword").trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank password is required");
        this.passwordResetHelper.resetPassword(this.crowdControl.getUser(username), newPassword);
    }

    @Nonnull
    @Transactional
    @Unsecured(value="This should only ever be called by plugins")
    public InternalServiceUser updateServiceUser(@Nonnull ServiceUserUpdateRequest request) {
        Objects.requireNonNull(request, "request");
        InternalApplicationUser user = (InternalApplicationUser)this.userDao.getById((Object)request.getId());
        if (user == null || user.getType() != UserType.SERVICE) {
            throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.service.user.nosuchserviceuser", new Object[]{request.getId()}), String.valueOf(request.getId()));
        }
        InternalServiceUser.Builder builder = new InternalServiceUser.Builder((InternalServiceUser)user.accept((InternalStashUserVisitor)InternalServiceUser.TO_SERVICE_USER)).active(request.isActive()).displayName(request.getDisplayName()).label(request.getLabel());
        if (request.getName() != null) {
            builder.name(request.getName());
        }
        return this.userDao.update(builder.build());
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#username, 'SYS_ADMIN'))")
    public InternalDetailedUser updateUser(@Nonnull String username, @Nonnull String displayName, @Nonnull String emailAddress) {
        Preconditions.checkArgument((!Objects.requireNonNull(displayName, "displayName").trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank display name is required");
        Preconditions.checkArgument((!Objects.requireNonNull(emailAddress, "emailAddress").trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank e-mail address is required");
        Objects.requireNonNull(username, "username");
        User user = this.crowdControl.getUser(username);
        user = this.crowdControl.updateUser((User)ImmutableUser.newUser((User)user).displayName(displayName).emailAddress(emailAddress).toUser());
        return this.transformOrCreateUser(user);
    }

    @DefaultApplicationMode
    @Transactional
    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        this.schedule(schedulerService, new GroupCleanUpJob(), GROUP_CLEANUP_JOB_RUNNER_KEY, GROUP_CLEANUP_JOB_ID, RunMode.RUN_ONCE_PER_CLUSTER, this.groupCleanupJobInterval);
        this.schedule(schedulerService, new UserCleanupJob(), USER_CLEANUP_JOB_RUNNER_KEY, USER_CLEANUP_JOB_ID, RunMode.RUN_ONCE_PER_CLUSTER, this.userCleanupJobInterval);
    }

    @Transactional
    public void unschedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.unregisterJobRunner(GROUP_CLEANUP_JOB_RUNNER_KEY);
        schedulerService.unregisterJobRunner(USER_CLEANUP_JOB_RUNNER_KEY);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void validateErasable(@Nonnull String username) {
        Objects.requireNonNull(username, "username");
        if (this.crowdControl.findUser(Objects.requireNonNull(username, "username"), true) != null) {
            throw new IllegalUserStateException(this.i18nService.createKeyedMessage("bitbucket.service.user.notdeleted", new Object[]{username}));
        }
        if (this.userDao.findByName(username) == null) {
            throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.service.user.notexists", new Object[]{username}), username);
        }
    }

    private void addToGroupIfExisting(User user, String groupName) {
        Group group = this.crowdControl.findGroup(groupName);
        if (group != null) {
            this.licenseService.validateCanAddUserToGroup(user.getName(), groupName);
            this.crowdControl.addGroupMember(group, user);
        }
    }

    private long calculateDuration(long startTime) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
    }

    private void doAddUserToGroup(@Nonnull String username, @Nonnull String groupName) {
        Objects.requireNonNull(username, "username");
        Objects.requireNonNull(groupName, "groupName");
        this.permissionAdminService.canAddUserToGroup(groupName);
        this.licenseService.validateCanAddUserToGroup(username, groupName);
        Group group = this.crowdControl.getGroup(groupName);
        User user = this.crowdControl.getUser(username);
        this.crowdControl.addGroupMember(group, user);
    }

    private void createUser(User user, String password, boolean addToDefaultGroup) {
        this.crowdControl.createUser(user, password);
        if (addToDefaultGroup) {
            this.addToGroupIfExisting(user, "stash-users");
        }
    }

    private boolean isAllowedInAnyDirectory(OperationType type) {
        List directories = this.crowdControl.listDirectories();
        for (Directory directory : directories) {
            if (!directory.isActive() || !directory.getAllowedOperations().contains(type)) continue;
            return true;
        }
        return false;
    }

    private void schedule(SchedulerService schedulerService, JobRunner runner, JobRunnerKey jobRunnerKey, JobId jobId, RunMode runMode, long intervalInMinutes) throws SchedulerServiceException {
        long interval = TimeUnit.MINUTES.toMillis(intervalInMinutes);
        schedulerService.registerJobRunner(jobRunnerKey, runner);
        schedulerService.scheduleJob(jobId, JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withRunMode(runMode).withSchedule(Schedule.forInterval((long)interval, (Date)new Date(System.currentTimeMillis() + interval))));
    }

    private Page<DetailedGroup> transformGroups(Page<String> page) {
        return page.transform((Function)new DetailedGroupTransform(this.canDeleteGroups()));
    }

    private InternalDetailedUser transformOrCreateUser(User user) {
        return this.transformUser((InternalApplicationUser)this.userHelper.transformOrCreate(user));
    }

    private Page<DetailedUser> transformOrCreateUsers(Page<User> page) {
        return this.userHelper.transformOrCreate(page).transform((Function)new DetailedUserTransform());
    }

    private InternalDetailedUser transformUser(InternalApplicationUser user) {
        final InternalDetailedUser.Builder builder = new InternalDetailedUser.Builder(user);
        user.accept((InternalStashUserVisitor)new AbstractVoidInternalStashUserVisitor(){

            protected void doVisit(@Nonnull InternalNormalUser user) {
                UserWithAttributes attributes;
                Directory directory = DefaultUserAdminService.this.crowdControl.findDirectoryFor(user.getBackingCrowdUser());
                if (directory != null) {
                    Set operations = directory.getAllowedOperations();
                    builder.directoryName(directory.getName()).deletable(operations.contains(OperationType.DELETE_USER)).mutableDetails(operations.contains(OperationType.UPDATE_USER)).mutableGroups(operations.contains(OperationType.UPDATE_GROUP));
                }
                if ((attributes = DefaultUserAdminService.this.crowdControl.findUserWithAttributes(user.getUsername())) != null) {
                    String lastAuthenticatedTimestamp;
                    if (attributes instanceof TimestampedUser) {
                        TimestampedUser timestampedUser = (TimestampedUser)attributes;
                        builder.createdTimestamp(timestampedUser.getCreatedDate());
                    }
                    if ((lastAuthenticatedTimestamp = attributes.getValue("lastAuthenticationTimestamp")) != null) {
                        try {
                            builder.lastAuthenticationTimestamp(new Date(Long.parseLong(lastAuthenticatedTimestamp)));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        return builder.build();
    }

    private InternalNormalUser renameUserForErasure(@Nonnull String username) {
        return (InternalNormalUser)this.requiresNewTransactionTemplate.execute(status -> {
            InternalNormalUser renamedUser;
            this.validateErasable(username);
            InternalNormalUser user = this.userDao.findByName(username);
            String newIdentifier = this.userErasureIdentifierGenerator.getIdentifier();
            if (user.getDeletedDate() != null) {
                this.eventPublisher.publish((Object)new UserCleanupEvent((Object)this, (ApplicationUser)user.copy().build()));
                InternalNormalUser updatedUser = user.copy().deletedDate(null).build();
                this.userDao.update((Object)updatedUser);
            }
            if ((renamedUser = this.userDao.rename(username, newIdentifier)) == null) {
                throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.service.user.notexists", new Object[]{username}), username);
            }
            return renamedUser;
        });
    }

    @VisibleForTesting
    void cleanupDeletedGroups() {
        final Date date = Date.from(this.clock.instant().minus(Duration.ofMinutes(this.groupCleanupJobDelay)));
        final PageRequest request = PageUtils.newRequest((int)0, (int)this.groupCleanupJobBatchSize);
        boolean hasMore = true;
        while (hasMore) {
            hasMore = (Boolean)this.requiresNewTransactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

                public Boolean doInTransaction(TransactionStatus status) {
                    Page deletedGroups = DefaultUserAdminService.this.deletedGroupDao.findByDeletedDateEarlierThan(date, request);
                    for (InternalDeletedGroup deletedGroup : deletedGroups.getValues()) {
                        DefaultUserAdminService.this.cleanupDeletedGroup(deletedGroup);
                    }
                    return !deletedGroups.getIsLastPage();
                }
            });
        }
    }

    private void cleanupDeletedGroup(InternalDeletedGroup deletedGroup) {
        if (this.crowdControl.findGroup(deletedGroup.getName()) == null) {
            this.eventPublisher.publish((Object)new GroupCleanupEvent((Object)this, deletedGroup.getName()));
        }
        this.deletedGroupDao.delete((Object)deletedGroup);
    }

    @VisibleForTesting
    void cleanupDeletedUsers() {
        final Date date = Date.from(this.clock.instant().minus(Duration.ofMinutes(this.userCleanupJobDelay)));
        final PageRequest request = PageUtils.newRequest((int)0, (int)this.userCleanupJobBatchSize);
        boolean hasMore = true;
        while (hasMore) {
            hasMore = (Boolean)this.requiresNewTransactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

                public Boolean doInTransaction(TransactionStatus status) {
                    Page users = DefaultUserAdminService.this.userDao.findByDeletedDateEarlierThan(date, request);
                    log.debug("Purging {}{} users that have been removed before '{}'", new Object[]{users.getSize(), users.getIsLastPage() ? "" : "+", date});
                    for (InternalNormalUser user : users.getValues()) {
                        DefaultUserAdminService.this.cleanupDeletedUser(user);
                    }
                    return !users.getIsLastPage();
                }
            });
        }
    }

    private void cleanupDeletedUser(InternalNormalUser user) {
        if (!user.isCrowdBacked()) {
            this.eventPublisher.publish((Object)new UserCleanupEvent((Object)this, (ApplicationUser)user.copy().build()));
        }
        InternalNormalUser updatedUser = user.copy().deletedDate(null).build();
        this.userDao.update((Object)updatedUser);
    }

    private CrowdUserSearchRequest buildCrowdUserSearchRequest(DetailedUserSearchRequest searchRequest, List<Directory> directories) {
        Long lastActiveAfter = searchRequest.getLastActiveAfter().orElse(null);
        Long lastActiveBefore = searchRequest.getLastActiveBefore().orElse(null);
        if (lastActiveAfter != null && lastActiveBefore != null && lastActiveBefore <= lastActiveAfter) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.user.search.invalid.lastactivebefore", new Object[]{lastActiveBefore, lastActiveAfter}));
        }
        CrowdUserSearchRequest.Builder builder = new CrowdUserSearchRequest.Builder().userFilterText((String)searchRequest.getFilterText().orElse(null)).lastActiveAfter(lastActiveAfter).lastActiveBefore(lastActiveBefore);
        searchRequest.getDirectoryName().ifPresent(directoryName -> {
            Optional<Directory> directory = directories.stream().filter(dir -> dir.getName().equalsIgnoreCase((String)directoryName)).findFirst();
            directory.map(dir -> builder.directoryId(dir.getId())).orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.user.search.invalid.directory", new Object[]{directoryName})));
        });
        return builder.build();
    }

    private List<DetailedUser> convertToDetailedUser(Iterable<InternalNormalUser> users, List<Directory> directories, Set<String> usersWithLicensedStatus, Optional<LicenseStatus> licenseStatus) {
        ImmutableMap directoryMap = Maps.uniqueIndex(directories, Directory::getId);
        return MoreStreams.streamIterable(users).map(arg_0 -> DefaultUserAdminService.lambda$convertToDetailedUser$10((Map)directoryMap, licenseStatus, usersWithLicensedStatus, arg_0)).collect(Collectors.toList());
    }

    private static /* synthetic */ InternalDetailedUser lambda$convertToDetailedUser$10(Map directoryMap, Optional licenseStatus, Set usersWithLicensedStatus, InternalNormalUser user) {
        User backingUser;
        InternalDetailedUser.Builder builder = new InternalDetailedUser.Builder((InternalApplicationUser)user);
        long directoryId = user.getBackingCrowdUser().getDirectoryId();
        Directory directory = (Directory)directoryMap.get(directoryId);
        if (directory != null) {
            Set operations = directory.getAllowedOperations();
            builder.directoryName(directory.getName()).deletable(operations.contains(OperationType.DELETE_USER)).mutableDetails(operations.contains(OperationType.UPDATE_USER)).mutableGroups(operations.contains(OperationType.UPDATE_GROUP));
        }
        if ((backingUser = user.getBackingCrowdUser()) instanceof UserWithAttributes) {
            String value;
            UserWithAttributes attributes = (UserWithAttributes)backingUser;
            if (attributes instanceof TimestampedUser) {
                TimestampedUser timestampedUser = (TimestampedUser)attributes;
                builder.createdTimestamp(timestampedUser.getCreatedDate());
            }
            if ((value = attributes.getValue("lastAuthenticationTimestamp")) != null) {
                try {
                    builder.lastAuthenticationTimestamp(new Date(Long.parseLong(value)));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (backingUser != null) {
            log.debug("User {} is not an instance of UserWithAttributes", (Object)user.getName());
        }
        licenseStatus.map(status -> (InternalDetailedUser.Builder)builder.property(LICENSE_STATUS_PROPERTY, status)).orElseGet(() -> (InternalDetailedUser.Builder)builder.property(LICENSE_STATUS_PROPERTY, (Object)(usersWithLicensedStatus.contains(IdentifierUtils.toLowerCase((String)user.getName())) ? LicenseStatus.LICENSED : LicenseStatus.UNLICENSED)));
        return builder.build();
    }

    private class GroupCleanUpJob
    implements JobRunner {
        private GroupCleanUpJob() {
        }

        @Nullable
        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
            DefaultUserAdminService.this.cleanupDeletedGroups();
            return JobRunnerResponse.success();
        }
    }

    private class UserCleanupJob
    implements JobRunner {
        private UserCleanupJob() {
        }

        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            DefaultUserAdminService.this.cleanupDeletedUsers();
            DefaultUserAdminService.this.tombstoneCleanupService.cleanupExpiredTombstones();
            return JobRunnerResponse.success();
        }
    }

    private static class DetailedGroupTransform
    implements Function<String, DetailedGroup> {
        private final InternalDetailedGroup.Builder builder;

        private DetailedGroupTransform(boolean deletable) {
            this.builder = new InternalDetailedGroup.Builder().deletable(deletable);
        }

        @Override
        public DetailedGroup apply(String group) {
            return this.builder.name(group).build();
        }
    }

    private class DetailedUserTransform
    implements Function<InternalApplicationUser, DetailedUser> {
        private DetailedUserTransform() {
        }

        @Override
        public DetailedUser apply(InternalApplicationUser user) {
            return DefaultUserAdminService.this.transformUser(user);
        }
    }
}

