/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.stash.internal.user.ApplicationUserDao;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.UserHelper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.security.Principal;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="userHelper")
public class DefaultUserHelper
implements UserHelper {
    private final ApplicationUserDao userDao;

    @Autowired
    public DefaultUserHelper(ApplicationUserDao userDao) {
        this.userDao = userDao;
    }

    @Nonnull
    public InternalNormalUser transformOrCreate(@Nonnull User user) {
        Objects.requireNonNull(user, "user");
        InternalNormalUser loaded = this.userDao.loadUser(user);
        if (loaded == null) {
            loaded = this.newStashUser(user);
        }
        return loaded;
    }

    @Nonnull
    public Page<InternalNormalUser> transformOrCreate(@Nonnull Page<User> page) {
        Objects.requireNonNull(page, "page");
        ImmutableMap stashUsers = Maps.uniqueIndex((Iterable)this.userDao.loadUsers(page.getValues()), Principal::getName);
        return page.transform(arg_0 -> this.lambda$transformOrCreate$0((Map)stashUsers, arg_0));
    }

    @Nonnull
    public Iterable<InternalNormalUser> transformOrCreate(@Nonnull Iterable<UserWithAttributes> users) {
        Objects.requireNonNull(users, "users");
        ImmutableMap stashUsers = Maps.uniqueIndex((Iterable)this.userDao.loadUsers(users), Principal::getName);
        return (Iterable)MoreStreams.streamIterable(users).map(arg_0 -> this.lambda$transformOrCreate$1((Map)stashUsers, arg_0)).collect(MoreCollectors.toImmutableList());
    }

    private InternalNormalUser newStashUser(@Nonnull User user) {
        return this.userDao.createFor(user);
    }

    private /* synthetic */ InternalNormalUser lambda$transformOrCreate$1(Map stashUsers, UserWithAttributes user) {
        InternalNormalUser loaded = (InternalNormalUser)stashUsers.get(user.getName());
        if (loaded == null) {
            loaded = this.newStashUser((User)user);
        }
        return loaded;
    }

    private /* synthetic */ InternalNormalUser lambda$transformOrCreate$0(Map stashUsers, User user) {
        InternalNormalUser loaded = (InternalNormalUser)stashUsers.get(user.getName());
        if (loaded == null) {
            loaded = this.newStashUser(user);
        }
        return loaded;
    }
}

