/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.user.UserMentionScanner;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import io.atlassian.util.concurrent.Lazy;
import jakarta.annotation.Nonnull;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.commonmark.node.Code;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Node;
import org.commonmark.node.SourceSpan;
import org.commonmark.parser.IncludeSourceSpans;
import org.commonmark.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=UserMentionScanner.class)
@Component(value="userMentionScanner")
public class DefaultUserMentionScanner
implements UserMentionScanner {
    private static final Predicate<Node> IS_CODE_SPAN = node -> node instanceof FencedCodeBlock || node instanceof IndentedCodeBlock || node instanceof Code;
    private static final int MATCHER_GROUP_HTML_QUOTES = 3;
    private static final int MATCHER_GROUP_NO_QUOTES = 1;
    private static final int MATCHER_GROUP_QUOTES = 2;
    private static final Pattern MENTION_PATTERN = Pattern.compile("(?x)\n(?<=\\n|\\s|^|\\(|\\[) # Only match if the pattern starts with either a newline, whitespace character start of string character, open parenthesis, or open square bracket\n@ # Mentions start with '@'\n(?:\n    ([\\w]+)(?!@) # Simple mentions, every word character and not followed by '@'\n    |\n    \"(.*?[^\\\\])\" # Quoted mentions, every character in quotes; the last character can not be a backslash\n    |\n    &quot;(.*?[^\\\\])&quot; # Html escaped quoted mentions, every character in &quot;\n)");
    private static final Parser PARSER = Parser.builder().includeSourceSpans(IncludeSourceSpans.BLOCKS_AND_INLINES).enabledBlockTypes(new HashSet<Class>(Arrays.asList(FencedCodeBlock.class, IndentedCodeBlock.class))).build();
    private static final Pattern WORD_CHARACTERS_ONLY_PATTERN = Pattern.compile("\\w*");
    private static final Logger log = LoggerFactory.getLogger(DefaultUserMentionScanner.class);

    @Nonnull
    public Set<String> getMentionedUsers(@Nonnull CharSequence text, int maxMentions) {
        Objects.requireNonNull(text, "text");
        if (text.length() == 0) {
            return Collections.emptySet();
        }
        HashSet users = Sets.newHashSetWithExpectedSize((int)3);
        DefaultUserMentionScanner.iterateUserMentions(text, userMention -> {
            if (users.size() >= maxMentions) {
                return;
            }
            users.add(userMention.getUsername());
            if (users.size() >= maxMentions) {
                log.debug("Max mentions of {} exceeded in comment: {}", (Object)maxMentions, (Object)this.abbreviate(text, 20));
            }
        });
        return users;
    }

    public void processMentions(@Nonnull CharSequence text, @Nonnull Consumer<UserMentionScanner.UserMention> callback) {
        Objects.requireNonNull(text, "text");
        Objects.requireNonNull(callback, "callback");
        DefaultUserMentionScanner.iterateUserMentions(text, callback);
    }

    @Nonnull
    public String renderMention(@Nonnull String username) {
        Objects.requireNonNull(username, "username");
        return "@" + DefaultUserMentionScanner.escapeUsername(username);
    }

    @Nonnull
    public Optional<CharSequence> replaceMentions(@Nonnull CharSequence text, @Nonnull Function<UserMentionScanner.UserMention, Optional<String>> replacementFunction) {
        Objects.requireNonNull(text, "text");
        Objects.requireNonNull(replacementFunction, "replacementFunction");
        StringBuilder result = new StringBuilder();
        MutableInt lastAppendPosition = new MutableInt();
        DefaultUserMentionScanner.iterateUserMentions(text, userMention -> {
            Optional optionalReplacement = (Optional)replacementFunction.apply((UserMentionScanner.UserMention)userMention);
            if (optionalReplacement.isPresent()) {
                result.append(text, lastAppendPosition.intValue(), userMention.getStart());
                result.append((String)optionalReplacement.get());
                lastAppendPosition.setValue(userMention.getEnd());
            }
        });
        if (lastAppendPosition.intValue() > 0) {
            result.append(text, lastAppendPosition.intValue(), text.length());
        }
        if (!result.isEmpty()) {
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private static String escapeUsername(String username) {
        if (WORD_CHARACTERS_ONLY_PATTERN.matcher(username).matches()) {
            return username;
        }
        return "\"" + username.replace("\"", "\\\"") + "\"";
    }

    private static String extractQuotedMentionGroup(MatchResult matcher) {
        return StringEscapeUtils.unescapeJava((String)((String)MoreObjects.firstNonNull((Object)matcher.group(2), (Object)StringEscapeUtils.unescapeHtml4((String)matcher.group(3)))));
    }

    private static SortedMap<Integer, SourceSpan> getCodeSpansIndexedByEndPosition(@Nonnull CharSequence text) {
        TreeMap<Integer, SourceSpan> sortedSpans = new TreeMap<Integer, SourceSpan>();
        Node document = PARSER.parse(text.toString());
        ArrayDeque<Node> nodeStack = new ArrayDeque<Node>();
        nodeStack.push(document);
        while (!nodeStack.isEmpty()) {
            Node node = (Node)nodeStack.pop();
            if (IS_CODE_SPAN.test(node)) {
                node.getSourceSpans().forEach(sourceSpan -> sortedSpans.put(sourceSpan.getInputIndex() + sourceSpan.getLength(), (SourceSpan)sourceSpan));
                continue;
            }
            for (Node child = node.getLastChild(); child != null; child = child.getPrevious()) {
                nodeStack.push(child);
            }
        }
        return sortedSpans;
    }

    private static String getFullUnescapedMention(MatchResult matcher) {
        String asciiGroup = matcher.group(1);
        return asciiGroup != null ? matcher.group() : "@\"" + DefaultUserMentionScanner.extractQuotedMentionGroup(matcher) + "\"";
    }

    private static String getMentionGroup(MatchResult matcher) {
        String asciiGroup = matcher.group(1);
        return asciiGroup != null ? asciiGroup : DefaultUserMentionScanner.extractQuotedMentionGroup(matcher);
    }

    private static boolean isWithinSourceSpans(SortedMap<Integer, SourceSpan> sourceSpans, int start) {
        Map.Entry previousSourceSpan = sourceSpans.tailMap(start).firstEntry();
        if (previousSourceSpan == null) {
            return false;
        }
        SourceSpan span = (SourceSpan)previousSourceSpan.getValue();
        return span.getInputIndex() <= start && start < (Integer)previousSourceSpan.getKey();
    }

    private static void iterateUserMentions(CharSequence text, Consumer<UserMentionScanner.UserMention> callback) {
        Objects.requireNonNull(text, "text");
        Objects.requireNonNull(callback, "callback");
        Supplier sourceSpans = Lazy.supplier(() -> DefaultUserMentionScanner.getCodeSpansIndexedByEndPosition(text));
        Matcher matcher = MENTION_PATTERN.matcher(text);
        while (matcher.find()) {
            if (DefaultUserMentionScanner.isWithinSourceSpans((SortedMap)sourceSpans.get(), matcher.start())) continue;
            callback.accept(DefaultUserMentionScanner.toUserMention(matcher.toMatchResult()));
        }
    }

    private static UserMentionScanner.UserMention toUserMention(MatchResult result) {
        return new RegexUserMention(result);
    }

    private CharSequence abbreviate(CharSequence text, int maxCharacters) {
        return text.length() <= maxCharacters ? text : String.valueOf(text.subSequence(0, maxCharacters - 3)) + "...";
    }

    private static class RegexUserMention
    implements UserMentionScanner.UserMention {
        private final int end;
        private final String fullMention;
        private final String fullUnescapedMention;
        private final int start;
        private final String username;

        RegexUserMention(MatchResult result) {
            this.end = result.end();
            this.fullUnescapedMention = DefaultUserMentionScanner.getFullUnescapedMention(result);
            this.fullMention = result.group();
            this.username = DefaultUserMentionScanner.getMentionGroup(result);
            this.start = result.start();
        }

        public int getEnd() {
            return this.end;
        }

        @Nonnull
        public String getFullMention() {
            return this.fullMention;
        }

        @Nonnull
        public String getFullUnescapedMention() {
            return this.fullUnescapedMention;
        }

        public int getStart() {
            return this.start;
        }

        @Nonnull
        public String getUsername() {
            return this.username;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("end", this.end).add("fullMention", (Object)this.fullUnescapedMention).add("username", (Object)this.username).add("start", this.start).toString();
        }
    }
}

