/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.avatar.AvatarSupplier;
import com.atlassian.bitbucket.avatar.CacheableAvatarSupplier;
import com.atlassian.bitbucket.event.user.UserAvatarUpdatedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionRequest;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.UserSearchRequest;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.avatar.DataUriAvatarMetaSupplier;
import com.atlassian.stash.internal.avatar.InternalAvatarService;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.user.ApplicationUserDao;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalAuthenticationContext;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalPermissionService;
import com.atlassian.stash.internal.user.InternalServiceUser;
import com.atlassian.stash.internal.user.InternalStashUserVisitor;
import com.atlassian.stash.internal.user.InternalUserService;
import com.atlassian.stash.internal.user.PasswordResetHelper;
import com.atlassian.stash.internal.user.UserHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Pair;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(interfaces={UserService.class})
@DependsOn(value={"createSystemUserUpgradeTask"})
@Service(value="userService")
public class DefaultUserService
extends AbstractService
implements InternalUserService {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserService.class);
    private final InternalAuthenticationContext authenticationContext;
    private final InternalAvatarService avatarService;
    private final boolean checkRemoteDirectory;
    private final CrowdControl crowdControl;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final Cache<Pair<Long, String>, Boolean> isUserActive;
    private final PasswordResetHelper passwordResetHelper;
    private final InternalPermissionService permissionService;
    private final ApplicationUserDao userDao;
    private final UserHelper userHelper;
    private volatile ServiceUser systemServiceUser;
    @Value(value="${page.max.groups}")
    private int maxGroupPageSize;
    @Value(value="${page.max.users}")
    private int maxUserPageSize;

    @Autowired
    public DefaultUserService(@Lazy InternalAvatarService avatarService, InternalAuthenticationContext authenticationContext, CacheFactory cacheFactory, CrowdControl crowdControl, EventPublisher eventPublisher, FeatureManager featureManager, I18nService i18nService, PasswordResetHelper passwordResetHelper, @Lazy InternalPermissionService permissionService, ApplicationUserDao userDao, UserHelper userHelper, @Value(value="${auth.remote.cache.cacheSize}") int cacheSize, @Value(value="${auth.remote.cache.ttl}") int cacheTtl, @Value(value="${auth.remote.enabled}") boolean checkRemoteDirectory) {
        this.avatarService = avatarService;
        this.authenticationContext = authenticationContext;
        this.checkRemoteDirectory = checkRemoteDirectory;
        this.crowdControl = crowdControl;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.passwordResetHelper = passwordResetHelper;
        this.permissionService = permissionService;
        this.userDao = userDao;
        this.userHelper = userHelper;
        this.isUserActive = cacheFactory.getCache("bb.internal.isUserActive", null, new CacheSettingsBuilder().local().maxEntries(cacheSize).expireAfterWrite((long)cacheTtl, TimeUnit.SECONDS).build());
    }

    @PreAuthorize(value="hasUserPermission(#user, 'USER_ADMIN')")
    public void deleteAvatar(@Nonnull ApplicationUser user) {
        this.avatarService.deleteForUser(Objects.requireNonNull(user, "user"));
    }

    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public boolean existsGroup(String groupName) {
        return this.crowdControl.findGroup(groupName) != null;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<String> findGroups(@Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxGroupPageSize);
        return this.crowdControl.findGroups(pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<String> findGroupsByName(String groupName, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxGroupPageSize);
        return this.crowdControl.findGroupsByName(DefaultUserService.stripAndRemoveNulls(groupName), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<String> findGroupsByPrefix(String groupPrefix, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxGroupPageSize);
        return this.crowdControl.findGroupsByPrefix(DefaultUserService.stripAndRemoveNulls(groupPrefix), pageRequest);
    }

    @Nonnull
    @Unsecured(value="Used in unauthenticated contexts by licensing, permission checks and login processing")
    public Page<String> findGroupsByUser(@Nonnull String username, @Nonnull PageRequest pageRequest) {
        return this.crowdControl.findGroupsByUser(username, null, false, pageRequest).transform(IdentifierUtils::toLowerCase);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public Page<ServiceUser> findServiceUsersByName(String displayName, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return PageUtils.asPageOf(ServiceUser.class, (Page)this.userDao.findServiceUsersByDisplayName(displayName, pageRequest));
    }

    @Transactional
    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public ApplicationUser findUserByEmail(@Nonnull String email) {
        Objects.requireNonNull(email, "email");
        User user = this.crowdControl.findUserByProperty(UserTermKeys.EMAIL, (Object)email);
        if (user != null) {
            return this.getOrCreateMappedUser(user);
        }
        return null;
    }

    @Transactional
    @Unsecured(value="This needs to be available in unauthenticated contexts; it is used for password resets")
    public ApplicationUser findUserByNameOrEmail(@Nonnull String value) {
        ApplicationUser user;
        if (Objects.requireNonNull(value, "value").contains("@") && (user = this.findUserByEmail(value)) != null) {
            return user;
        }
        return this.userDao.findByName(value);
    }

    @Nonnull
    @Unsecured(value="Used in unauthenticated contexts by licensing, permission checks and login processing")
    public Page<String> findUsernamesByGroups(@Nonnull Set<String> groupNames, @Nonnull PageRequest pageRequest) {
        return this.crowdControl.findUsernamesByGroups(groupNames, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public Page<ApplicationUser> findUsers(@Nonnull PageRequest pageRequest) {
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxUserPageSize);
        return PageUtils.asPageOf(ApplicationUser.class, (Page)this.userHelper.transformOrCreate(this.crowdControl.findUsers(pageRequest)));
    }

    @Nonnull
    @Unsecured(value="Used in unauthenticated contexts by licensing, permission checks and login processing")
    public Page<ApplicationUser> findUsersByGroup(@Nonnull String groupName, @Nonnull PageRequest pageRequest) {
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxUserPageSize);
        return PageUtils.asPageOf(ApplicationUser.class, (Page)this.userHelper.transformOrCreate(this.crowdControl.findUsersByGroup(groupName, null, false, pageRequest)));
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public Page<ApplicationUser> findUsersByName(String username, @Nonnull PageRequest pageRequest) {
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxUserPageSize);
        return PageUtils.asPageOf(ApplicationUser.class, (Page)this.userHelper.transformOrCreate(this.crowdControl.findUsersByName(username, pageRequest)));
    }

    @Nonnull
    @Unsecured(value="User avatars are not more privileged than getUserBySlug(String)")
    public CacheableAvatarSupplier getAvatar(@Nonnull ApplicationUser user, int size) {
        Objects.requireNonNull(user, "user");
        return this.avatarService.getForUser(user, size);
    }

    @Nonnull
    @Unsecured(value="Used in unauthenticated contexts by licensing, permission checks and login processing")
    public Iterable<String> getGroupsByUser(@Nonnull String username) {
        return this.crowdControl.getGroupsByUser(username);
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public ServiceUser getServiceUserByName(@Nonnull String username) {
        return this.getServiceUserByName(username, false);
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public ServiceUser getServiceUserByName(@Nonnull String username, boolean inactive) {
        return this.userDao.findServiceUserByName(Objects.requireNonNull(username, "username"), inactive);
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public ServiceUser getServiceUserBySlug(@Nonnull String slug) {
        return this.userDao.findServiceUserBySlug(Objects.requireNonNull(slug, "slug"));
    }

    @Nonnull
    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public Set<ServiceUser> getServiceUsersByName(@Nonnull Set<String> usernames) {
        return this.getServiceUsersByName(usernames, false);
    }

    @Nonnull
    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public Set<ServiceUser> getServiceUsersByName(@Nonnull Set<String> usernames, boolean inactive) {
        return this.maybeFilterInactive((InternalApplicationUser)this.userDao.findServiceUsersByName(Objects.requireNonNull(usernames, "usernames")), inactive);
    }

    @Nonnull
    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public ServiceUser getSystemServiceUser() {
        if (this.systemServiceUser == null) {
            this.systemServiceUser = this.fetchSystemServiceUser();
        }
        return this.systemServiceUser;
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public ApplicationUser getUserById(int id) {
        return this.getUserById(id, false);
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public ApplicationUser getUserById(int id, boolean inactive) {
        return this.maybeFilterInactive((InternalApplicationUser)this.userDao.getById((Object)id), inactive);
    }

    public ApplicationUser getUserByKey(UserKey key) {
        return this.getUserByKey(key, false);
    }

    public ApplicationUser getUserByKey(UserKey key, boolean inactive) {
        if (key == null) {
            return null;
        }
        try {
            return this.getUserById(Integer.parseInt(key.getStringValue()), inactive);
        }
        catch (NumberFormatException e) {
            return this.getUserByName(key.getStringValue(), inactive);
        }
    }

    @Transactional
    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public ApplicationUser getUserByName(@Nonnull String username) {
        return this.getUserByName(username, false);
    }

    @Transactional
    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public ApplicationUser getUserByName(@Nonnull String username, boolean inactive) {
        ApplicationUser currentUser;
        String lowercasedName = IdentifierUtils.toLowerCase((String)Objects.requireNonNull(username, "username"));
        if (this.authenticationContext.isAuthenticated() && lowercasedName.equals((currentUser = this.authenticationContext.getCurrentUser()).getName())) {
            return currentUser;
        }
        return this.maybeFilterInactive(this.userDao.findByName(username), inactive);
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public ApplicationUser getUserBySlug(@Nonnull String slug) {
        ApplicationUser currentUser;
        String lowercasedSlug = IdentifierUtils.toLowerCase((String)Objects.requireNonNull(slug, "slug"));
        if (this.authenticationContext.isAuthenticated() && lowercasedSlug.equals((currentUser = this.authenticationContext.getCurrentUser()).getSlug())) {
            return currentUser;
        }
        return this.maybeFilterInactive(this.userDao.findBySlug(slug), false);
    }

    @Nonnull
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public Set<ApplicationUser> getUsersById(@Nonnull Set<Integer> ids) {
        return this.getUsersById(ids, false);
    }

    @Nonnull
    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public Set<ApplicationUser> getUsersById(@Nonnull Set<Integer> ids, boolean inactive) {
        return this.maybeFilterInactive((InternalApplicationUser)this.userDao.getByIds(ids), inactive);
    }

    @Nonnull
    @Unsecured(value="Should be on the same level of permission as getUserByName(String)")
    public Set<ApplicationUser> getUsersByName(@Nonnull Set<String> usernames) {
        return this.getUsersByName(usernames, false);
    }

    @Nonnull
    @Unsecured(value="Should be on the same level of permission as getUserByName(String)")
    public Set<ApplicationUser> getUsersByName(@Nonnull Set<String> usernames, boolean inactive) {
        Objects.requireNonNull(usernames, "usernames");
        return this.maybeFilterInactive((InternalApplicationUser)this.userDao.findByNames(usernames), inactive);
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public boolean isUserActive(@Nonnull ApplicationUser user) {
        return this.isUserActive(user, this.checkRemoteDirectory);
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public boolean isUserActive(@Nonnull ApplicationUser user, boolean checkDirectory) {
        Objects.requireNonNull(user, "user");
        InternalNormalUser normalUser = InternalNormalUser.fromUser((ApplicationUser)user).orElse(null);
        if (normalUser == null || !checkDirectory) {
            log.debug("{}: Skipping remote active check (Active: {}; Enabled: {})", new Object[]{user.getName(), user.isActive(), checkDirectory});
            return user.isActive();
        }
        return this.isUserActive(normalUser.getBackingCrowdUser());
    }

    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public boolean isUserInGroup(@Nonnull ApplicationUser user, final @Nonnull String groupName) {
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(groupName, "groupName");
        InternalApplicationUser internalUser = InternalConverter.convertToInternalUser((ApplicationUser)user);
        return (Boolean)internalUser.accept((InternalStashUserVisitor)new InternalStashUserVisitor<Boolean>(){

            public Boolean visit(@Nonnull InternalNormalUser user) {
                User crowdUser = user.getBackingCrowdUser();
                if (crowdUser == null && (crowdUser = DefaultUserService.this.crowdControl.findUser(user.getUsername(), true)) == null) {
                    return false;
                }
                return DefaultUserService.this.crowdControl.isGroupMember(groupName, crowdUser);
            }

            public Boolean visit(@Nonnull InternalServiceUser user) {
                return false;
            }
        });
    }

    @Unsecured(value="This is not restricted by permissions so that SAL tests pass. It should not be exposed via REST")
    public boolean isUserInGroup(@Nonnull String username, @Nonnull String groupName) {
        Objects.requireNonNull(username, "username");
        Objects.requireNonNull(groupName, "groupName");
        ApplicationUser user = this.getUserByName(username);
        return user != null && this.isUserInGroup(user, groupName);
    }

    @Nonnull
    @Transactional
    @Unsecured(value="This should not be more private than findUserByNameOrEmail")
    public Map<String, ApplicationUser> mapUsersByEmail(@Nonnull Set<String> emailAddresses) {
        HashMap usersByEmail = Maps.newHashMapWithExpectedSize((int)emailAddresses.size());
        for (String emailAddress : emailAddresses) {
            ApplicationUser user = this.findUserByEmail(emailAddress);
            if (user == null) continue;
            usersByEmail.put(emailAddress, user);
        }
        return usersByEmail;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<ApplicationUser> search(@Nonnull UserSearchRequest request, @Nonnull PageRequest pageRequest) {
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxUserPageSize);
        String username = Objects.requireNonNull(request, "request").getFilter();
        String groupName = request.getGroup();
        PageProvider userProvider = groupName == null ? nextPage -> this.crowdControl.findUsersByName(username, nextPage) : nextPage -> this.crowdControl.findUsersByGroup(groupName, username, false, nextPage);
        PageProvider applicationUserProvider = nextPage -> PageUtils.asPageOf(ApplicationUser.class, (Page)this.userHelper.transformOrCreate(userProvider.get(nextPage)));
        Set permissions = request.getPermissions();
        if (permissions.isEmpty()) {
            return applicationUserProvider.get(pageRequest);
        }
        this.validatePermissions(permissions);
        return this.filterPages((PageProvider<ApplicationUser>)applicationUserProvider, DefaultUserService.filterAndSortPermissionRequests(permissions), pageRequest);
    }

    @PreAuthorize(value="hasUserPermission(#user, 'USER_ADMIN')")
    public void updateAvatar(@Nonnull ApplicationUser user, @Nonnull AvatarSupplier supplier) {
        Objects.requireNonNull(supplier, "supplier");
        this.doUpdateAvatar(user, () -> supplier);
    }

    @PreAuthorize(value="hasUserPermission(#user, 'USER_ADMIN')")
    public void updateAvatar(@Nonnull ApplicationUser user, @Nonnull String uri) {
        Preconditions.checkArgument((!Objects.requireNonNull(uri, "uri").trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank data URI is required");
        this.doUpdateAvatar(user, new DataUriAvatarMetaSupplier(this.avatarService, uri));
    }

    @Transactional
    @Unsecured(value="Internal service method")
    public void updateLastAuthentication(@Nonnull String username) {
        User user = this.crowdControl.findUser(username, false);
        if (user != null) {
            this.crowdControl.setUserAttribute(user, "lastAuthenticationTimestamp", (Object)System.currentTimeMillis());
        }
    }

    @Transactional
    @PreAuthorize(value="hasUserPermission('USER_ADMIN')")
    public void updatePassword(@Nonnull String currentPassword, @Nonnull String newPassword) {
        User user = this.crowdControl.updatePassword(this.getCurrentUserForUpdate().getName(), currentPassword, newPassword);
        this.passwordResetHelper.clearToken(user);
    }

    @Nonnull
    @PreAuthorize(value="hasUserPermission('USER_ADMIN')")
    @Transactional
    public ApplicationUser updateUser(@Nonnull String displayName, @Nonnull String email, @Nullable String currentPassword) {
        boolean needsPasswordCheck;
        Objects.requireNonNull(displayName, "displayName");
        Objects.requireNonNull(email, "email");
        ApplicationUser currentUser = this.getCurrentUserForUpdate();
        String username = currentUser.getName();
        boolean bl = needsPasswordCheck = this.featureManager.isEnabled((Feature)StandardFeature.ENFORCE_PASSWORD_USER_EMAIL_UPDATE) && !email.equals(currentUser.getEmailAddress());
        if (needsPasswordCheck && currentPassword == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.user.email.update.password.required", new Object[0]));
        }
        if (currentPassword != null || needsPasswordCheck) {
            this.crowdControl.checkPassword(username, currentPassword);
        }
        User user = this.crowdControl.updateUser((User)ImmutableUser.newUser().name(username).displayName(displayName).emailAddress(email).toUser());
        return this.userHelper.transformOrCreate(user);
    }

    private static List<PermissionRequest> filterAndSortPermissionRequests(Set<PermissionRequest> permissionRequests) {
        ArrayList<PermissionRequest> sortedRequests = new ArrayList<PermissionRequest>(permissionRequests);
        sortedRequests.sort(Comparator.comparingInt(request -> request.getPermission().getWeight()).reversed());
        Permission highestGlobalPermission = null;
        Set inheritedPermissions = Collections.emptySet();
        Iterator iterator = sortedRequests.iterator();
        while (iterator.hasNext()) {
            Permission permission = ((PermissionRequest)iterator.next()).getPermission();
            if (permission.isGlobal() && highestGlobalPermission == null) {
                highestGlobalPermission = permission;
                inheritedPermissions = permission.getInheritedPermissions();
                continue;
            }
            if (!inheritedPermissions.contains(permission)) continue;
            iterator.remove();
        }
        return sortedRequests;
    }

    private static String stripAndRemoveNulls(String value) {
        return StringUtils.stripToNull((String)StringUtils.replace((String)value, (String)"\u0000", (String)""));
    }

    private static Predicate<ApplicationUser> userFilter(boolean inactive) {
        Predicate<ApplicationUser> filter = Objects::nonNull;
        return inactive ? filter : filter.and(ApplicationUser::isActive);
    }

    private void doUpdateAvatar(@Nonnull ApplicationUser user, @Nonnull Supplier<AvatarSupplier> metaSupplier) {
        this.avatarService.saveForUser(Objects.requireNonNull(user, "user"), Objects.requireNonNull(metaSupplier, "metaSupplier").get());
        this.eventPublisher.publish((Object)new UserAvatarUpdatedEvent((Object)this, user));
    }

    private ServiceUser fetchSystemServiceUser() {
        InternalServiceUser serviceUser = this.userDao.findServiceUserByName("bitbucket.system-user", false);
        if (serviceUser == null) {
            throw new IllegalStateException("System service user does not exist.");
        }
        return serviceUser;
    }

    private Page<ApplicationUser> filterPages(PageProvider<ApplicationUser> provider, List<PermissionRequest> permissionRequests, PageRequest pageRequest) {
        int internalStart = 0;
        int limit = pageRequest.getStart() + pageRequest.getLimit() + 1;
        List<Object> results = new ArrayList<ApplicationUser>();
        while (true) {
            PermissionRequest permissionRequest;
            PageRequest internalRequest = PageUtils.newRequest((int)internalStart, (int)this.maxUserPageSize);
            Page internalPage = provider.get(internalRequest);
            List<ApplicationUser> users = internalPage.stream().collect(Collectors.toList());
            Iterator<PermissionRequest> iterator = permissionRequests.iterator();
            while (iterator.hasNext() && !(users = this.filterUsers(permissionRequest = iterator.next(), users)).isEmpty()) {
            }
            if (results.size() + users.size() >= limit) {
                results.addAll(users.subList(0, limit - results.size()));
                break;
            }
            results.addAll(users);
            PageRequest nextRequest = internalPage.getNextPageRequest();
            if (nextRequest == null) break;
            internalStart = nextRequest.getStart();
        }
        if (results.size() <= pageRequest.getStart()) {
            return PageUtils.createPage(Collections.emptyList(), (PageRequest)pageRequest);
        }
        results = results.subList(pageRequest.getStart(), results.size());
        return PageUtils.createPage(results, (PageRequest)pageRequest);
    }

    private List<ApplicationUser> filterUsers(PermissionRequest permissionRequest, List<ApplicationUser> users) {
        Permission permission = permissionRequest.getPermission();
        Object resource = permissionRequest.getResource();
        if (permission.isGlobal()) {
            return this.permissionService.filterUsersWithGlobalPermission(users, permission);
        }
        if (permission.isResource(Project.class)) {
            if (resource instanceof Project) {
                return this.permissionService.filterUsersWithProjectPermission(users, (Project)permissionRequest.getResourceAs(Project.class), permission);
            }
            if (resource instanceof Integer) {
                return this.permissionService.filterUsersWithProjectPermission(users, ((Integer)permissionRequest.getResourceAs(Integer.class)).intValue(), permission);
            }
        }
        if (permission.isResource(Repository.class)) {
            if (resource instanceof Repository) {
                return this.permissionService.filterUsersWithRepositoryPermission(users, (Repository)permissionRequest.getResourceAs(Repository.class), permission);
            }
            if (resource instanceof Integer) {
                return this.permissionService.filterUsersWithRepositoryPermission(users, ((Integer)permissionRequest.getResourceAs(Integer.class)).intValue(), permission);
            }
        }
        throw new AssertionError((Object)("Unsupported resource type " + resource.getClass().getName()));
    }

    @Nonnull
    private ApplicationUser getCurrentUserForUpdate() {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user == null) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.user.anonymousupdate", new Object[0]));
        }
        return user;
    }

    private InternalNormalUser getOrCreateMappedUser(User crowdUser) {
        return this.userHelper.transformOrCreate(crowdUser);
    }

    private boolean isUserActive(User user) {
        User remoteUser;
        Pair key = Pair.pair((Object)user.getDirectoryId(), (Object)user.getName());
        Boolean active = (Boolean)this.isUserActive.get((Object)key);
        if (active != null) {
            log.trace("{}: Returning {} from cache", (Object)user.getName(), (Object)(active != false ? "active" : "inactive"));
            return active;
        }
        try {
            remoteUser = this.crowdControl.getRemoteUser(user.getDirectoryId(), user.getName());
            if (remoteUser != null && remoteUser.isActive()) {
                log.debug("{}: User is active; updating cache", (Object)user.getName());
                this.isUserActive.put((Object)key, (Object)true);
                return true;
            }
        }
        catch (NoSuchUserException e) {
            remoteUser = null;
        }
        log.debug("{}: User {} in the underlying directory", (Object)user.getName(), (Object)(remoteUser == null ? "does not exist" : "is no longer active"));
        return false;
    }

    private <U extends ApplicationUser> Set<U> maybeFilterInactive(Collection<? extends U> users, boolean inactive) {
        return users.stream().filter(DefaultUserService.userFilter(inactive)).collect(Collectors.toSet());
    }

    private <U extends InternalApplicationUser> U maybeFilterInactive(U user, boolean inactive) {
        return (U)(DefaultUserService.userFilter(inactive).test((ApplicationUser)user) ? user : null);
    }

    private void validatePermissionRequest(PermissionRequest request) {
        Permission permission = request.getPermission();
        Object resource = request.getResource();
        if (permission.isGlobal()) {
            if (resource != null) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.user.permission.globalresource", new Object[]{request.getResource()}));
            }
        } else {
            if (resource == null) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.user.permission.emptyresource", new Object[]{request.getPermission()}));
            }
            if (!permission.isResource(resource.getClass())) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.user.permission.incompatibleresource", new Object[]{resource.getClass().getName(), permission, permission.getResourceTypes().stream().map(Class::getName).collect(Collectors.toSet())}));
            }
        }
    }

    private void validatePermissions(Set<PermissionRequest> requests) {
        requests.forEach(this::validatePermissionRequest);
    }
}

