/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.CommonValidations;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.expression.method.PublicMethodSecurityExpressionRoot;
import org.springframework.security.core.Authentication;

public class ExtendedMethodSecurityExpressionRoot
extends PublicMethodSecurityExpressionRoot {
    private final ThreadLocal<Boolean> permissionLoopGuard;
    private PermissionService permissionService;
    private Object returnObject;

    public ExtendedMethodSecurityExpressionRoot(Authentication a, ThreadLocal<Boolean> evaluationPermissions) {
        super(a);
        this.permissionLoopGuard = evaluationPermissions;
    }

    public boolean hasUserPermission(ApplicationUser user, Permission permission) {
        CommonValidations.validateUserPermission(permission);
        return user == null || this.applyPredicate(permission, perm -> this.permissionService.hasUserPermission(user, perm));
    }

    public boolean hasUserPermission(int userId, Permission permission) {
        CommonValidations.validateUserPermission(permission);
        return this.applyPredicate(permission, perm -> this.permissionService.hasUserPermission(userId, perm));
    }

    public boolean hasUserPermission(Permission permission) {
        CommonValidations.validateUserPermission(permission);
        return this.applyPredicate(permission, arg_0 -> ((PermissionService)this.permissionService).hasUserPermission(arg_0));
    }

    public boolean hasAnyPermission(Permission permission) {
        return this.applyPredicate(permission, arg_0 -> ((PermissionService)this.permissionService).hasAnyUserPermission(arg_0));
    }

    public boolean hasAuthenticationProperty(String key, Serializable value) {
        StashUserAuthenticationToken token = this.resolveToken();
        return token != null && Objects.equals(token.getProperties().get(key), value);
    }

    public boolean hasGlobalPermission(Permission permission) {
        CommonValidations.validateGlobalPermission(permission);
        return this.applyPredicate(permission, arg_0 -> ((PermissionService)this.permissionService).hasGlobalPermission(arg_0));
    }

    public boolean hasGlobalPermission(ApplicationUser user, Permission permission) {
        CommonValidations.validateGlobalPermission(permission);
        return this.applyPredicate(permission, perm -> this.permissionService.hasGlobalPermission(user, perm));
    }

    public boolean hasGlobalPermission(String username, Permission permission) {
        CommonValidations.validateGlobalPermission(permission);
        return this.applyPredicate(permission, perm -> this.permissionService.hasGlobalPermission(username, perm));
    }

    public boolean hasProjectPermission(Project project, Permission permission) {
        CommonValidations.validateProjectPermission(permission);
        return project == null || this.applyPredicate(permission, perm -> this.permissionService.hasProjectPermission(project, perm));
    }

    public boolean hasProjectPermission(int projectId, Permission permission) {
        CommonValidations.validateProjectPermission(permission);
        return this.applyPredicate(permission, perm -> this.permissionService.hasProjectPermission(projectId, perm));
    }

    public boolean hasRepositoryPermission(Repository repository, Permission permission) {
        CommonValidations.validateRepositoryPermission(permission);
        return repository == null || this.applyPredicate(permission, perm -> this.permissionService.hasRepositoryPermission(repository, perm));
    }

    public boolean hasRepositoryPermission(int repositoryId, Permission permission) {
        CommonValidations.validateRepositoryPermission(permission);
        return this.applyPredicate(permission, perm -> this.permissionService.hasRepositoryPermission(repositoryId, perm));
    }

    public boolean isCurrentUser(ApplicationUser user) {
        return user != null && this.isCurrentUser(user.getName());
    }

    public boolean isCurrentUser(String username) {
        StashUserAuthenticationToken user = this.resolveToken();
        return user != null && StringUtils.equals((CharSequence)user.getName(), (CharSequence)username);
    }

    public boolean isProjectAccessible(Project project) {
        return project == null || this.applyPredicate(null, ignored -> this.permissionService.isProjectAccessible(project));
    }

    public boolean isProjectAccessible(int projectId) {
        return this.applyPredicate(null, ignored -> this.permissionService.isProjectAccessible(projectId));
    }

    public boolean isRepositoryAccessible(Repository repository) {
        return repository == null || this.applyPredicate(null, ignored -> this.permissionService.isRepositoryAccessible(repository));
    }

    public boolean isRepositoryAccessible(int repositoryId) {
        return this.applyPredicate(null, ignored -> this.permissionService.isRepositoryAccessible(repositoryId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyPredicate(Permission permission, Predicate<Permission> predicate) {
        this.enterPermissionCheck();
        try {
            boolean bl = predicate.test(permission);
            return bl;
        }
        finally {
            this.exitPermissionCheck();
        }
    }

    private void enterPermissionCheck() {
        if (this.permissionLoopGuard.get() != null) {
            throw new IllegalStateException("Nested method authorisation check detected. This would have led to an infinite loop!");
        }
        this.permissionLoopGuard.set(Boolean.TRUE);
    }

    private void exitPermissionCheck() {
        this.permissionLoopGuard.remove();
    }

    private StashUserAuthenticationToken resolveToken() {
        Authentication authentication = this.getAuthentication();
        if (authentication instanceof StashUserAuthenticationToken) {
            return (StashUserAuthenticationToken)authentication;
        }
        return null;
    }

    public Object getReturnObject() {
        return this.returnObject;
    }

    public void setReturnObject(Object returnObject) {
        this.returnObject = returnObject;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

