/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.stash.internal.user.InternalPermissionService;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.google.common.base.Preconditions;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.WebSecurityExpressionRoot;

public class ExtendedWebSecurityExpressionRoot
extends WebSecurityExpressionRoot {
    private final FeatureManager featureManager;
    private final InternalPermissionService permissionService;

    public ExtendedWebSecurityExpressionRoot(Authentication a, FeatureManager featureManager, FilterInvocation fi, InternalPermissionService permissionService) {
        super(a, fi);
        this.featureManager = featureManager;
        this.permissionService = permissionService;
    }

    public boolean hasGlobalPermission(String permission) {
        Permission requestedPerm = Permission.valueOf((String)permission);
        Preconditions.checkArgument((boolean)requestedPerm.isGlobal());
        return this.permissionService.hasGlobalPermission(this.resolveAuthenticationToken(), requestedPerm);
    }

    public boolean isPublicAccessEnabled() {
        return this.featureManager.isEnabled((Feature)StandardFeature.PUBLIC_ACCESS);
    }

    private StashUserAuthenticationToken resolveAuthenticationToken() {
        Authentication authentication = this.getAuthentication();
        if (authentication instanceof StashUserAuthenticationToken) {
            return (StashUserAuthenticationToken)authentication;
        }
        return null;
    }
}

