/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Predicate;

public class InIteratorPredicate<E>
implements Predicate<E> {
    private final Comparator<? super E> comparator;
    private final Iterator<E> it;
    private E current;

    public InIteratorPredicate(Comparator<? super E> comparator, Iterator<E> it) {
        this.comparator = comparator;
        this.it = it;
    }

    @Override
    public boolean test(E value) {
        while (this.current != null || this.it.hasNext()) {
            int i;
            if (this.current == null) {
                this.current = this.it.next();
            }
            if ((i = this.comparator.compare(this.current, value)) > 0) {
                return false;
            }
            if (i < 0) {
                this.current = null;
                continue;
            }
            return true;
        }
        return false;
    }
}

