/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionPredicateFactory;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.CommonValidations;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="permissionPredicateFactory")
public class PermissionPredicateFactoryImpl
implements PermissionPredicateFactory {
    private final PermissionService permissionService;
    private final Predicate<Project> projectAccessiblePredicate;
    private final Predicate<Repository> repositoryAccessiblePredicate;

    @Autowired
    public PermissionPredicateFactoryImpl(PermissionService permissionService) {
        this.permissionService = permissionService;
        this.projectAccessiblePredicate = project -> {
            Objects.requireNonNull(project, "project");
            return this.permissionService.isProjectAccessible(project);
        };
        this.repositoryAccessiblePredicate = repository -> {
            Objects.requireNonNull(repository, "repository");
            return this.permissionService.isRepositoryAccessible(repository);
        };
    }

    @Nonnull
    public Predicate<Project> createProjectAccessiblePredicate() {
        return this.projectAccessiblePredicate;
    }

    @Nonnull
    public Predicate<Project> createProjectPermissionPredicate(@Nonnull Permission permission) {
        CommonValidations.validateProjectPermission(permission);
        return project -> {
            Objects.requireNonNull(project, "project");
            return this.permissionService.hasProjectPermission(project, permission);
        };
    }

    @Nonnull
    public Predicate<PullRequest> createPullRequestPermissionPredicate(@Nonnull Permission permission) {
        Predicate<Repository> requestedRepositoryPredicate = this.createRepositoryPermissionPredicate(permission);
        return pullRequest -> requestedRepositoryPredicate.test(pullRequest.getToRef().getRepository());
    }

    @Nonnull
    public Predicate<Repository> createRepositoryAccessiblePredicate() {
        return this.repositoryAccessiblePredicate;
    }

    @Nonnull
    public Predicate<Repository> createRepositoryPermissionPredicate(@Nonnull Permission permission) {
        CommonValidations.validateRepositoryPermission(permission);
        return repository -> {
            Objects.requireNonNull(repository, "repository");
            return this.permissionService.hasRepositoryPermission(repository, permission);
        };
    }
}

