/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.auth.SimpleAuthentication;
import com.atlassian.bitbucket.dmz.permission.DmzPermissionService;
import com.atlassian.bitbucket.dmz.permission.EffectivePermission;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionCheck;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionVote;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.CommonValidations;
import com.atlassian.stash.internal.annotation.NotProfiled;
import com.atlassian.stash.internal.permission.GrantedPermissionVoterProvider;
import com.atlassian.stash.internal.permission.PermissionVoterFactory;
import com.atlassian.stash.internal.permission.SimplePermissionCheck;
import com.atlassian.stash.internal.project.ProjectDao;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.user.EffectivePermissionDao;
import com.atlassian.stash.internal.user.GroupPermissionCriteria;
import com.atlassian.stash.internal.user.InternalAuthenticationContext;
import com.atlassian.stash.internal.user.InternalPermissionService;
import com.atlassian.stash.internal.user.InternalUserService;
import com.atlassian.stash.internal.user.PartitionedGroups;
import com.atlassian.stash.internal.user.RepositoryPermissionDao;
import com.atlassian.stash.internal.user.ResourcePermission;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.internal.user.UserPermissionCriteria;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(interfaces={PermissionService.class, DmzPermissionService.class})
@NotProfiled
@Service(value="permissionService")
public class PermissionServiceImpl
extends AbstractService
implements InternalPermissionService {
    public static final String GROUP_PERMISSION_SEARCH = "Group Permission Search";
    public static final int FIND_BY_GROUPS_THRESHOLD = 20000;
    public static final int USER_GROUP_PAGE_LIMIT = 500;
    private static final Logger log = LoggerFactory.getLogger(PermissionServiceImpl.class);
    private final InternalAuthenticationContext authenticationContext;
    private final EffectivePermissionDao effectivePermissionDao;
    private final GrantedPermissionVoterProvider grantedPermissionVoterProvider;
    private final ProjectDao projectDao;
    private final RepositoryDao repositoryDao;
    private final RepositoryPermissionDao repositoryPermissionDao;
    private FeatureManager featureManager;
    private PermissionVoterFactory permissionVoterFactory;
    private InternalUserService userService;
    @Value(value="${page.max.groups}")
    private int maxGroupPageSize;
    @Value(value="${page.max.users}")
    private int maxUserPageSize;

    @Autowired
    public PermissionServiceImpl(InternalAuthenticationContext authenticationContext, EffectivePermissionDao effectivePermissionDao, GrantedPermissionVoterProvider grantedPermissionVoterProvider, ProjectDao projectDao, RepositoryDao repositoryDao, RepositoryPermissionDao repositoryPermissionDao) {
        this.authenticationContext = authenticationContext;
        this.effectivePermissionDao = effectivePermissionDao;
        this.grantedPermissionVoterProvider = grantedPermissionVoterProvider;
        this.projectDao = projectDao;
        this.repositoryDao = repositoryDao;
        this.repositoryPermissionDao = repositoryPermissionDao;
    }

    public boolean hasGlobalPermission(String username, @Nonnull Permission permission) {
        ApplicationUser user = username == null ? null : this.findUserByName(username);
        return this.hasGlobalPermission(user, permission);
    }

    public boolean hasGlobalPermission(ApplicationUser user, @Nonnull Permission permission) {
        CommonValidations.validateGlobalPermission(permission);
        return this.hasPermission(user, null, permission);
    }

    public boolean hasGlobalPermission(StashUserAuthenticationToken token, Permission permission) {
        CommonValidations.validateGlobalPermission(permission);
        return this.hasPermission(token, null, permission);
    }

    public boolean hasGlobalPermission(@Nonnull Permission permission) {
        return this.hasGlobalPermission(this.authenticationContext.getCurrentToken(), permission);
    }

    public boolean hasAnyUserPermission(@Nonnull ApplicationUser user, @Nonnull Permission permission) {
        Objects.requireNonNull(user, "user");
        CommonValidations.validateResourcePermission(permission);
        return this.hasPermission(user, null, permission);
    }

    public boolean hasAnyUserPermission(@Nonnull Permission permission) {
        StashUserAuthenticationToken token = this.authenticationContext.getCurrentToken();
        return token != null && this.hasAnyUserPermission(token, permission);
    }

    public boolean hasProjectPermission(ApplicationUser user, @Nonnull Project project, @Nonnull Permission permission) {
        Objects.requireNonNull(project, "project");
        CommonValidations.validateProjectPermission(permission);
        return this.hasPermission(user, project, permission);
    }

    public boolean hasProjectPermission(@Nonnull Project project, @Nonnull Permission permission) {
        return this.hasProjectPermission(this.authenticationContext.getCurrentToken(), project, permission);
    }

    public boolean hasProjectPermission(int projectId, @Nonnull Permission permission) {
        return this.hasProjectPermission(this.authenticationContext.getCurrentToken(), projectId, permission);
    }

    public boolean hasProjectPermission(ApplicationUser user, int projectId, @Nonnull Permission permission) {
        CommonValidations.validateProjectPermission(permission);
        Project project = (Project)this.projectDao.getById((Object)projectId);
        return project == null || this.hasPermission(user, project, permission);
    }

    public boolean hasDirectGlobalUserPermission(@Nonnull Permission permission) {
        CommonValidations.validateGlobalPermission(permission);
        return this.hasDirectUserPermission(this.authenticationContext.getCurrentToken(), null, permission);
    }

    public boolean hasDirectProjectUserPermission(@Nonnull Project project, @Nonnull Permission permission) {
        Objects.requireNonNull(project, "project");
        CommonValidations.validateProjectPermission(permission);
        return this.hasDirectUserPermission(this.authenticationContext.getCurrentToken(), (Object)project, permission);
    }

    public boolean hasDirectRepositoryUserPermission(@Nonnull Repository repository, @Nonnull Permission permission) {
        Objects.requireNonNull(repository, "repository");
        CommonValidations.validateRepositoryPermission(permission);
        return this.hasDirectUserPermission(this.authenticationContext.getCurrentToken(), (Object)repository, permission);
    }

    private boolean hasDirectUserPermission(StashUserAuthenticationToken token, Object resource, Permission permission) {
        return token != null && this.hasDirectUserPermission(token.getPrincipal(), resource, permission);
    }

    public boolean hasGlobalGroupPermission(@Nonnull Permission permission, @Nonnull String group) {
        CommonValidations.validateGlobalPermission(permission);
        CommonValidations.validateGroup(group);
        GroupPermissionCriteria criteria = ((GroupPermissionCriteria.Builder)new GroupPermissionCriteria.Builder(group).permission(permission)).build();
        return this.effectivePermissionDao.isGrantedToGroup(criteria);
    }

    public boolean isProjectAccessible(@Nonnull Project project) {
        Objects.requireNonNull(project, "project");
        return this.hasProjectPermission(project, Permission.PROJECT_VIEW) || this.isPubliclyAccessible(project);
    }

    public boolean isProjectAccessible(int projectId) {
        Project project = (Project)this.projectDao.getById((Object)projectId);
        return project != null && this.isProjectAccessible(project);
    }

    public boolean isRepositoryAccessible(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return this.hasRepositoryPermission(repository, Permission.REPO_READ) || this.isPubliclyAccessible(repository);
    }

    public boolean isRepositoryAccessible(int repositoryId) {
        Repository repository = (Repository)this.repositoryDao.getById((Object)repositoryId);
        return repository != null && this.isRepositoryAccessible(repository);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public boolean isPubliclyAccessible(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return this.featureManager.isEnabled((Feature)StandardFeature.PUBLIC_ACCESS) && (repository.isPublic() || repository.getProject().isPublic());
    }

    public boolean isPubliclyAccessible(@Nonnull Project project) {
        Objects.requireNonNull(project, "project");
        return this.featureManager.isEnabled((Feature)StandardFeature.PUBLIC_ACCESS) && (project.isPublic() || this.repositoryDao.countPublicByProject(project.getId()) > 0L);
    }

    @Nonnull
    public Page<ApplicationUser> getGrantedUsers(@Nonnull Permission permission, @Nonnull PageRequest request) {
        CommonValidations.validateGlobalPermission(permission);
        Objects.requireNonNull(request, "request");
        return this.effectivePermissionDao.findUsers(permission, request, ApplicationUser::isActive);
    }

    @Nonnull
    public Page<String> getGrantedGroups(@Nonnull Permission permission, @Nonnull PageRequest request) {
        CommonValidations.validateGlobalPermission(permission);
        Objects.requireNonNull(request, "request");
        return this.effectivePermissionDao.findGroups(permission, request);
    }

    public boolean hasGlobalPermissionThroughGroupMembership(@Nonnull Permission permission, @Nonnull Set<String> excludedGroups) {
        CommonValidations.validateGlobalPermission(permission);
        CommonValidations.validateGroups(excludedGroups);
        return this.hasPermissionsThroughGroup((Principal)this.authenticationContext.getCurrentToken(), null, permission, excludedGroups);
    }

    public boolean hasProjectPermissionThroughGroupMembership(@Nonnull Project project, @Nonnull Permission permission, @Nonnull Set<String> excludedGroups) {
        Objects.requireNonNull(project, "project");
        CommonValidations.validateProjectPermission(permission);
        CommonValidations.validateGroups(excludedGroups);
        return this.hasPermissionsThroughGroup((Principal)this.authenticationContext.getCurrentToken(), project, permission, excludedGroups);
    }

    public boolean hasRepositoryPermissionThroughGroupMembership(@Nonnull Repository repository, @Nonnull Permission permission, @Nonnull Set<String> excludedGroups) {
        Objects.requireNonNull(repository, "repository");
        CommonValidations.validateRepositoryPermission(permission);
        CommonValidations.validateGroups(excludedGroups);
        return this.hasPermissionsThroughGroup((Principal)this.authenticationContext.getCurrentToken(), repository, permission, excludedGroups);
    }

    public boolean hasRepositoryPermission(ApplicationUser user, @Nonnull Repository repository, @Nonnull Permission permission) {
        Objects.requireNonNull(repository, "repository");
        CommonValidations.validateRepositoryPermission(permission);
        return this.hasPermission(user, repository, permission);
    }

    public boolean hasRepositoryPermission(ApplicationUser user, int repositoryId, @Nonnull Permission permission) {
        Repository repository = (Repository)this.repositoryDao.getById((Object)repositoryId);
        return repository == null || this.hasRepositoryPermission(user, repository, permission);
    }

    public boolean hasRepositoryPermission(@Nonnull Repository repository, @Nonnull Permission permission) {
        return this.hasRepositoryPermission(this.authenticationContext.getCurrentToken(), repository, permission);
    }

    public boolean hasRepositoryPermission(int repositoryId, @Nonnull Permission permission) {
        return this.hasRepositoryPermission(this.authenticationContext.getCurrentToken(), repositoryId, permission);
    }

    public boolean hasUserPermission(@Nonnull ApplicationUser user, @Nonnull ApplicationUser targetUser, @Nonnull Permission permission) {
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(targetUser, "targetUser");
        return this.hasPermission(user, targetUser, permission);
    }

    public boolean hasUserPermission(@Nonnull ApplicationUser user, int targetUserId, @Nonnull Permission permission) {
        Objects.requireNonNull(user, "user");
        ApplicationUser targetUser = this.userService.getUserById(targetUserId);
        return targetUser == null || this.hasPermission(user, targetUser, permission);
    }

    public boolean hasUserPermission(@Nonnull ApplicationUser targetUser, @Nonnull Permission permission) {
        return this.hasUserPermission(this.authenticationContext.getCurrentToken(), targetUser, permission);
    }

    public boolean hasUserPermission(int targetUserId, @Nonnull Permission permission) {
        return this.hasUserPermission(this.authenticationContext.getCurrentToken(), targetUserId, permission);
    }

    public boolean hasUserPermission(@Nonnull Permission permission) {
        return this.hasUserPermission(this.authenticationContext.getCurrentToken(), this.authenticationContext.getCurrentUser(), permission);
    }

    @Nonnull
    public List<ApplicationUser> filterUsersWithGlobalPermission(@Nonnull List<ApplicationUser> users, @Nonnull Permission permission) {
        CommonValidations.validateGlobalPermission(permission);
        return this.filterUsersWithPermission(users, null, permission);
    }

    @Nonnull
    public List<ApplicationUser> filterUsersWithProjectPermission(@Nonnull List<ApplicationUser> users, int projectId, @Nonnull Permission permission) {
        Project project = (Project)this.projectDao.getById((Object)projectId);
        if (project == null) {
            return Collections.emptyList();
        }
        return this.filterUsersWithProjectPermission(users, project, permission);
    }

    @Nonnull
    public List<ApplicationUser> filterUsersWithProjectPermission(@Nonnull List<ApplicationUser> users, @Nonnull Project project, @Nonnull Permission permission) {
        Objects.requireNonNull(project, "project");
        CommonValidations.validateProjectPermission(permission);
        return this.filterUsersWithPermission(users, project, permission);
    }

    @Nonnull
    public List<ApplicationUser> filterUsersWithRepositoryPermission(@Nonnull List<ApplicationUser> users, @Nonnull Repository repository, @Nonnull Permission permission) {
        Objects.requireNonNull(repository, "repository");
        CommonValidations.validateRepositoryPermission(permission);
        return this.filterUsersWithPermission(users, repository, permission);
    }

    @Nonnull
    public List<ApplicationUser> filterUsersWithRepositoryPermission(@Nonnull List<ApplicationUser> users, int repositoryId, @Nonnull Permission permission) {
        Repository repository = (Repository)this.repositoryDao.getById((Object)repositoryId);
        if (repository == null) {
            return Collections.emptyList();
        }
        return this.filterUsersWithRepositoryPermission(users, repository, permission);
    }

    @Nonnull
    public Set<String> getUsersWithPermission(@Nonnull Permission permission) {
        CommonValidations.validateGlobalPermission(permission);
        return Sets.union(this.usersWithPermission(permission), this.usersFromGroupsWithPermission(permission));
    }

    public int getCountOfAccessibleRepositories(@Nonnull Project project) {
        Objects.requireNonNull(project, "project");
        StashUserAuthenticationToken token = this.authenticationContext.getCurrentToken();
        if (this.hasProjectPermission(token, project, Permission.PROJECT_READ)) {
            return Ints.saturatedCast((long)this.repositoryDao.countByProject(Objects.requireNonNull(project, "project").getId()));
        }
        if (token != null && token.getPrincipal() != null) {
            ApplicationUser user = token.getPrincipal();
            return Ints.saturatedCast((long)this.repositoryPermissionDao.countWithPermission(user.getId(), this.getAllGroups(user.getName()), project.getId()));
        }
        return 0;
    }

    public Permission getHighestGlobalPermission(ApplicationUser user) {
        if (PermissionServiceImpl.isNullOrInactive(user)) {
            return null;
        }
        List<Permission> globalPermissions = this.getOrderedGlobalPermissions();
        for (Permission globalPermission : globalPermissions) {
            if (!this.hasGlobalPermission(user, globalPermission)) continue;
            return globalPermission;
        }
        return null;
    }

    public Permission getHighestGlobalPermission(String username) {
        ApplicationUser user = username != null ? this.findUserByName(username) : null;
        return user != null ? this.getHighestGlobalPermission(user) : null;
    }

    public Permission getHighestGlobalGroupPermission(String groupName) {
        if (groupName == null) {
            return null;
        }
        List<Permission> globalPermissions = this.getOrderedGlobalPermissions();
        for (Permission globalPermission : globalPermissions) {
            if (!this.hasGlobalGroupPermission(globalPermission, groupName)) continue;
            return globalPermission;
        }
        return null;
    }

    @Nonnull
    public Iterable<EffectivePermission> getEffectivePermissions(@Nonnull ApplicationUser user) {
        return this.grantedPermissionVoterProvider.getEffectivePermissions(user);
    }

    @Autowired
    public void setFeatureManager(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    @Autowired
    public void setPermissionVoterFactory(PermissionVoterFactory voterFactory) {
        this.permissionVoterFactory = voterFactory;
    }

    @Autowired
    public void setUserService(InternalUserService userService) {
        this.userService = userService;
    }

    @VisibleForTesting
    PartitionedGroups getAllGroups(String username) {
        int pageSize = 500;
        return this.partitionGroups((PagedIterable<String>)new PagedIterable(request -> this.userService.findGroupsByUser(username, request), pageSize), pageSize);
    }

    @Nonnull
    private PermissionVoter createPermissionVoter(@Nullable ApplicationUser user) {
        return this.permissionVoterFactory.create(SimpleAuthentication.builder((ApplicationUser)user).build());
    }

    private static boolean isNullOrInactive(ApplicationUser user) {
        return user == null || !user.isActive() && user.getType() == UserType.NORMAL;
    }

    private ApplicationUser findUserByName(String username) {
        return this.userService.getUserByName(username);
    }

    private List<Permission> getOrderedGlobalPermissions() {
        ArrayList<Permission> globalPermissions = new ArrayList<Permission>(Permission.getGlobalPermissions());
        globalPermissions.sort((left, right) -> left == right ? 0 : Integer.compare(right.getWeight(), left.getWeight()));
        return globalPermissions;
    }

    private boolean hasAnyUserPermission(StashUserAuthenticationToken token, Permission permission) {
        CommonValidations.validateResourcePermission(permission);
        return this.hasPermission(token, null, permission);
    }

    private boolean hasDirectUserPermission(ApplicationUser user, Object resource, Permission permission) {
        if (PermissionServiceImpl.isNullOrInactive(user)) {
            return false;
        }
        int userId = user.getId();
        if (userId == 0) {
            return false;
        }
        UserPermissionCriteria criteria = ((UserPermissionCriteria.Builder)((UserPermissionCriteria.Builder)new UserPermissionCriteria.Builder(userId).permission(permission)).resource(resource)).build();
        boolean granted = this.effectivePermissionDao.isGrantedToUser(criteria);
        if (granted) {
            log.trace("{}: {}, or an inheriting permission, has been explicit granted", (Object)user.getName(), (Object)permission);
        } else {
            log.trace("{}: {} has not been explicitly granted", (Object)user.getName(), (Object)permission);
        }
        return granted;
    }

    private <T> List<ApplicationUser> filterUsersWithPermission(@Nonnull List<ApplicationUser> users, @Nullable T resource, @Nonnull Permission permission) {
        Objects.requireNonNull(users, "users");
        if (users.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> groups = new HashSet<String>();
        users.forEach(user -> Iterables.addAll((Collection)groups, this.grantedPermissionVoterProvider.loadGroupsByUser((ApplicationUser)user)));
        Map voters = users.stream().collect(Collectors.toMap(Function.identity(), user -> this.permissionVoterFactory.create(new SimpleAuthentication.Builder(user).build())));
        ArrayList<ApplicationUser> result = new ArrayList<ApplicationUser>();
        this.grantedPermissionVoterProvider.withPrecalculatedPermissions(this.preloadUserPermissions(users), this.preloadGroupPermissions(groups), (Operation<Void, Exception>)((Operation)() -> {
            users.forEach(user -> {
                SimplePermissionCheck permissionCheck = SimplePermissionCheck.builder(permission).resource(resource).build();
                if (((PermissionVoter)voters.get(user)).vote((PermissionCheck)permissionCheck) == PermissionVote.GRANT) {
                    result.add((ApplicationUser)user);
                }
            });
            return null;
        }));
        return result;
    }

    private <T> boolean hasPermission(@Nullable StashUserAuthenticationToken token, @Nullable T resource, @Nonnull Permission permission) {
        if (token == null) {
            return this.hasPermission(null, resource, permission, this.createPermissionVoter(null));
        }
        return this.hasPermission(token.getPrincipal(), resource, permission, token.getVoter());
    }

    private <T> boolean hasPermission(@Nullable ApplicationUser user, @Nullable T resource, @Nonnull Permission permission) {
        return this.hasPermission(user, resource, permission, this.createPermissionVoter(user));
    }

    private <T> boolean hasPermission(@Nullable ApplicationUser user, @Nullable T resource, @Nonnull Permission permission, @Nonnull PermissionVoter voter) {
        log.trace("user = {}, resource = {}, requested permission = {}", new Object[]{user, resource, permission});
        PermissionVote vote = voter.vote((PermissionCheck)SimplePermissionCheck.builder(permission).resource(resource).build());
        return vote == PermissionVote.GRANT;
    }

    private boolean hasPermissionsThroughGroup(Principal user, Object resource, Permission permission, Set<String> excludedGroups) {
        String name = user.getName();
        try (Timer ignored = TimerUtils.start((String)GROUP_PERMISSION_SEARCH);){
            PageRequest pageRequest = PageUtils.newRequest((int)0, (int)500);
            Page page = this.userService.findGroupsByUser(name, pageRequest);
            while (true) {
                HashSet groups = Sets.newHashSet((Iterable)page.getValues());
                Iterables.removeAll((Iterable)groups, (Collection)excludedGroups.stream().map(IdentifierUtils::toLowerCase).collect(Collectors.toSet()));
                if (groups.isEmpty()) {
                    log.trace("All groups on the page have been excluded");
                } else {
                    log.trace("Testing for permission against {} groups", (Object)groups.size());
                    GroupPermissionCriteria criteria = ((GroupPermissionCriteria.Builder)((GroupPermissionCriteria.Builder)new GroupPermissionCriteria.Builder((Iterable)groups).permission(permission)).resource(resource)).build();
                    boolean granted = this.effectivePermissionDao.isGrantedToGroup(criteria);
                    if (granted) {
                        log.trace("{}: Permission {} granted by group membership", (Object)name, (Object)permission);
                        boolean bl = true;
                        return bl;
                    }
                }
                if (page.getIsLastPage()) break;
                log.trace("{}: Loading next page of groups", (Object)name);
                page = this.userService.findGroupsByUser(name, page.getNextPageRequest());
            }
            log.trace("{}: All group memberships have been exhausted", (Object)name);
            log.trace("permission not granted by any group membership");
            boolean bl = false;
            return bl;
        }
    }

    private boolean hasProjectPermission(StashUserAuthenticationToken token, Project project, Permission permission) {
        Objects.requireNonNull(project, "project");
        CommonValidations.validateProjectPermission(permission);
        return this.hasPermission(token, project, permission);
    }

    private boolean hasProjectPermission(StashUserAuthenticationToken token, int projectId, Permission permission) {
        CommonValidations.validateProjectPermission(permission);
        Project project = (Project)this.projectDao.getById((Object)projectId);
        return project == null || this.hasPermission(token, project, permission);
    }

    private boolean hasRepositoryPermission(StashUserAuthenticationToken token, Repository repository, Permission permission) {
        Objects.requireNonNull(repository, "repository");
        CommonValidations.validateRepositoryPermission(permission);
        return this.hasPermission(token, repository, permission);
    }

    private boolean hasRepositoryPermission(StashUserAuthenticationToken token, int repositoryId, Permission permission) {
        Repository repository = (Repository)this.repositoryDao.getById((Object)repositoryId);
        return repository == null || this.hasRepositoryPermission(token, repository, permission);
    }

    private boolean hasUserPermission(StashUserAuthenticationToken token, ApplicationUser targetUser, Permission permission) {
        Objects.requireNonNull(targetUser, "targetUser");
        CommonValidations.validateUserPermission(permission);
        return this.hasPermission(token, targetUser, permission);
    }

    private boolean hasUserPermission(StashUserAuthenticationToken token, int targetUserId, Permission permission) {
        ApplicationUser targetUser = this.userService.getUserById(targetUserId);
        return targetUser == null || this.hasUserPermission(token, targetUser, permission);
    }

    private PartitionedGroups partitionGroups(PagedIterable<String> groups, int partitionSize) {
        return () -> {
            Iterator iterator = groups.iterator();
            if (iterator.hasNext()) {
                return Iterators.partition((Iterator)iterator, (int)partitionSize);
            }
            return Collections.singletonList(Collections.emptyList()).iterator();
        };
    }

    private Map<Integer, List<ResourcePermission>> preloadUserPermissions(List<ApplicationUser> users) {
        try (Ticker ignored = Timers.timer((String)("Preloading user permissions for: " + users.size() + " users")).start(new String[0]);){
            Map map = this.effectivePermissionDao.findByUsers(users.stream().map(ApplicationUser::getId).collect(Collectors.toList()));
            return map;
        }
    }

    private Map<String, List<ResourcePermission>> preloadGroupPermissions(Set<String> groups) {
        Collection<String> groupsInCache = this.grantedPermissionVoterProvider.getCurrentlyCachedGroups();
        ArrayList filteredGroups = new ArrayList(groups.size() / 2);
        groups.forEach(group -> {
            if (!groupsInCache.contains(IdentifierUtils.toLowerCase((String)group))) {
                filteredGroups.add(group);
            }
        });
        try (Ticker ignored = Timers.timer((String)("Preloading group permissions for: " + filteredGroups.size() + " groups")).start(new String[0]);){
            Map groupPermissions = filteredGroups.size() < 20000 ? this.effectivePermissionDao.findByGroups(filteredGroups) : this.effectivePermissionDao.findAllByGroups();
            Map map = groupPermissions;
            return map;
        }
    }

    private Set<String> usersFromGroupsWithPermission(@Nonnull Permission permission) {
        PageProvider grantedGroupsProvider = request -> this.getGrantedGroups(permission, request);
        PageRequest groupsPageRequest = PageUtils.newRequest((int)0, (int)this.maxGroupPageSize);
        HashSet<String> users = new HashSet<String>();
        while (groupsPageRequest != null) {
            Page groupsPage = grantedGroupsProvider.get(groupsPageRequest);
            PageRequest usersPageRequest = PageUtils.newRequest((int)0, (int)20000);
            PageProvider userPageProvider = request -> this.userService.findUsernamesByGroups((Set)ImmutableSet.copyOf((Iterable)groupsPage.getValues()), request);
            while (usersPageRequest != null) {
                Page usersPage = userPageProvider.get(usersPageRequest);
                usersPage.getValues().forEach(user -> users.add(IdentifierUtils.toLowerCase((String)user)));
                usersPageRequest = usersPage.getNextPageRequest();
            }
            groupsPageRequest = groupsPage.getNextPageRequest();
        }
        return users;
    }

    private Set<String> usersWithPermission(@Nonnull Permission permission) {
        return PageUtils.toStream(request -> this.getGrantedUsers(permission, request), (int)this.maxUserPageSize).filter(ApplicationUser::isActive).map(Principal::getName).map(IdentifierUtils::toLowerCase).collect(Collectors.toSet());
    }
}

