/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.dmz.permission.EffectivePermission;
import com.atlassian.bitbucket.dmz.permission.EffectivePermissionsProvider;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.user.EffectivePermissionsProviderTracker;
import com.atlassian.stash.internal.user.EffectivePermissionsService;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="effectivePermissionsService")
public class PluginEffectivePermissionsService
implements EffectivePermissionsService {
    private static final Logger log = LoggerFactory.getLogger(PluginEffectivePermissionsService.class);
    private final EffectivePermissionsProviderTracker permissionsProviderTracker;

    @Autowired
    public PluginEffectivePermissionsService(EffectivePermissionsProviderTracker permissionsProviderTracker) {
        this.permissionsProviderTracker = permissionsProviderTracker;
    }

    @Override
    @Nonnull
    public Set<EffectivePermission> getEffectivePermissions(@Nullable ApplicationUser user) {
        ImmutableSet.Builder effectivePermissions = ImmutableSet.builder();
        if (user != null) {
            for (EffectivePermissionsProvider provider : this.permissionsProviderTracker.getProviders()) {
                try {
                    provider.getPermissions(user).forEach(arg_0 -> ((ImmutableSet.Builder)effectivePermissions).add(arg_0));
                }
                catch (Exception | NoClassDefFoundError e) {
                    log.error("Failed to retrieve effective permissions from provider {}", (Object)provider.getClass().getName(), (Object)e);
                }
            }
        }
        return effectivePermissions.build();
    }
}

