/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.user.UserErasureException;
import com.atlassian.bitbucket.user.UserErasureHandler;
import com.atlassian.bitbucket.user.UserErasureModuleDescriptor;
import com.atlassian.bitbucket.user.UserErasureRequest;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.user.UserErasureService;
import jakarta.annotation.Nonnull;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class PluginUserErasureService
extends AbstractService
implements UserErasureService {
    private static final Logger log = LoggerFactory.getLogger(PluginUserErasureService.class);
    private final I18nService i18nService;
    private final PluginAccessor pluginAccessor;

    public PluginUserErasureService(PluginAccessor pluginAccessor, I18nService i18nService) {
        this.pluginAccessor = pluginAccessor;
        this.i18nService = i18nService;
    }

    @Unsecured(value="This is an internal method")
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void eraseUser(@Nonnull UserErasureRequest request) {
        LinkedHashMap exceptions = new LinkedHashMap();
        this.pluginAccessor.getEnabledModuleDescriptorsByClass(UserErasureModuleDescriptor.class).stream().sorted().forEachOrdered(descriptor -> {
            log.trace("Found module descriptor '{}' with weight '{}'", (Object)descriptor.getCompleteKey(), (Object)descriptor.getWeight());
            UserErasureHandler userErasureHandler = descriptor.getModule();
            try (Timer ignored = TimerUtils.start((String)("eraseUser - " + descriptor.getCompleteKey()));){
                userErasureHandler.eraseUser(request);
            }
            catch (LinkageError | RuntimeException e) {
                log.warn("Module descriptor '{}' failed to erase user '{}': {}", new Object[]{descriptor.getCompleteKey(), request.getOriginalUsername(), e.toString(), log.isDebugEnabled() ? e : null});
                exceptions.put(descriptor.getCompleteKey(), e);
            }
        });
        if (!exceptions.isEmpty()) {
            throw new UserErasureException(this.i18nService.createKeyedMessage("bitbucket.service.user.erasure.finished.with.exceptions", new Object[]{request.getOriginalUsername(), this.getClass().getSimpleName()}), exceptions);
        }
    }
}

