/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.DataStoreException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.event.auth.AuthenticationSuccessEvent;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.concurrent.Gate;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.user.InternalRecentlyAccessedRepositoriesService;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecentlyAccessedRepositoriesAuthenticationSuccessListener {
    private static final Logger log = LoggerFactory.getLogger(RecentlyAccessedRepositoriesAuthenticationSuccessListener.class);
    private final AuthenticationContext authenticationContext;
    private final Gate<Integer> gate;
    private final InternalRecentlyAccessedRepositoriesService recentlyAccessedRepositoriesService;

    @Autowired
    public RecentlyAccessedRepositoriesAuthenticationSuccessListener(AuthenticationContext authenticationContext, InternalRecentlyAccessedRepositoriesService recentlyAccessedRepositoriesService) {
        this.authenticationContext = authenticationContext;
        this.recentlyAccessedRepositoriesService = recentlyAccessedRepositoriesService;
        this.gate = new Gate(60L, TimeUnit.SECONDS);
    }

    @EventListener
    public void onAuthenticationSuccessEvent(AuthenticationSuccessEvent event) {
        if (Objects.equals("basic", event.getAuthenticationMethod())) {
            return;
        }
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        this.gate.callIfNotRecentlyRun((Object)user.getId(), () -> {
            try {
                this.recentlyAccessedRepositoriesService.trimForUser(user);
            }
            catch (DataStoreException e) {
                log.debug("Failed to trim recently accessed repositories for user {}", (Object)user.getName(), (Object)e);
            }
        });
    }
}

