/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.NoUniqueUserIdentifierException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.user.ApplicationUserDao;
import com.atlassian.stash.internal.user.UserErasureIdentifierGenerator;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SimpleUserErasureIdentifierGenerator
implements UserErasureIdentifierGenerator {
    private static final int MAX_ATTEMPTS = 50;
    private static final String PREFIX = "user-";
    private final I18nService i18nService;
    private final SecureTokenGenerator secureTokenGenerator;
    private final ApplicationUserDao userDao;

    @Autowired
    public SimpleUserErasureIdentifierGenerator(I18nService i18nService, SecureTokenGenerator secureTokenGenerator, ApplicationUserDao userDao) {
        this.i18nService = i18nService;
        this.secureTokenGenerator = secureTokenGenerator;
        this.userDao = userDao;
    }

    @Override
    @Nonnull
    public String getIdentifier() {
        for (int i = 0; i < 50; ++i) {
            String identifier = PREFIX + StringUtils.substring((String)this.secureTokenGenerator.generateToken(), (int)0, (int)5);
            if (this.userDao.findByName(identifier) != null) continue;
            return identifier;
        }
        throw new NoUniqueUserIdentifierException(this.i18nService.createKeyedMessage("bitbucket.service.user.nouniqueuseridentifiergenerated", new Object[0]));
    }
}

