/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.EntityOutOfDateException;
import com.atlassian.bitbucket.event.auth.AuthenticationSuccessEvent;
import com.atlassian.bitbucket.util.concurrent.Gate;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.user.InternalUserService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UserAuthenticationTracker {
    private static final Logger log = LoggerFactory.getLogger(UserAuthenticationTracker.class);
    private final Gate<String> gate;
    private final InternalUserService userService;

    @Autowired
    public UserAuthenticationTracker(InternalUserService userService, @Value(value="${auth.last.authenticated.interval}") long lastAuthenticatedSeconds) {
        this.gate = new Gate(Math.max(5L, lastAuthenticatedSeconds), TimeUnit.SECONDS);
        this.userService = userService;
    }

    @EventListener
    public void onAuthenticationSuccess(AuthenticationSuccessEvent event) {
        String username = event.getUsername();
        if (username != null) {
            this.gate.callIfNotRecentlyRun((Object)username, () -> {
                try {
                    this.userService.updateLastAuthentication(username);
                }
                catch (EntityOutOfDateException entityOutOfDateException) {
                }
                catch (RuntimeException e) {
                    log.warn("{}: Failed to update last authentication timestamp", (Object)username, (Object)e);
                }
            });
        }
    }
}

