/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user.upgrade;

import com.atlassian.bitbucket.avatar.AvatarSupplier;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.avatar.AvatarRepository;
import com.atlassian.stash.internal.avatar.AvatarType;
import com.atlassian.stash.internal.avatar.ResourceAvatarSupplier;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.upgrade.UpgradeTask;
import com.atlassian.stash.internal.user.ApplicationUserDao;
import com.atlassian.stash.internal.user.InternalServiceUser;
import jakarta.annotation.PostConstruct;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="createSystemUserUpgradeTask")
@UpgradeTask(value="core-system-user")
public class CreateSystemUserUpgradeTask {
    static final String KEY_TASK = "core-system-user";
    static final String KEY_TASK_LOCK = "core-system-user.lock";
    private static final Logger log = LoggerFactory.getLogger(CreateSystemUserUpgradeTask.class);
    private final AvatarRepository avatarRepository;
    private final HomeLayout homeLayout;
    private final LockService lockService;
    private final ApplicationUserDao userDao;
    private final TransactionTemplate withNewTransaction;

    @Autowired
    public CreateSystemUserUpgradeTask(AvatarRepository avatarRepository, HomeLayout homeLayout, LockService lockService, PlatformTransactionManager transactionManager, ApplicationUserDao userDao) {
        this.avatarRepository = avatarRepository;
        this.homeLayout = homeLayout;
        this.lockService = lockService;
        this.userDao = userDao;
        this.withNewTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @PostConstruct
    public void apply() throws Exception {
        Path markerFile = this.homeLayout.getUpgradesDir().resolve(KEY_TASK);
        if (Files.exists(markerFile, new LinkOption[0])) {
            log.debug("Skipping upgrade task to create system service user as this has already been completed");
            return;
        }
        try (LockGuard ignored = LockGuard.lock((Lock)this.lockService.getLock(KEY_TASK_LOCK));){
            log.debug("Locked upgrade task {}", (Object)KEY_TASK_LOCK);
            if (Files.exists(markerFile, new LinkOption[0])) {
                log.debug("Skipping upgrade task to create system service user as this has already been completed");
                return;
            }
            this.withNewTransaction.execute(status -> {
                this.upgrade();
                return null;
            });
            MoreFiles.mkdir((Path)markerFile.getParent());
            MoreFiles.touch((Path)markerFile);
        }
        log.debug("Released upgrade task lock {}", (Object)KEY_TASK_LOCK);
    }

    private void upgrade() {
        if (this.userDao.findServiceUserByName("bitbucket.system-user", true) == null) {
            InternalServiceUser systemUser = this.userDao.create(((InternalServiceUser.Builder)new InternalServiceUser.Builder().active(true).displayName("Bitbucket").label("bot").name("bitbucket.system-user")).build());
            this.avatarRepository.store(AvatarType.USER, systemUser.getId(), (AvatarSupplier)new ResourceAvatarSupplier("avatars/system-user/system-user.png"));
            log.info("Successfully created system service user");
        } else {
            log.info("Unable to create system service user as user with the same name already exists. The upgrade task will not be re-run, and the existing user will be used as the system service user.");
        }
    }
}

