/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.util;

import com.atlassian.bitbucket.util.FilteredPageImpl;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;

public class InternalPageUtils {
    private static final long FETCH_GROWTH_FACTOR = 4L;

    @Nonnull
    public static <T> Page<T> filterPages(PageProvider<T> provider, Predicate<? super T> predicate, PageRequest request, int fetchCeiling) {
        Preconditions.checkArgument((fetchCeiling > 0 ? 1 : 0) != 0, (Object)"fetchCeiling must be > 0");
        fetchCeiling = Math.min(fetchCeiling, 0x100000);
        int internalStart = request.getStart();
        int internalLimit = Math.min(request.getLimit() * 2, fetchCeiling);
        int pageLimit = request.getLimit() + 1;
        TreeMap results = new TreeMap();
        block0: while (true) {
            PageRequest internalRequest = PageUtils.newRequest((int)internalStart, (int)internalLimit);
            Page internalPage = provider.get(internalRequest);
            for (Map.Entry entry : internalPage.getOrdinalIndexedValues().entrySet()) {
                if (!predicate.test(entry.getValue())) continue;
                results.put((Integer)entry.getKey(), entry.getValue());
                if (results.size() < pageLimit) continue;
                break block0;
            }
            PageRequest nextRequest = internalPage.getNextPageRequest();
            if (nextRequest == null) break;
            internalStart = nextRequest.getStart();
            internalLimit = Math.min(Ints.saturatedCast((long)((long)internalLimit * 4L)), fetchCeiling);
        }
        int size = results.size();
        boolean lastPage = size < pageLimit;
        int pageSize = lastPage ? size : request.getLimit();
        return new FilteredPageImpl(request, pageSize, results, lastPage);
    }
}

